/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.path.Path;
import com.yahoo.schema.DistributableResource;
import com.yahoo.schema.FeatureNames;
import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Case;
import com.yahoo.schema.document.HnswIndexParams;
import com.yahoo.schema.document.MatchAlgorithm;
import com.yahoo.schema.document.MatchType;
import com.yahoo.schema.document.Sorting;
import com.yahoo.schema.document.Stemming;
import com.yahoo.schema.fieldoperation.IndexingOperation;
import com.yahoo.schema.parser.CharStream;
import com.yahoo.schema.parser.DictionaryOption;
import com.yahoo.schema.parser.ParseException;
import com.yahoo.schema.parser.ParsedAnnotation;
import com.yahoo.schema.parser.ParsedAttribute;
import com.yahoo.schema.parser.ParsedDocument;
import com.yahoo.schema.parser.ParsedDocumentSummary;
import com.yahoo.schema.parser.ParsedField;
import com.yahoo.schema.parser.ParsedFieldSet;
import com.yahoo.schema.parser.ParsedIndex;
import com.yahoo.schema.parser.ParsedIndexingOp;
import com.yahoo.schema.parser.ParsedMatchSettings;
import com.yahoo.schema.parser.ParsedRankFunction;
import com.yahoo.schema.parser.ParsedRankProfile;
import com.yahoo.schema.parser.ParsedSchema;
import com.yahoo.schema.parser.ParsedSorting;
import com.yahoo.schema.parser.ParsedStruct;
import com.yahoo.schema.parser.ParsedSummaryField;
import com.yahoo.schema.parser.ParsedType;
import com.yahoo.schema.parser.SchemaParserConstants;
import com.yahoo.schema.parser.SchemaParserTokenManager;
import com.yahoo.schema.parser.SimpleCharStream;
import com.yahoo.schema.parser.Token;
import com.yahoo.schema.parser.Utils;
import com.yahoo.search.query.ranking.Diversity;
import com.yahoo.searchlib.rankingexpression.FeatureList;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.MixedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;

public class SchemaParser
implements SchemaParserConstants {
    private DeployLogger deployLogger;
    private ModelContext.Properties properties;
    public SchemaParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[228];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private final JJCalls[] jj_2_rtns = new JJCalls[10];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public SchemaParser(SimpleCharStream stream, DeployLogger deployLogger, ModelContext.Properties properties) {
        this(stream);
        this.deployLogger = deployLogger;
        this.properties = properties;
    }

    private IndexingOperation newIndexingOperation(boolean multiline) throws ParseException {
        return this.newIndexingOperation(multiline, (Linguistics)new SimpleLinguistics(), Embedder.throwsOnUse.asMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexingOperation newIndexingOperation(boolean multiline, Linguistics linguistics, Map<String, Embedder> embedders) throws ParseException {
        SimpleCharStream input = (SimpleCharStream)this.token_source.input_stream;
        if (this.token.next != null) {
            input.backup(this.token.next.image.length());
        }
        try {
            IndexingOperation indexingOperation = IndexingOperation.fromStream(input, multiline, linguistics, embedders);
            return indexingOperation;
        }
        finally {
            this.token.next = null;
            this.jj_ntk = -1;
        }
    }

    private FeatureList getFeatureList(String image) throws ParseException {
        try {
            return new FeatureList(image);
        }
        catch (com.yahoo.searchlib.rankingexpression.parser.ParseException e) {
            throw (ParseException)new ParseException("Could not parse feature list '" + image + "' at line " + this.token_source.input_stream.getBeginLine() + ", column " + this.token_source.input_stream.getBeginColumn() + ".").initCause(e);
        }
    }

    public final ParsedSchema schema() throws ParseException {
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8, 9 -> this.rootSchema();
            case 0, 16 -> this.rootDocument();
            default -> {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final ParsedSchema rootSchema() throws ParseException {
        String inherited = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String name = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                inherited = this.identifier();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        ParsedSchema schema = new ParsedSchema(name);
        if (inherited != null) {
            schema.inherit(inherited);
        }
        this.lbrace();
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 16: 
                case 22: 
                case 24: 
                case 26: 
                case 28: 
                case 32: 
                case 36: 
                case 47: 
                case 48: 
                case 55: 
                case 58: 
                case 59: 
                case 86: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block16;
                }
            }
            this.rootSchemaItem(schema);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        continue block16;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(0);
        return schema;
    }

    public final void rootSchemaItem(ParsedSchema schema) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                this.document(schema);
                break;
            }
            case 59: {
                this.rawAsBase64(schema);
                break;
            }
            case 86: {
                this.searchStemming(schema);
                break;
            }
            case 28: {
                this.importField(schema);
                break;
            }
            case 47: {
                this.rankingConstant(schema);
                break;
            }
            case 55: 
            case 58: {
                this.rankProfile(schema);
                break;
            }
            case 32: {
                this.documentSummary(schema);
                break;
            }
            case 24: {
                this.fieldOutsideDoc(schema);
                break;
            }
            case 36: {
                this.indexOutsideDoc(schema);
                break;
            }
            case 22: {
                this.structOutside(schema);
                break;
            }
            case 6: {
                this.annotationOutside(schema);
                break;
            }
            case 26: {
                this.fieldSet(schema);
                break;
            }
            case 48: {
                this.onnxModelInSchema(schema);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final ParsedSchema rootDocument() throws ParseException {
        ParsedSchema schema = null;
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block6;
                }
            }
            schema = this.rootDocumentItem(schema);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(0);
        return schema;
    }

    public final ParsedSchema rootDocumentItem(ParsedSchema schema) throws ParseException {
        ParsedDocument doc = null;
        doc = this.namedDocument();
        if (schema == null) {
            schema = new ParsedSchema(doc.name());
        }
        schema.addDocument(doc);
        schema.setDocumentWithoutSchema();
        return schema;
    }

    public final void document(ParsedSchema schema) throws ParseException {
        String name = schema.name();
        this.jj_consume_token(16);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block21;
                }
            }
            this.jj_consume_token(5);
        }
        ParsedDocument document = new ParsedDocument(name);
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsDocument(document);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        this.jj_consume_token(128);
        block23: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block23;
                }
            }
            this.jj_consume_token(5);
        }
        block24: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 22: 
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block24;
                }
            }
            this.documentBody(document);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        continue block24;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
        schema.addDocument(document);
    }

    public final ParsedDocument namedDocument() throws ParseException {
        this.jj_consume_token(16);
        String name = this.identifier();
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(5);
        }
        ParsedDocument document = new ParsedDocument(name);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsDocument(document);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        this.jj_consume_token(128);
        block20: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block20;
                }
            }
            this.jj_consume_token(5);
        }
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 22: 
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block21;
                }
            }
            this.documentBody(document);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        continue block21;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
        return document;
    }

    public final void documentBody(ParsedDocument document) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: {
                this.annotation(document);
                break;
            }
            case 22: {
                this.structInside(document);
                break;
            }
            case 24: {
                this.fieldInsideDoc(document);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void rawAsBase64(ParsedSchema schema) throws ParseException {
        boolean enabled = false;
        this.jj_consume_token(59);
        enabled = true;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 96: {
                        this.jj_consume_token(96);
                        break block0;
                    }
                    case 97: {
                        this.jj_consume_token(97);
                        enabled = false;
                        break block0;
                    }
                }
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        schema.enableRawAsBase64(enabled);
    }

    public final void inheritsStruct(ParsedStruct struct) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifier();
        struct.inherit(name);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 132: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(132);
            name = this.identifier();
            struct.inherit(name);
        }
    }

    public final void inheritsDocument(ParsedDocument document) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifier();
        document.inherit(name);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 132: {
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(132);
            name = this.identifier();
            document.inherit(name);
        }
    }

    public final void fieldInsideDoc(ParsedDocument document) throws ParseException {
        ParsedField field = this.field();
        document.addField(field);
    }

    public final void fieldOutsideDoc(ParsedSchema schema) throws ParseException {
        ParsedField field = this.field();
        schema.addField(field);
    }

    public final ParsedField field() throws ParseException {
        this.jj_consume_token(24);
        String name = this.identifier();
        this.jj_consume_token(35);
        ParsedType type = this.dataType();
        if (name != null && Schema.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        ParsedField field = new ParsedField(name, type);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 30: 
                case 31: 
                case 33: 
                case 34: 
                case 36: 
                case 60: 
                case 70: 
                case 71: 
                case 72: 
                case 86: 
                case 87: 
                case 92: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 109: 
                case 134: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block6;
                }
            }
            this.fieldBody(field);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
        return field;
    }

    public final void fieldSet(ParsedSchema schema) throws ParseException {
        this.jj_consume_token(26);
        String name = this.identifier();
        this.lbrace();
        ParsedFieldSet fieldSet = new ParsedFieldSet(name);
        block18: while (true) {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: {
                    this.jj_consume_token(25);
                    this.jj_consume_token(130);
                    name = this.identifier();
                    fieldSet.addField(name);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 132: {
                                break;
                            }
                            default: {
                                this.jj_la1[30] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_consume_token(132);
                        name = this.identifier();
                        fieldSet.addField(name);
                    }
                }
                case 99: {
                    this.jj_consume_token(99);
                    this.jj_consume_token(130);
                    fieldSet.addQueryCommand(switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 133, 134, 135, 136, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 198, 200, 201, 202, 208 -> this.identifierWithDash();
                        case 196, 197 -> this.quotedString();
                        default -> {
                            this.jj_la1[31] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    });
                    break;
                }
                case 101: {
                    this.matchSettings(fieldSet.matchSettings());
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(5);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: 
                case 99: 
                case 101: {
                    continue block18;
                }
            }
            break;
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(129);
        schema.addFieldSet(fieldSet);
    }

    public final void annotationOutside(ParsedSchema schema) throws ParseException {
        this.jj_consume_token(6);
        String name = this.identifier();
        ParsedAnnotation type = new ParsedAnnotation(name);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsAnnotation(type);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[35] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        this.lbrace();
        this.annotationBody(type);
        this.jj_consume_token(129);
        schema.addAnnotation(type);
    }

    public final void annotation(ParsedDocument document) throws ParseException {
        this.jj_consume_token(6);
        String name = this.identifier();
        ParsedAnnotation type = new ParsedAnnotation(name);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsAnnotation(type);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[37] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        this.lbrace();
        this.annotationBody(type);
        this.jj_consume_token(129);
        document.addAnnotation(type);
    }

    public final void annotationBody(ParsedAnnotation type) throws ParseException {
        ParsedStruct struct = new ParsedStruct("annotation." + type.name());
        boolean seenField = false;
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block6;
                }
            }
            this.structFieldDefinition(struct);
            seenField = true;
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        if (seenField) {
            type.setStruct(struct);
        }
    }

    public final void inheritsAnnotation(ParsedAnnotation annotation) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifier();
        annotation.inherit(name);
    }

    public final void structInside(ParsedDocument document) throws ParseException {
        ParsedStruct struct = this.structDefinition();
        document.addStruct(struct);
    }

    public final void structOutside(ParsedSchema schema) throws ParseException {
        ParsedStruct struct = this.structDefinition();
        schema.addStruct(struct);
    }

    public final ParsedStruct structDefinition() throws ParseException {
        this.jj_consume_token(22);
        String name = this.identifier();
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(5);
        }
        ParsedStruct struct = new ParsedStruct(name);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsStruct(struct);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[42] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        this.lbrace();
        block17: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block17;
                }
            }
            this.structFieldDefinition(struct);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[45] = this.jj_gen;
                        continue block17;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
        return struct;
    }

    public final ParsedType dataType() throws ParseException {
        String typeName = null;
        boolean isArrayOldStyle = false;
        ParsedType mapType = null;
        ParsedType arrayType = null;
        ParsedType wsetType = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(133);
            this.jj_consume_token(206);
            arrayType = this.dataType();
            this.jj_consume_token(207);
            return ParsedType.arrayOf(arrayType);
        }
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(134);
            this.jj_consume_token(206);
            wsetType = this.dataType();
            this.jj_consume_token(207);
            return ParsedType.wsetOf(wsetType);
        }
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            mapType = this.mapDataType();
            return mapType;
        }
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            mapType = this.annotationRefDataType();
            return mapType;
        }
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            TensorType tensorType = this.tensorType("Field type");
            return ParsedType.tensorType(tensorType);
        }
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            this.jj_consume_token(136);
            this.jj_consume_token(206);
            ParsedType referenceType = this.referenceType();
            this.jj_consume_token(207);
            return ParsedType.documentRef(referenceType);
        }
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                typeName = this.identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 212: {
                        this.jj_consume_token(212);
                        isArrayOldStyle = true;
                        break block0;
                    }
                }
                this.jj_la1[46] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ParsedType type = ParsedType.fromName(typeName);
        if (isArrayOldStyle) {
            this.deployLogger.logApplicationPackage(Level.WARNING, "Data type syntax '" + typeName + "[]' is deprecated, use 'array<" + typeName + ">' instead.");
            type = ParsedType.arrayOf(type);
        }
        return type;
    }

    public final ParsedType referenceType() throws ParseException {
        String documentName = this.identifier();
        return ParsedType.documentType(documentName);
    }

    public final ParsedType annotationRefDataType() throws ParseException {
        this.jj_consume_token(7);
        this.jj_consume_token(206);
        String targetName = this.identifier();
        this.jj_consume_token(207);
        return ParsedType.annotationRef(targetName);
    }

    public final ParsedType mapDataType() throws ParseException {
        this.jj_consume_token(135);
        this.jj_consume_token(206);
        ParsedType keyType = this.dataType();
        this.jj_consume_token(132);
        ParsedType valType = this.dataType();
        this.jj_consume_token(207);
        return ParsedType.mapType(keyType, valType);
    }

    public final void structFieldDefinition(ParsedStruct struct) throws ParseException {
        this.jj_consume_token(24);
        String name = this.identifier();
        this.jj_consume_token(35);
        ParsedType type = this.dataType();
        if (name != null && Schema.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        ParsedField field = new ParsedField(name, type);
        this.lbrace();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 109: {
                this.id(field);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 101: {
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                    break block13;
                }
            }
            this.matchSettings(field.matchSettings());
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[51] = this.jj_gen;
                        continue block13;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
        struct.addField(field);
    }

    public final void structField(ParsedField field) throws ParseException {
        this.jj_consume_token(27);
        String name = this.identifier();
        if (name != null && Schema.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        ParsedField structField = new ParsedField(name, null);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 30: 
                case 31: 
                case 60: 
                case 70: 
                case 99: 
                case 101: 
                case 102: {
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    break block6;
                }
            }
            this.structFieldBody(structField);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[53] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
        field.addStructField(structField);
    }

    public final void fieldBody(ParsedField field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 100: {
                this.alias(field);
                break;
            }
            case 70: {
                this.attribute(field);
                break;
            }
            case 92: {
                this.bolding(field);
                break;
            }
            case 72: {
                this.dictionary(field);
                break;
            }
            case 86: {
                this.fieldStemming(field);
                break;
            }
            case 109: {
                this.id(field);
                break;
            }
            case 60: {
                this.summaryInField(field);
                break;
            }
            case 36: {
                this.indexInsideField(field);
                break;
            }
            case 30: {
                this.indexing(field);
                break;
            }
            case 101: {
                this.matchSettings(field.matchSettings());
                break;
            }
            case 87: {
                this.normalizing(field);
                break;
            }
            case 99: {
                this.queryCommand(field);
                break;
            }
            case 102: {
                this.rank(field);
                break;
            }
            case 33: {
                this.rankType(field);
                break;
            }
            case 71: {
                this.fieldSorting(field);
                break;
            }
            case 27: {
                this.structField(field);
                break;
            }
            case 31: {
                this.summaryTo(field);
                break;
            }
            case 34: {
                this.weight(field);
                break;
            }
            case 134: {
                this.weightedset(field.getType());
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void structFieldBody(ParsedField field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 60: {
                this.summaryInField(field);
                break;
            }
            case 30: {
                this.indexing(field);
                break;
            }
            case 70: {
                this.attribute(field);
                break;
            }
            case 101: {
                this.matchSettings(field.matchSettings());
                break;
            }
            case 99: {
                this.queryCommand(field);
                break;
            }
            case 102: {
                this.rank(field);
                break;
            }
            case 27: {
                this.structField(field);
                break;
            }
            case 31: {
                this.summaryTo(field);
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void indexing(ParsedField field) throws ParseException {
        this.jj_consume_token(30);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                this.indexingOperation(field, false);
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
                this.indexingOperation(field, true);
            }
        }
    }

    public final void indexingOperation(ParsedField field, boolean multiLine) throws ParseException {
        IndexingOperation oldOp = this.newIndexingOperation(multiLine);
        ParsedIndexingOp newOp = new ParsedIndexingOp(oldOp.getScript());
        field.setIndexingOperation(newOp);
    }

    public final void summaryTo(ParsedField field) throws ParseException {
        String name = field.name();
        this.jj_consume_token(31);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        this.jj_consume_token(130);
        String destination = this.identifier();
        ParsedSummaryField psf = field.summaryFieldFor(name);
        psf.addDestination(destination);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 132: {
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(132);
            destination = this.identifier();
            psf.addDestination(destination);
        }
    }

    public final void weight(ParsedField field) throws ParseException {
        this.jj_consume_token(34);
        this.jj_consume_token(130);
        int num = this.integer();
        field.setWeight(num);
    }

    public final void weightedset(ParsedType fieldType) throws ParseException {
        this.jj_consume_token(134);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                this.weightedsetBody(fieldType);
                break;
            }
            case 5: 
            case 128: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 138: 
                        case 139: {
                            break;
                        }
                        default: {
                            this.jj_la1[59] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.weightedsetBody(fieldType);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[60] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(129);
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void weightedsetBody(ParsedType type) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 138: {
                this.jj_consume_token(138);
                type.setCreateIfNonExistent(true);
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                type.setRemoveIfZero(true);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void rankType(ParsedField field) throws ParseException {
        String indexName = "";
        this.jj_consume_token(33);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                indexName = this.identifier();
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
            }
        }
        this.jj_consume_token(130);
        String typeName = this.identifier();
        field.addRankType(indexName, typeName);
    }

    public final void attribute(ParsedField field) throws ParseException {
        String name = field.name();
        this.jj_consume_token(70);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
            }
        }
        ParsedAttribute attr = field.attributeFor(name);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                this.attributeSetting(attr);
                break;
            }
            case 5: 
            case 128: {
                this.lbrace();
                block13: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 71: 
                        case 100: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 159: {
                            break;
                        }
                        default: {
                            this.jj_la1[65] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.attributeSetting(attr);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[66] = this.jj_gen;
                                continue block13;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(129);
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void fieldSorting(ParsedField field) throws ParseException {
        this.sorting(field.sortInfo());
    }

    public final void attributeSorting(ParsedAttribute attribute) throws ParseException {
        this.sorting(attribute.sortInfo());
    }

    public final void sorting(ParsedSorting sort) throws ParseException {
        this.jj_consume_token(71);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                this.sortingSetting(sort);
                break;
            }
            case 5: 
            case 128: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 73: 
                        case 74: 
                        case 78: 
                        case 79: 
                        case 80: {
                            break;
                        }
                        default: {
                            this.jj_la1[68] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.sortingSetting(sort);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[69] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(129);
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void sortingSetting(ParsedSorting sorting) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                sorting.setAscending();
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                sorting.setDescending();
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                this.jj_consume_token(130);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 75: {
                        this.jj_consume_token(75);
                        sorting.setFunction(Sorting.Function.UCA);
                        break block0;
                    }
                    case 76: {
                        this.jj_consume_token(76);
                        sorting.setFunction(Sorting.Function.RAW);
                        break block0;
                    }
                    case 77: {
                        this.jj_consume_token(77);
                        sorting.setFunction(Sorting.Function.LOWERCASE);
                        break block0;
                    }
                }
                this.jj_la1[71] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 80: {
                this.jj_consume_token(80);
                this.jj_consume_token(130);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 81: {
                        this.jj_consume_token(81);
                        sorting.setStrength(Sorting.Strength.PRIMARY);
                        break block0;
                    }
                    case 82: {
                        this.jj_consume_token(82);
                        sorting.setStrength(Sorting.Strength.SECONDARY);
                        break block0;
                    }
                    case 83: {
                        this.jj_consume_token(83);
                        sorting.setStrength(Sorting.Strength.TERTIARY);
                        break block0;
                    }
                    case 84: {
                        this.jj_consume_token(84);
                        sorting.setStrength(Sorting.Strength.QUATERNARY);
                        break block0;
                    }
                    case 85: {
                        this.jj_consume_token(85);
                        sorting.setStrength(Sorting.Strength.IDENTICAL);
                        break block0;
                    }
                }
                this.jj_la1[72] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 79: {
                this.jj_consume_token(79);
                this.jj_consume_token(130);
                String locale = this.identifierWithDash();
                sorting.setLocale(locale);
                break;
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void attributeSetting(ParsedAttribute attribute) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 123: {
                this.jj_consume_token(123);
                attribute.setFastRank(true);
                break;
            }
            case 124: {
                this.jj_consume_token(124);
                attribute.setFastSearch(true);
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                attribute.setFastAccess(true);
                break;
            }
            case 121: {
                this.jj_consume_token(121);
                attribute.setMutable(true);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                attribute.setPaged(true);
                break;
            }
            case 118: {
                this.jj_consume_token(118);
                this.deployLogger.logApplicationPackage(Level.WARNING, "'enable-bit-vectors' is deprecated and void -> remove it. Will be removed in vespa-9");
                break;
            }
            case 119: {
                this.jj_consume_token(119);
                attribute.setEnableOnlyBitVector(true);
                break;
            }
            case 71: {
                this.attributeSorting(attribute);
                break;
            }
            case 100: {
                this.jj_consume_token(100);
                String aliasedName = attribute.name();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 115: 
                    case 117: 
                    case 121: 
                    case 122: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 143: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 156: 
                    case 158: 
                    case 191: 
                    case 192: 
                    case 193: 
                    case 194: 
                    case 198: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 208: {
                        aliasedName = this.identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[74] = this.jj_gen;
                    }
                }
                this.jj_consume_token(130);
                String alias = this.identifierWithDash();
                attribute.addAlias(aliasedName, alias);
                break;
            }
            case 159: {
                this.jj_consume_token(159);
                this.jj_consume_token(130);
                String str = this.identifierWithDash();
                attribute.setDistanceMetric(str);
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void summaryInDocument(ParsedDocumentSummary docsum) throws ParseException {
        ParsedType type = null;
        this.jj_consume_token(60);
        String name = this.identifierWithDash();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                type = this.dataType();
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
            }
        }
        this.lbrace();
        ParsedSummaryField psf = new ParsedSummaryField(name, type);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 92: 
                case 110: 
                case 111: {
                    break;
                }
                default: {
                    this.jj_la1[77] = this.jj_gen;
                    break block9;
                }
            }
            this.summaryItem(psf);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[78] = this.jj_gen;
                        continue block9;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
        ParsedSummaryField old = docsum.addField(psf);
        if (old != null) {
            this.deployLogger.logApplicationPackage(Level.WARNING, "Summary field '" + psf.name() + "' is defined twice in document-summary '" + docsum.name() + "'");
        }
    }

    public final void summaryInField(ParsedField field) throws ParseException {
        this.jj_consume_token(60);
        if (this.jj_2_7(2)) {
            this.summaryInFieldShort(field);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 115: 
                case 117: 
                case 121: 
                case 122: 
                case 128: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 143: 
                case 149: 
                case 150: 
                case 151: 
                case 156: 
                case 158: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 198: 
                case 200: 
                case 201: 
                case 202: 
                case 208: {
                    this.summaryInFieldLong(field);
                    break;
                }
                default: {
                    this.jj_la1[79] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void summaryInFieldShort(ParsedField field) throws ParseException {
        String name = field.name();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
            }
        }
        ParsedSummaryField psf = field.summaryFieldFor(name);
        this.jj_consume_token(130);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 63: {
                this.jj_consume_token(63);
                psf.setDynamic();
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                psf.setMatchedElementsOnly();
                break;
            }
            case 61: 
            case 62: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 61: {
                        this.jj_consume_token(61);
                        break;
                    }
                    case 62: {
                        this.jj_consume_token(62);
                        break;
                    }
                    default: {
                        this.jj_la1[81] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                psf.setFull();
                break;
            }
            default: {
                this.jj_la1[82] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void summaryInFieldLong(ParsedField field) throws ParseException {
        String name = field.name();
        ParsedType type = field.getType();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                name = this.identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 35: {
                        this.jj_consume_token(35);
                        type = this.dataType();
                        break block0;
                    }
                }
                this.jj_la1[83] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
            }
        }
        this.lbrace();
        ParsedSummaryField psf = field.summaryFieldFor(name, type);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 92: 
                case 110: 
                case 111: {
                    break;
                }
                default: {
                    this.jj_la1[85] = this.jj_gen;
                    break block12;
                }
            }
            this.summaryItem(psf);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[86] = this.jj_gen;
                        continue block12;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
    }

    public final void summaryItem(ParsedSummaryField field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                this.summaryTransform(field);
                break;
            }
            case 92: {
                this.summaryBolding(field);
                break;
            }
            case 110: {
                this.summarySourceList(field);
                break;
            }
            case 111: {
                this.summaryDestinationList(field);
                break;
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void summaryTransform(ParsedSummaryField field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 63: {
                this.jj_consume_token(63);
                field.setDynamic();
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                field.setMatchedElementsOnly();
                break;
            }
            case 61: 
            case 62: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 61: {
                        this.jj_consume_token(61);
                        break;
                    }
                    case 62: {
                        this.jj_consume_token(62);
                        break;
                    }
                    default: {
                        this.jj_la1[88] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                field.setFull();
                break;
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void summaryBolding(ParsedSummaryField field) throws ParseException {
        this.jj_consume_token(92);
        this.jj_consume_token(130);
        boolean bold = this.bool();
        field.setBold(bold);
    }

    public final void summarySourceList(ParsedSummaryField field) throws ParseException {
        block6: while (true) {
            this.jj_consume_token(110);
            this.jj_consume_token(130);
            String str = this.identifier();
            field.addSource(str);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 132: {
                        break;
                    }
                    default: {
                        this.jj_la1[90] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(132);
                str = this.identifier();
                field.addSource(str);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 110: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[91] = this.jj_gen;
    }

    public final void summaryDestinationList(ParsedSummaryField field) throws ParseException {
        this.jj_consume_token(111);
        this.jj_consume_token(130);
        String str = this.identifier();
        field.addDestination(str);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 132: {
                    break;
                }
                default: {
                    this.jj_la1[92] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(132);
            str = this.identifier();
            field.addDestination(str);
        }
    }

    public final void fieldStemming(ParsedField field) throws ParseException {
        this.jj_consume_token(86);
        this.jj_consume_token(130);
        String setting = this.identifierWithDash();
        field.setStemming(Stemming.get(setting));
    }

    public final void searchStemming(ParsedSchema schema) throws ParseException {
        this.jj_consume_token(86);
        this.jj_consume_token(130);
        String setting = this.identifierWithDash();
        schema.setStemming(Stemming.get(setting));
    }

    public final void normalizing(ParsedField field) throws ParseException {
        this.jj_consume_token(87);
        this.jj_consume_token(130);
        String setting = this.identifierWithDash();
        field.setNormalizing(setting);
    }

    public final void bolding(ParsedField field) throws ParseException {
        this.jj_consume_token(92);
        this.jj_consume_token(130);
        boolean bold = this.bool();
        field.setBolding(bold);
    }

    public final void dictionary(ParsedField field) throws ParseException {
        this.jj_consume_token(72);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                this.dictionarySetting(field);
                break;
            }
            case 5: 
            case 128: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: {
                            break;
                        }
                        default: {
                            this.jj_la1[93] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.dictionarySetting(field);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[94] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(129);
                break;
            }
            default: {
                this.jj_la1[95] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void dictionarySetting(ParsedField field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 88: {
                this.jj_consume_token(88);
                field.dictionary(DictionaryOption.HASH);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                field.dictionary(DictionaryOption.BTREE);
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                field.dictionary(DictionaryOption.CASED);
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                field.dictionary(DictionaryOption.UNCASED);
                break;
            }
            default: {
                this.jj_la1[96] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void queryCommand(ParsedField field) throws ParseException {
        this.jj_consume_token(99);
        this.jj_consume_token(130);
        field.addQueryCommand(switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 133, 134, 135, 136, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 198, 200, 201, 202, 208 -> this.identifierWithDash();
            case 196, 197 -> this.quotedString();
            default -> {
                this.jj_la1[97] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        });
    }

    public final void alias(ParsedField field) throws ParseException {
        String aliasedName = field.name();
        this.jj_consume_token(100);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                aliasedName = this.identifier();
                break;
            }
            default: {
                this.jj_la1[98] = this.jj_gen;
            }
        }
        this.jj_consume_token(130);
        String alias = this.identifierWithDash();
        field.addAlias(aliasedName, alias);
    }

    public final void matchSettings(ParsedMatchSettings matchInfo) throws ParseException {
        this.jj_consume_token(101);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                this.matchType(matchInfo);
                break;
            }
            case 5: 
            case 128: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 90: 
                        case 91: 
                        case 104: 
                        case 107: {
                            break;
                        }
                        default: {
                            this.jj_la1[99] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.matchItem(matchInfo);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[100] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(129);
                break;
            }
            default: {
                this.jj_la1[101] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void matchType(ParsedMatchSettings matchInfo) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: {
                this.jj_consume_token(38);
                matchInfo.setType(MatchType.TEXT);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                matchInfo.setType(MatchType.TEXT);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                matchInfo.setType(MatchType.WORD);
                break;
            }
            case 104: {
                this.jj_consume_token(104);
                matchInfo.setType(MatchType.EXACT);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                matchInfo.setType(MatchType.GRAM);
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                matchInfo.setCase(Case.CASED);
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                matchInfo.setCase(Case.UNCASED);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                matchInfo.setAlgorithm(MatchAlgorithm.PREFIX);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                matchInfo.setAlgorithm(MatchAlgorithm.SUBSTRING);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                matchInfo.setAlgorithm(MatchAlgorithm.SUFFIX);
                break;
            }
            default: {
                this.jj_la1[102] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void matchItem(ParsedMatchSettings matchInfo) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 90: 
            case 91: 
            case 104: {
                this.matchType(matchInfo);
                break;
            }
            case 107: {
                this.exactTerminator(matchInfo);
                break;
            }
            case 42: {
                this.gramSize(matchInfo);
                break;
            }
            case 43: {
                this.matchSize(matchInfo);
                break;
            }
            default: {
                this.jj_la1[103] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void exactTerminator(ParsedMatchSettings matchInfo) throws ParseException {
        this.jj_consume_token(107);
        this.jj_consume_token(130);
        String terminator = this.quotedString();
        matchInfo.setExactTerminator(terminator);
    }

    public final void gramSize(ParsedMatchSettings matchInfo) throws ParseException {
        this.jj_consume_token(42);
        this.jj_consume_token(130);
        int gramSize = this.integer();
        matchInfo.setGramSize(gramSize);
    }

    public final void matchSize(ParsedMatchSettings matchInfo) throws ParseException {
        this.jj_consume_token(43);
        this.jj_consume_token(130);
        int matchSize = this.integer();
        matchInfo.setMaxLength(matchSize);
    }

    public final void rank(ParsedField field) throws ParseException {
        this.jj_consume_token(102);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                this.rankSetting(field);
                break;
            }
            case 5: 
            case 128: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 103: 
                        case 105: 
                        case 106: {
                            break;
                        }
                        default: {
                            this.jj_la1[104] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.rankSetting(field);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[105] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(129);
                break;
            }
            default: {
                this.jj_la1[106] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void rankSetting(ParsedField field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 103: {
                this.jj_consume_token(103);
                field.setLiteral(true);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                field.setNormal(true);
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                field.setFilter(true);
                break;
            }
            default: {
                this.jj_la1[107] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void id(ParsedField field) throws ParseException {
        this.jj_consume_token(109);
        this.jj_consume_token(130);
        int fieldId = this.integer();
        field.setId(fieldId);
    }

    public final void documentSummary(ParsedSchema schema) throws ParseException {
        ParsedDocumentSummary summary;
        block13: {
            this.jj_consume_token(32);
            String name = this.identifierWithDash();
            summary = new ParsedDocumentSummary(name);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 23: {
                    this.inheritsDocumentSummary(summary);
                    break;
                }
                default: {
                    this.jj_la1[108] = this.jj_gen;
                }
            }
            this.lbrace();
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: 
                    case 60: 
                    case 113: 
                    case 114: {
                        break;
                    }
                    default: {
                        this.jj_la1[109] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 113: {
                        this.jj_consume_token(113);
                        summary.setFromDisk(true);
                        continue block12;
                    }
                    case 114: {
                        this.jj_consume_token(114);
                        summary.setOmitSummaryFeatures(true);
                        continue block12;
                    }
                    case 60: {
                        this.documentSummaryItem(summary);
                        continue block12;
                    }
                    case 5: {
                        this.jj_consume_token(5);
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[110] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(129);
        schema.addDocumentSummary(summary);
    }

    public final void inheritsDocumentSummary(ParsedDocumentSummary documentSummary) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifierWithDash();
        documentSummary.inherit(name);
    }

    public final void documentSummaryItem(ParsedDocumentSummary summary) throws ParseException {
        this.summaryInDocument(summary);
    }

    public final void indexOutsideDoc(ParsedSchema schema) throws ParseException {
        this.jj_consume_token(36);
        String indexName = this.identifier();
        ParsedIndex op = new ParsedIndex(indexName);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                this.indexBody(op);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 132: {
                            break;
                        }
                        default: {
                            this.jj_la1[111] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(132);
                    this.indexBody(op);
                }
            }
            case 5: 
            case 128: {
                this.lbrace();
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 44: 
                        case 86: 
                        case 100: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: {
                            break;
                        }
                        default: {
                            this.jj_la1[112] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.indexBody(op);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[113] = this.jj_gen;
                                continue block14;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(129);
                break;
            }
            default: {
                this.jj_la1[114] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        schema.addIndex(op);
    }

    public final void indexInsideField(ParsedField field) throws ParseException {
        String indexName = field.name();
        this.jj_consume_token(36);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                indexName = this.identifier();
                break;
            }
            default: {
                this.jj_la1[115] = this.jj_gen;
            }
        }
        ParsedIndex op = new ParsedIndex(indexName);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                this.indexBody(op);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 132: {
                            break;
                        }
                        default: {
                            this.jj_la1[116] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(132);
                    this.indexBody(op);
                }
            }
            case 5: 
            case 128: {
                this.lbrace();
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 44: 
                        case 86: 
                        case 100: 
                        case 151: 
                        case 152: 
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: {
                            break;
                        }
                        default: {
                            this.jj_la1[117] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.indexBody(op);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[118] = this.jj_gen;
                                continue block17;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(129);
                break;
            }
            default: {
                this.jj_la1[119] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addIndex(op);
    }

    public final void indexBody(ParsedIndex index) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 44: {
                this.jj_consume_token(44);
                index.setPrefix(true);
                break;
            }
            case 100: {
                this.jj_consume_token(100);
                this.jj_consume_token(130);
                String str = this.identifierWithDash();
                index.addAlias(str);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                this.jj_consume_token(130);
                String str = this.identifierWithDash();
                index.setStemming(Stemming.get(str));
                break;
            }
            case 151: {
                this.jj_consume_token(151);
                this.jj_consume_token(130);
                int arity = this.integer();
                index.setArity(arity);
                break;
            }
            case 152: {
                this.jj_consume_token(152);
                this.jj_consume_token(130);
                long num = this.longValue();
                index.setLowerBound(num);
                break;
            }
            case 153: {
                this.jj_consume_token(153);
                this.jj_consume_token(130);
                long num = this.longValue();
                index.setUpperBound(num);
                break;
            }
            case 154: {
                this.jj_consume_token(154);
                this.jj_consume_token(130);
                double threshold = this.floatValue();
                index.setDensePostingListThreshold(threshold);
                break;
            }
            case 155: {
                this.jj_consume_token(155);
                index.setEnableBm25(true);
                break;
            }
            case 156: {
                this.hnswIndex(index);
                break;
            }
            default: {
                this.jj_la1[120] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void hnswIndex(ParsedIndex index) throws ParseException {
        HnswIndexParams.Builder params = new HnswIndexParams.Builder();
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            this.jj_consume_token(156);
            this.lbrace();
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 157: 
                    case 160: 
                    case 161: {
                        break;
                    }
                    default: {
                        this.jj_la1[121] = this.jj_gen;
                        break block9;
                    }
                }
                this.hnswIndexBody(params);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[122] = this.jj_gen;
                            continue block9;
                        }
                    }
                    this.jj_consume_token(5);
                }
                break;
            }
            this.jj_consume_token(129);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 156: {
                    this.jj_consume_token(156);
                    break;
                }
                default: {
                    this.jj_la1[123] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        index.setHnswIndexParams(params.build());
    }

    public final void hnswIndexBody(HnswIndexParams.Builder params) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 157: {
                this.jj_consume_token(157);
                this.jj_consume_token(130);
                int num = this.integer();
                params.setMaxLinksPerNode(num);
                break;
            }
            case 160: {
                this.jj_consume_token(160);
                this.jj_consume_token(130);
                int num = this.integer();
                params.setNeighborsToExploreAtInsert(num);
                break;
            }
            case 161: {
                this.jj_consume_token(161);
                this.jj_consume_token(130);
                boolean bool = this.bool();
                params.setMultiThreadedIndexing(bool);
                break;
            }
            default: {
                this.jj_la1[124] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void onnxModelInSchema(ParsedSchema schema) throws ParseException {
        OnnxModel onnxModel = this.onnxModel();
        schema.add(onnxModel);
    }

    public final void onnxModelInProfile(ParsedRankProfile profile) throws ParseException {
        OnnxModel onnxModel = this.onnxModel();
        profile.add(onnxModel);
    }

    public final OnnxModel onnxModel() throws ParseException {
        this.jj_consume_token(48);
        String name = this.identifier();
        OnnxModel onnxModel = new OnnxModel(name);
        this.lbrace();
        block6: while (true) {
            this.onnxModelItem(onnxModel);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[125] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(5);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 192: 
                case 193: 
                case 209: 
                case 210: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[126] = this.jj_gen;
        this.jj_consume_token(129);
        return onnxModel;
    }

    public final void onnxModelItem(OnnxModel onnxModel) throws ParseException {
        String path = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 192: {
                path = this.fileItem();
                onnxModel.setFileName(path);
                break;
            }
            case 193: {
                path = this.uriItem();
                onnxModel.setUri(path);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                this.jj_consume_token(130);
                int num = this.integer();
                onnxModel.setGpuDevice(num, false);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                this.jj_consume_token(130);
                int num = this.integer();
                onnxModel.setStatelessIntraOpThreads(num);
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                this.jj_consume_token(130);
                int num = this.integer();
                onnxModel.setStatelessInterOpThreads(num);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                this.jj_consume_token(130);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 53: {
                        this.jj_consume_token(53);
                        onnxModel.setStatelessExecutionMode("parallel");
                        break block0;
                    }
                    case 54: {
                        this.jj_consume_token(54);
                        onnxModel.setStatelessExecutionMode("sequential");
                        break block0;
                    }
                }
                this.jj_la1[127] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 209: {
                this.jj_consume_token(209);
                String name = this.token.image.substring(5, this.token.image.lastIndexOf(":")).trim();
                if (name.startsWith("\"")) {
                    name = name.substring(1, name.length() - 1);
                }
                String source = this.token.image.substring(this.token.image.lastIndexOf(":") + 1).trim();
                onnxModel.addInputNameMapping(name, source);
                break;
            }
            case 210: {
                this.jj_consume_token(210);
                String name = this.token.image.substring(6, this.token.image.lastIndexOf(":")).trim();
                if (name.startsWith("\"")) {
                    name = name.substring(1, name.length() - 1);
                }
                String as = this.token.image.substring(this.token.image.lastIndexOf(":") + 1).trim();
                onnxModel.addOutputNameMapping(name, as);
                break;
            }
            default: {
                this.jj_la1[128] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void rankingConstant(ParsedSchema schema) throws ParseException {
        String path = null;
        DistributableResource.PathType pathType = DistributableResource.PathType.FILE;
        TensorType type = null;
        this.jj_consume_token(47);
        String name = this.identifier();
        this.lbrace();
        block11: while (true) {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 192: {
                    path = this.fileItem();
                    pathType = DistributableResource.PathType.FILE;
                    break;
                }
                case 193: {
                    path = this.uriItem();
                    pathType = DistributableResource.PathType.URI;
                    break;
                }
                case 35: {
                    type = this.tensorTypeWithPrefix(this.rankingConstantErrorMessage(name));
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[129] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                }
                default: {
                    this.jj_la1[130] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 192: 
                case 193: {
                    continue block11;
                }
            }
            break;
        }
        this.jj_la1[131] = this.jj_gen;
        this.jj_consume_token(129);
        if (type == null) {
            throw new IllegalArgumentException("constant '" + name + "' must have a type");
        }
        if (path == null) {
            throw new IllegalArgumentException("constant '" + name + "' must have a file");
        }
        schema.add(new RankProfile.Constant(FeatureNames.asConstantFeature(name), type, path, pathType));
    }

    public final String fileItem() throws ParseException {
        this.jj_consume_token(192);
        this.jj_consume_token(130);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 203: {
                this.jj_consume_token(203);
                break;
            }
            case 202: {
                this.jj_consume_token(202);
                break;
            }
            case 194: {
                this.jj_consume_token(194);
                break;
            }
            default: {
                this.jj_la1[132] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String path = Path.fromString((String)this.token.image).getRelative();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[133] = this.jj_gen;
                    break block8;
                }
            }
            this.jj_consume_token(5);
        }
        return path;
    }

    public final String uriItem() throws ParseException {
        this.jj_consume_token(193);
        this.jj_consume_token(130);
        this.jj_consume_token(205);
        String path = this.token.image;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[134] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(5);
        }
        return path;
    }

    public final String rankingConstantErrorMessage(String name) throws ParseException {
        return "For ranking constant ' " + name + "'";
    }

    public final void rankProfile(ParsedSchema schema) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            default: {
                this.jj_la1[135] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String name = this.identifierWithDash();
        ParsedRankProfile profile = new ParsedRankProfile(name);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsRankProfile(profile);
                break;
            }
            default: {
                this.jj_la1[136] = this.jj_gen;
            }
        }
        this.lbrace();
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 15: 
                case 33: 
                case 34: 
                case 37: 
                case 48: 
                case 56: 
                case 78: 
                case 102: 
                case 108: 
                case 140: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 181: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 191: {
                    break;
                }
                default: {
                    this.jj_la1[137] = this.jj_gen;
                    break block13;
                }
            }
            this.rankProfileItem(schema, profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[138] = this.jj_gen;
                        continue block13;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
        schema.addRankProfile(profile);
    }

    public final void rankProfileItem(ParsedSchema schema, ParsedRankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                this.fieldRankType(profile);
                break;
            }
            case 34: {
                this.fieldWeight(profile);
                break;
            }
            case 102: {
                this.fieldRankFilter(profile);
                break;
            }
            case 146: {
                this.firstPhase(profile);
                break;
            }
            case 140: {
                this.matchPhase(profile);
                break;
            }
            case 78: 
            case 149: {
                this.function(profile);
                break;
            }
            case 56: {
                this.mutate(profile);
                break;
            }
            case 108: {
                this.ignoreRankFeatures(profile);
                break;
            }
            case 183: {
                this.numThreadsPerSearch(profile);
                break;
            }
            case 184: {
                this.minHitsPerThread(profile);
                break;
            }
            case 185: {
                this.numSearchPartitions(profile);
                break;
            }
            case 186: {
                this.termwiseLimit(profile);
                break;
            }
            case 187: {
                this.postFilterThreshold(profile);
                break;
            }
            case 188: {
                this.approximateThreshold(profile);
                break;
            }
            case 168: 
            case 169: {
                this.rankFeatures(profile);
                break;
            }
            case 181: {
                this.rankProperties(profile);
                break;
            }
            case 147: {
                this.secondPhase(profile);
                break;
            }
            case 148: {
                this.globalPhase(profile);
                break;
            }
            case 37: {
                this.inputs(profile);
                break;
            }
            case 191: {
                this.constants(schema, profile);
                break;
            }
            case 162: 
            case 163: 
            case 164: {
                this.matchFeatures(profile);
                break;
            }
            case 165: 
            case 166: 
            case 167: {
                this.summaryFeatures(profile);
                break;
            }
            case 48: {
                this.onnxModelInProfile(profile);
                break;
            }
            case 15: {
                this.strict(profile);
                break;
            }
            default: {
                this.jj_la1[139] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void inheritsRankProfile(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifierWithDash();
        profile.inherit(name);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 132: {
                    break;
                }
                default: {
                    this.jj_la1[140] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(132);
            name = this.identifierWithDash();
            profile.inherit(name);
        }
    }

    public final void mutate(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(56);
        this.lbrace();
        block3: while (true) {
            this.mutate_operation(profile);
            this.jj_consume_token(5);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[141] = this.jj_gen;
        this.jj_consume_token(129);
    }

    public final void mutate_operation(ParsedRankProfile profile) throws ParseException {
        RankProfile.MutateOperation.Phase phase = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18 -> {
                this.jj_consume_token(18);
                yield RankProfile.MutateOperation.Phase.on_match;
            }
            case 19 -> {
                this.jj_consume_token(19);
                yield RankProfile.MutateOperation.Phase.on_first_phase;
            }
            case 20 -> {
                this.jj_consume_token(20);
                yield RankProfile.MutateOperation.Phase.on_second_phase;
            }
            case 21 -> {
                this.jj_consume_token(21);
                yield RankProfile.MutateOperation.Phase.on_summary;
            }
            default -> {
                this.jj_la1[142] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        this.lbrace();
        String attribute = this.identifier();
        String operation = this.mutate_expr();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[143] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(129);
        profile.addMutateOperation(phase, attribute, operation);
    }

    public final String mutate_expr() throws ParseException {
        Number constant = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 213: {
                this.jj_consume_token(213);
                break;
            }
            case 214: {
                this.jj_consume_token(214);
                break;
            }
            case 215: {
                this.jj_consume_token(215);
                break;
            }
            default: {
                this.jj_la1[144] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String op = this.token.image;
        constant = this.number();
        return constant != null ? op + constant : op;
    }

    public final void function(ParsedRankProfile profile) throws ParseException {
        boolean inline = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            case 149: {
                this.jj_consume_token(149);
                break;
            }
            default: {
                this.jj_la1[145] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        inline = this.inline();
        Object name = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 216: {
                this.jj_consume_token(216);
                name = (String)name + this.token.image;
                break;
            }
            default: {
                this.jj_la1[146] = this.jj_gen;
            }
        }
        this.jj_consume_token(217);
        ParsedRankFunction func = new ParsedRankFunction((String)name);
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                String parameter = this.identifier();
                func.addParameter(parameter);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 132: {
                            break;
                        }
                        default: {
                            this.jj_la1[147] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(132);
                    parameter = this.identifier();
                    func.addParameter(parameter);
                }
            }
            default: {
                this.jj_la1[148] = this.jj_gen;
            }
        }
        this.jj_consume_token(218);
        this.lbrace();
        String expression = this.expression();
        block17: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[149] = this.jj_gen;
                    break block17;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(129);
        func.setExpression(expression);
        func.setInline(inline);
        ParsedRankFunction old = profile.addOrReplaceFunction(func);
        if (old != null) {
            throw new IllegalArgumentException("Function '" + func.name() + "' is defined twice in rank profile '" + profile.name() + "'");
        }
    }

    public final boolean inline() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 150: {
                this.jj_consume_token(150);
                return true;
            }
        }
        this.jj_la1[150] = this.jj_gen;
        return false;
    }

    public final void matchPhase(ParsedRankProfile profile) throws ParseException {
        RankProfile.MatchPhaseSettings settings = new RankProfile.MatchPhaseSettings();
        this.jj_consume_token(140);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: 
                case 70: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: {
                    break;
                }
                default: {
                    this.jj_la1[151] = this.jj_gen;
                    break block6;
                }
            }
            this.matchPhaseItem(settings);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[152] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
        settings.checkValid();
        profile.setMatchPhaseSettings(settings);
    }

    public final void matchPhaseItem(RankProfile.MatchPhaseSettings settings) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 70: {
                this.jj_consume_token(70);
                this.jj_consume_token(130);
                String str = this.identifier();
                settings.setAttribute(str);
                break;
            }
            case 10: {
                this.diversity(settings);
                break;
            }
            case 143: {
                this.jj_consume_token(143);
                this.jj_consume_token(130);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 73: {
                        this.jj_consume_token(73);
                        settings.setAscending(true);
                        break block0;
                    }
                    case 74: {
                        this.jj_consume_token(74);
                        settings.setAscending(false);
                        break block0;
                    }
                }
                this.jj_la1[153] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 145: {
                this.jj_consume_token(145);
                this.jj_consume_token(130);
                int num = this.integer();
                settings.setMaxHits(num);
                break;
            }
            case 144: {
                this.jj_consume_token(144);
                this.jj_consume_token(130);
                double coverage = this.floatValue();
                settings.setMaxFilterCoverage(coverage);
                break;
            }
            case 141: {
                this.jj_consume_token(141);
                this.jj_consume_token(130);
                double multiplier = this.floatValue();
                settings.setEvaluationPoint(multiplier);
                break;
            }
            case 142: {
                this.jj_consume_token(142);
                this.jj_consume_token(130);
                double multiplier = this.floatValue();
                settings.setPrePostFilterTippingPoint(multiplier);
                break;
            }
            default: {
                this.jj_la1[154] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void diversity(RankProfile.MatchPhaseSettings profile) throws ParseException {
        RankProfile.DiversitySettings settings = new RankProfile.DiversitySettings();
        this.jj_consume_token(10);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 12: 
                case 13: 
                case 70: {
                    break;
                }
                default: {
                    this.jj_la1[155] = this.jj_gen;
                    break block6;
                }
            }
            this.diversityItem(settings);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[156] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
        profile.setDiversity(settings);
    }

    public final void diversityItem(RankProfile.DiversitySettings settings) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 70: {
                this.jj_consume_token(70);
                this.jj_consume_token(130);
                String str = this.identifier();
                settings.setAttribute(str);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                this.jj_consume_token(130);
                int num = this.integer();
                settings.setMinGroups(num);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                this.jj_consume_token(130);
                double multiplier = this.floatValue();
                settings.setCutoffFactor(multiplier);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                this.jj_consume_token(130);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        settings.setCutoffStrategy(Diversity.CutoffStrategy.strict);
                        break block0;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        settings.setCutoffStrategy(Diversity.CutoffStrategy.loose);
                        break block0;
                    }
                }
                this.jj_la1[157] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[158] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void firstPhase(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(146);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 170: 
                case 171: 
                case 189: 
                case 190: {
                    break;
                }
                default: {
                    this.jj_la1[159] = this.jj_gen;
                    break block6;
                }
            }
            this.firstPhaseItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[160] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
    }

    public final void firstPhaseItem(ParsedRankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 170: 
            case 171: {
                String expression = this.expression();
                profile.setFirstPhaseRanking(expression);
                break;
            }
            case 189: {
                this.jj_consume_token(189);
                this.jj_consume_token(130);
                int keepRankCount = this.integer();
                profile.setKeepRankCount(keepRankCount);
                break;
            }
            case 190: {
                this.jj_consume_token(190);
                this.jj_consume_token(130);
                double dropLimit = this.floatValue();
                profile.setRankScoreDropLimit(dropLimit);
                break;
            }
            default: {
                this.jj_la1[161] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void secondPhase(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(147);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 170: 
                case 171: 
                case 182: {
                    break;
                }
                default: {
                    this.jj_la1[162] = this.jj_gen;
                    break block6;
                }
            }
            this.secondPhaseItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[163] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
    }

    public final void secondPhaseItem(ParsedRankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 170: 
            case 171: {
                String expression = this.expression();
                profile.setSecondPhaseRanking(expression);
                break;
            }
            case 182: {
                this.jj_consume_token(182);
                this.jj_consume_token(130);
                int rerankCount = this.integer();
                profile.setRerankCount(rerankCount);
                break;
            }
            default: {
                this.jj_la1[164] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void globalPhase(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(148);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 170: 
                case 171: 
                case 182: {
                    break;
                }
                default: {
                    this.jj_la1[165] = this.jj_gen;
                    break block6;
                }
            }
            this.globalPhaseItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[166] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
    }

    public final void globalPhaseItem(ParsedRankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 170: 
            case 171: {
                String expression = this.expression();
                profile.setGlobalPhaseExpression(expression);
                break;
            }
            case 182: {
                this.jj_consume_token(182);
                this.jj_consume_token(130);
                int rerankCount = this.integer();
                profile.setGlobalPhaseRerankCount(rerankCount);
                break;
            }
            default: {
                this.jj_la1[167] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void inputs(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(37);
        this.jj_consume_token(128);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[168] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(5);
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 115: 
                case 117: 
                case 121: 
                case 122: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 143: 
                case 149: 
                case 150: 
                case 151: 
                case 156: 
                case 158: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 198: 
                case 200: 
                case 201: 
                case 202: 
                case 208: {
                    break;
                }
                default: {
                    this.jj_la1[169] = this.jj_gen;
                    break block10;
                }
            }
            this.input(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[170] = this.jj_gen;
                        continue block10;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
    }

    public final void input(ParsedRankProfile profile) throws ParseException {
        TensorType type = TensorType.empty;
        Tensor defaultValue = null;
        Reference reference = this.inputName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 125: 
            case 158: {
                type = this.valueType(reference);
                break;
            }
            default: {
                this.jj_la1[171] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 130: {
                this.jj_consume_token(130);
                block9: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[172] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.jj_consume_token(5);
                }
                defaultValue = this.tensorValue(type);
                break;
            }
            default: {
                this.jj_la1[173] = this.jj_gen;
            }
        }
        profile.addInput(reference, new RankProfile.Input(reference, type, Optional.ofNullable(defaultValue)));
    }

    public final Reference inputName() throws ParseException {
        String name;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 57: {
                this.jj_consume_token(57);
                this.jj_consume_token(217);
                name = this.identifier();
                this.jj_consume_token(218);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[174] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return FeatureNames.asQueryFeature(name);
    }

    public final TensorType valueType(Reference reference) throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 125 -> this.tensorType("Type of " + reference);
            case 158 -> {
                this.jj_consume_token(158);
                yield TensorType.empty;
            }
            default -> {
                this.jj_la1[175] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final void summaryFeatures(ParsedRankProfile profile) throws ParseException {
        Object inherited = null;
        profile.addSummaryFeatures(this.getFeatureList(switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 165 -> {
                this.jj_consume_token(165);
                yield this.token.image.substring(this.token.image.indexOf(":") + 1).trim();
            }
            case 166 -> {
                this.jj_consume_token(166);
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
            }
            case 167 -> {
                this.jj_consume_token(167);
                int inheritsIndex = this.token.image.indexOf("inherits ");
                String rest = this.token.image.substring(inheritsIndex + "inherits ".length());
                profile.setInheritedSummaryFeatures(rest.substring(0, rest.indexOf(" ")).trim());
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
            }
            default -> {
                this.jj_la1[176] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }));
    }

    public final void strict(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(130);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 96: {
                this.jj_consume_token(96);
                profile.setStrict(true);
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                profile.setStrict(false);
                break;
            }
            default: {
                this.jj_la1[177] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void matchFeatures(ParsedRankProfile profile) throws ParseException {
        profile.addMatchFeatures(this.getFeatureList(switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 162 -> {
                this.jj_consume_token(162);
                yield this.token.image.substring(this.token.image.indexOf(":") + 1).trim();
            }
            case 163 -> {
                this.jj_consume_token(163);
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
            }
            case 164 -> {
                this.jj_consume_token(164);
                int inheritsIndex = this.token.image.indexOf("inherits ");
                String rest = this.token.image.substring(inheritsIndex + "inherits ".length());
                profile.setInheritedMatchFeatures(rest.substring(0, rest.indexOf(" ")).trim());
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
            }
            default -> {
                this.jj_la1[178] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }));
    }

    public final void rankFeatures(ParsedRankProfile profile) throws ParseException {
        profile.addRankFeatures(this.getFeatureList(switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 168 -> {
                this.jj_consume_token(168);
                yield this.token.image.substring(this.token.image.indexOf(":") + 1).trim();
            }
            case 169 -> {
                this.jj_consume_token(169);
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
            }
            default -> {
                this.jj_la1[179] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }));
    }

    public final void ignoreRankFeatures(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(108);
        profile.setIgnoreDefaultRankFeatures(true);
    }

    public final void numThreadsPerSearch(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(183);
        this.jj_consume_token(130);
        int num = this.integer();
        profile.setNumThreadsPerSearch(num);
    }

    public final void minHitsPerThread(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(184);
        this.jj_consume_token(130);
        int num = this.integer();
        profile.setMinHitsPerThread(num);
    }

    public final void numSearchPartitions(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(185);
        this.jj_consume_token(130);
        int num = this.integer();
        profile.setNumSearchPartitions(num);
    }

    public final void termwiseLimit(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(186);
        this.jj_consume_token(130);
        double num = this.floatValue();
        profile.setTermwiseLimit(num);
    }

    public final void postFilterThreshold(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(187);
        this.jj_consume_token(130);
        double threshold = this.floatValue();
        profile.setPostFilterThreshold(threshold);
    }

    public final void approximateThreshold(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(188);
        this.jj_consume_token(130);
        double threshold = this.floatValue();
        profile.setApproximateThreshold(threshold);
    }

    public final void rankProperties(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(181);
        this.lbrace();
        while (this.jj_2_9(Integer.MAX_VALUE)) {
            this.rankProperty(profile);
            block7: while (true) {
                this.jj_consume_token(5);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[180] = this.jj_gen;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 208: 
            case 217: 
            case 218: {
                this.rankProperty(profile);
                break;
            }
            default: {
                this.jj_la1[181] = this.jj_gen;
            }
        }
        this.jj_consume_token(129);
    }

    public final void rankProperty(ParsedRankProfile profile) throws ParseException {
        String key = this.rankPropertyItem();
        this.jj_consume_token(130);
        String val = this.rankPropertyItem();
        profile.addRankProperty(key, val);
    }

    public final String rankPropertyItem() throws ParseException {
        String image = null;
        Object ret = "";
        Token dToken = null;
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 198: 
                case 200: 
                case 201: 
                case 202: 
                case 208: {
                    image = this.identifierWithDash();
                    ret = (String)ret + image;
                    break;
                }
                case 199: {
                    dToken = this.jj_consume_token(199);
                    ret = (String)ret + dToken.image;
                    break;
                }
                case 196: 
                case 197: {
                    image = this.quotedString();
                    ret = (String)ret + image;
                    break;
                }
                case 131: 
                case 132: 
                case 217: 
                case 218: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 217: {
                            this.jj_consume_token(217);
                            break;
                        }
                        case 218: {
                            this.jj_consume_token(218);
                            break;
                        }
                        case 131: {
                            this.jj_consume_token(131);
                            break;
                        }
                        case 132: {
                            this.jj_consume_token(132);
                            break;
                        }
                        default: {
                            this.jj_la1[182] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    ret = (String)ret + this.token.image;
                    break;
                }
                default: {
                    this.jj_la1[183] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: 
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 208: 
                case 217: 
                case 218: {
                    continue block15;
                }
            }
            break;
        }
        this.jj_la1[184] = this.jj_gen;
        return ret;
    }

    public final void fieldWeight(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(34);
        String name = this.identifier();
        this.jj_consume_token(130);
        Integer num = this.integer();
        profile.addFieldRankWeight(name, num);
    }

    public final void fieldRankType(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(33);
        String name = this.identifier();
        this.jj_consume_token(130);
        String type = this.identifier();
        profile.addFieldRankType(name, type);
    }

    public final void fieldRankFilter(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(102);
        String name = this.identifier();
        this.jj_consume_token(130);
        this.jj_consume_token(105);
        profile.addFieldRankFilter(name, true);
    }

    public final void constants(ParsedSchema schema, ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(191);
        this.jj_consume_token(128);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[185] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(5);
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 115: 
                case 117: 
                case 121: 
                case 122: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 143: 
                case 149: 
                case 150: 
                case 151: 
                case 156: 
                case 158: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 198: 
                case 200: 
                case 201: 
                case 202: 
                case 208: {
                    break;
                }
                default: {
                    this.jj_la1[186] = this.jj_gen;
                    break block10;
                }
            }
            this.constant(schema, profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[187] = this.jj_gen;
                        continue block10;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
    }

    public final void constant(ParsedSchema schema, ParsedRankProfile profile) throws ParseException {
        Reference name = null;
        TensorType type = TensorType.empty;
        Tensor value = null;
        String valuePath = null;
        name = this.constantName();
        if (this.jj_2_10(4)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 125: 
                case 158: {
                    type = this.valueType(name);
                    break;
                }
                default: {
                    this.jj_la1[188] = this.jj_gen;
                }
            }
            this.jj_consume_token(130);
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[189] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(5);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 128: 
                case 199: 
                case 200: 
                case 201: 
                case 219: {
                    value = this.tensorValue(type);
                    break;
                }
                case 192: {
                    valuePath = this.fileItem();
                    break;
                }
                default: {
                    this.jj_la1[190] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (value != null) {
                profile.add(new RankProfile.Constant(name, value));
            } else {
                profile.add(new RankProfile.Constant(name, type, valuePath));
            }
        } else {
            block10 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 128: 
                case 130: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 130: {
                            this.constantValue(profile, name);
                            break block10;
                        }
                        case 128: {
                            this.constantTensor(profile, name);
                            break block10;
                        }
                    }
                    this.jj_la1[191] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[192] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final Reference constantName() throws ParseException {
        String name;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 47: {
                this.jj_consume_token(47);
                this.jj_consume_token(217);
                name = this.identifier();
                this.jj_consume_token(218);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[193] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return FeatureNames.asConstantFeature(name);
    }

    public final void constantValue(ParsedRankProfile profile, Reference name) throws ParseException {
        this.jj_consume_token(130);
        Token value = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 199 -> this.jj_consume_token(199);
            case 200 -> this.jj_consume_token(200);
            case 194 -> this.jj_consume_token(194);
            default -> {
                this.jj_la1[194] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        profile.add(new RankProfile.Constant(name, Tensor.from((String)value.image)));
    }

    public final void constantTensor(ParsedRankProfile profile, Reference name) throws ParseException {
        String tensorString = "";
        TensorType type = null;
        this.jj_consume_token(128);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[195] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(5);
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 126: 
                case 127: {
                    break;
                }
                default: {
                    this.jj_la1[196] = this.jj_gen;
                    break block14;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 126: 
                case 127: {
                    tensorString = this.tensorValuePrefixedByValue();
                    break;
                }
                case 35: {
                    type = this.tensorTypeWithPrefix(this.constantTensorErrorMessage(profile.name(), name));
                    break;
                }
                default: {
                    this.jj_la1[197] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[198] = this.jj_gen;
                        continue block14;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(129);
        profile.add(new RankProfile.Constant(name, type != null ? Tensor.from((TensorType)type, (String)tensorString) : Tensor.from((String)tensorString)));
    }

    public final String constantTensorErrorMessage(String rankProfileName, Reference name) throws ParseException {
        return "For constant tensor '" + name + "' in rank profile '" + rankProfileName + "'";
    }

    public final Tensor tensorValue(TensorType type) throws ParseException {
        Tensor.Builder builder = Tensor.Builder.of((TensorType)type);
        Number doubleValue = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 128: {
                this.mappedTensorValue(builder);
                break;
            }
            case 219: {
                this.indexedTensorValues(builder);
                break;
            }
            case 199: 
            case 200: 
            case 201: {
                doubleValue = this.number();
                break;
            }
            default: {
                this.jj_la1[199] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (doubleValue != null) {
            if (type.rank() > 0) {
                throw new IllegalArgumentException("A tensor of type " + type + " cannot be a number");
            }
            builder.cell(doubleValue.doubleValue(), new long[0]);
        }
        return builder.build();
    }

    public final void mappedTensorValue(Tensor.Builder builder) throws ParseException {
        this.jj_consume_token(128);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 115: 
                case 117: 
                case 121: 
                case 122: 
                case 128: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 143: 
                case 149: 
                case 150: 
                case 151: 
                case 156: 
                case 158: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 196: 
                case 197: 
                case 198: 
                case 200: 
                case 201: 
                case 202: 
                case 208: {
                    break;
                }
                default: {
                    this.jj_la1[200] = this.jj_gen;
                    break block9;
                }
            }
            this.mappedTensorBlock(builder);
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 132: {
                    break;
                }
                default: {
                    this.jj_la1[201] = this.jj_gen;
                    break block10;
                }
            }
            this.jj_consume_token(132);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[202] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(5);
            }
            this.mappedTensorBlock(builder);
        }
        this.jj_consume_token(129);
    }

    public final void mappedTensorBlock(Tensor.Builder builder) throws ParseException {
        TensorAddress mappedAddress = this.tensorAddress(builder.type());
        this.jj_consume_token(130);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[203] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 199: 
            case 200: 
            case 201: {
                this.mappedTensorCellValue(mappedAddress, builder);
                break;
            }
            case 219: {
                this.indexedTensorBlockValues(mappedAddress, builder);
                break;
            }
            default: {
                this.jj_la1[204] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void indexedTensorBlockValues(TensorAddress mappedAddress, Tensor.Builder builder) throws ParseException {
        ArrayList<Double> values = new ArrayList<Double>();
        this.arrayTensorValues(values);
        MixedTensor.BoundBuilder boundBuilder = (MixedTensor.BoundBuilder)builder;
        double[] arrayValues = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            arrayValues[i] = (Double)values.get(i);
        }
        boundBuilder.block(mappedAddress, arrayValues);
    }

    public final void indexedTensorValues(Tensor.Builder builder) throws ParseException {
        ArrayList<Double> values = new ArrayList<Double>();
        this.arrayTensorValues(values);
        IndexedTensor.BoundBuilder boundBuilder = (IndexedTensor.BoundBuilder)builder;
        double[] arrayValues = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            arrayValues[i] = (Double)values.get(i);
        }
        boundBuilder.fill(arrayValues);
    }

    public final void arrayTensorValues(List<Double> values) throws ParseException {
        block21: {
            block20: {
                this.jj_consume_token(219);
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 199: 
                        case 200: 
                        case 201: 
                        case 219: {
                            break;
                        }
                        default: {
                            this.jj_la1[205] = this.jj_gen;
                            break block20;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 199: 
                        case 200: 
                        case 201: {
                            this.indexedTensorValue(values);
                            continue block17;
                        }
                        case 219: {
                            this.arrayTensorValues(values);
                            continue block17;
                        }
                    }
                    break;
                }
                this.jj_la1[206] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 132: {
                        break;
                    }
                    default: {
                        this.jj_la1[207] = this.jj_gen;
                        break block21;
                    }
                }
                this.jj_consume_token(132);
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[208] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(5);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 199: 
                    case 200: 
                    case 201: {
                        this.indexedTensorValue(values);
                        continue block18;
                    }
                    case 219: {
                        this.arrayTensorValues(values);
                        continue block18;
                    }
                }
                break;
            }
            this.jj_la1[209] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(220);
    }

    public final void indexedTensorValue(List<Double> values) throws ParseException {
        Number value = this.number();
        values.add(value.doubleValue());
    }

    public final void mappedTensorCellValue(TensorAddress address, Tensor.Builder builder) throws ParseException {
        double value = this.tensorCellValue();
        builder.cell(address, value);
    }

    public final TensorAddress tensorAddress(TensorType type) throws ParseException {
        TensorAddress.PartialBuilder builder = new TensorAddress.PartialBuilder(type);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 196: 
            case 197: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                String label = this.tensorAddressLabel();
                builder.add(label);
                break;
            }
            case 128: {
                this.jj_consume_token(128);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 115: 
                        case 117: 
                        case 121: 
                        case 122: 
                        case 133: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 143: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 156: 
                        case 158: 
                        case 191: 
                        case 192: 
                        case 193: 
                        case 194: 
                        case 198: 
                        case 200: 
                        case 201: 
                        case 202: 
                        case 208: {
                            break;
                        }
                        default: {
                            this.jj_la1[210] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.tensorAddressElement((TensorAddress.Builder)builder);
                }
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 132: {
                            break;
                        }
                        default: {
                            this.jj_la1[211] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(132);
                    this.tensorAddressElement((TensorAddress.Builder)builder);
                }
                this.jj_consume_token(129);
                break;
            }
            default: {
                this.jj_la1[212] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return builder.build();
    }

    public final void tensorAddressElement(TensorAddress.Builder builder) throws ParseException {
        String dimension = this.identifier();
        this.jj_consume_token(130);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[213] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(5);
        }
        String label = this.tensorAddressLabel();
        builder.add(dimension, label);
    }

    public final String tensorAddressLabel() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6, 7, 8, 9, 10, 14, 15, 16, 17, 22, 23, 24, 25, 26, 28, 29, 30, 34, 35, 36, 37, 38, 39, 40, 41, 44, 45, 46, 47, 53, 54, 55, 56, 57, 60, 61, 62, 63, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 100, 101, 102, 103, 104, 105, 106, 109, 110, 111, 112, 115, 117, 121, 122, 133, 134, 135, 136, 143, 149, 150, 151, 156, 158, 191, 192, 193, 194, 198, 200, 201, 202, 208 -> this.identifier();
            case 196, 197 -> this.quotedString();
            default -> {
                this.jj_la1[214] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final double tensorCellValue() throws ParseException {
        Number value = this.number();
        return value.doubleValue();
    }

    public final String tensorValuePrefixedByValue() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 126 -> {
                this.jj_consume_token(126);
                yield this.token.image.substring(this.token.image.indexOf(":") + 1);
            }
            case 127 -> {
                this.jj_consume_token(127);
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}"));
            }
            default -> {
                this.jj_la1[215] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final TensorType tensorTypeWithPrefix(String errorMessage) throws ParseException {
        this.jj_consume_token(35);
        this.jj_consume_token(130);
        TensorType type = this.tensorType(errorMessage);
        return type;
    }

    public final TensorType tensorType(String errorMessage) throws ParseException {
        TensorType tensorType;
        this.jj_consume_token(125);
        String tensorTypeString = this.token.image;
        try {
            tensorType = TensorType.fromSpec((String)tensorTypeString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(errorMessage + ": Illegal tensor type spec: " + e.getMessage());
        }
        return tensorType;
    }

    public final void importField(ParsedSchema schema) throws ParseException {
        this.jj_consume_token(28);
        this.jj_consume_token(24);
        String fieldRefSpec = this.identifier();
        this.jj_consume_token(29);
        String aliasFieldName = this.identifier();
        this.lbrace();
        this.jj_consume_token(129);
        long nDots = Utils.count(fieldRefSpec, '.');
        if (nDots != 1L) {
            throw new IllegalArgumentException("Illegal field reference spec '" + fieldRefSpec + "': Does not include a single '.'");
        }
        int indexOfDot = fieldRefSpec.indexOf(46);
        String documentReferenceFieldName = fieldRefSpec.substring(0, indexOfDot);
        String foreignFieldName = fieldRefSpec.substring(indexOfDot + 1);
        schema.addImportedField(aliasFieldName, documentReferenceFieldName, foreignFieldName);
    }

    public final String expression() throws ParseException {
        return (switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 170 -> {
                this.jj_consume_token(170);
                yield this.token.image.substring(this.token.image.indexOf(":") + 1);
            }
            case 171 -> {
                this.jj_consume_token(171);
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}"));
            }
            default -> {
                this.jj_la1[216] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }).trim();
    }

    public final String identifierWithDash() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 115: 
            case 117: 
            case 121: 
            case 122: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 143: 
            case 149: 
            case 150: 
            case 151: 
            case 156: 
            case 158: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 208: {
                String identifier = this.identifier();
                return identifier;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 42: 
            case 43: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 58: 
            case 59: 
            case 64: 
            case 99: 
            case 107: 
            case 108: 
            case 113: 
            case 114: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 123: 
            case 124: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 157: 
            case 159: 
            case 160: 
            case 161: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 195: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 195: {
                        this.jj_consume_token(195);
                        break;
                    }
                    case 188: {
                        this.jj_consume_token(188);
                        break;
                    }
                    case 138: {
                        this.jj_consume_token(138);
                        break;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        break;
                    }
                    case 13: {
                        this.jj_consume_token(13);
                        break;
                    }
                    case 154: {
                        this.jj_consume_token(154);
                        break;
                    }
                    case 159: {
                        this.jj_consume_token(159);
                        break;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        break;
                    }
                    case 118: {
                        this.jj_consume_token(118);
                        break;
                    }
                    case 155: {
                        this.jj_consume_token(155);
                        break;
                    }
                    case 119: {
                        this.jj_consume_token(119);
                        break;
                    }
                    case 141: {
                        this.jj_consume_token(141);
                        break;
                    }
                    case 107: {
                        this.jj_consume_token(107);
                        break;
                    }
                    case 52: {
                        this.jj_consume_token(52);
                        break;
                    }
                    case 120: {
                        this.jj_consume_token(120);
                        break;
                    }
                    case 123: {
                        this.jj_consume_token(123);
                        break;
                    }
                    case 124: {
                        this.jj_consume_token(124);
                        break;
                    }
                    case 146: {
                        this.jj_consume_token(146);
                        break;
                    }
                    case 113: {
                        this.jj_consume_token(113);
                        break;
                    }
                    case 148: {
                        this.jj_consume_token(148);
                        break;
                    }
                    case 51: {
                        this.jj_consume_token(51);
                        break;
                    }
                    case 42: {
                        this.jj_consume_token(42);
                        break;
                    }
                    case 108: {
                        this.jj_consume_token(108);
                        break;
                    }
                    case 50: {
                        this.jj_consume_token(50);
                        break;
                    }
                    case 49: {
                        this.jj_consume_token(49);
                        break;
                    }
                    case 189: {
                        this.jj_consume_token(189);
                        break;
                    }
                    case 152: {
                        this.jj_consume_token(152);
                        break;
                    }
                    case 64: {
                        this.jj_consume_token(64);
                        break;
                    }
                    case 140: {
                        this.jj_consume_token(140);
                        break;
                    }
                    case 144: {
                        this.jj_consume_token(144);
                        break;
                    }
                    case 145: {
                        this.jj_consume_token(145);
                        break;
                    }
                    case 43: {
                        this.jj_consume_token(43);
                        break;
                    }
                    case 157: {
                        this.jj_consume_token(157);
                        break;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        break;
                    }
                    case 184: {
                        this.jj_consume_token(184);
                        break;
                    }
                    case 161: {
                        this.jj_consume_token(161);
                        break;
                    }
                    case 160: {
                        this.jj_consume_token(160);
                        break;
                    }
                    case 185: {
                        this.jj_consume_token(185);
                        break;
                    }
                    case 183: {
                        this.jj_consume_token(183);
                        break;
                    }
                    case 114: {
                        this.jj_consume_token(114);
                        break;
                    }
                    case 116: {
                        this.jj_consume_token(116);
                        break;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        break;
                    }
                    case 18: {
                        this.jj_consume_token(18);
                        break;
                    }
                    case 48: {
                        this.jj_consume_token(48);
                        break;
                    }
                    case 20: {
                        this.jj_consume_token(20);
                        break;
                    }
                    case 21: {
                        this.jj_consume_token(21);
                        break;
                    }
                    case 187: {
                        this.jj_consume_token(187);
                        break;
                    }
                    case 142: {
                        this.jj_consume_token(142);
                        break;
                    }
                    case 99: {
                        this.jj_consume_token(99);
                        break;
                    }
                    case 58: {
                        this.jj_consume_token(58);
                        break;
                    }
                    case 181: {
                        this.jj_consume_token(181);
                        break;
                    }
                    case 190: {
                        this.jj_consume_token(190);
                        break;
                    }
                    case 33: {
                        this.jj_consume_token(33);
                        break;
                    }
                    case 59: {
                        this.jj_consume_token(59);
                        break;
                    }
                    case 139: {
                        this.jj_consume_token(139);
                        break;
                    }
                    case 182: {
                        this.jj_consume_token(182);
                        break;
                    }
                    case 147: {
                        this.jj_consume_token(147);
                        break;
                    }
                    case 27: {
                        this.jj_consume_token(27);
                        break;
                    }
                    case 31: {
                        this.jj_consume_token(31);
                        break;
                    }
                    case 186: {
                        this.jj_consume_token(186);
                        break;
                    }
                    case 153: {
                        this.jj_consume_token(153);
                        break;
                    }
                    default: {
                        this.jj_la1[217] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return this.token.image;
            }
        }
        this.jj_la1[218] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 100: {
                this.jj_consume_token(100);
                break;
            }
            case 115: {
                this.jj_consume_token(115);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            case 151: {
                this.jj_consume_token(151);
                break;
            }
            case 133: {
                this.jj_consume_token(133);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                break;
            }
            case 92: {
                this.jj_consume_token(92);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            case 191: {
                this.jj_consume_token(191);
                break;
            }
            case 198: {
                this.jj_consume_token(198);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            case 112: {
                this.jj_consume_token(112);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 158: {
                this.jj_consume_token(158);
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            case 104: {
                this.jj_consume_token(104);
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            case 192: {
                this.jj_consume_token(192);
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 156: {
                this.jj_consume_token(156);
                break;
            }
            case 109: {
                this.jj_consume_token(109);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 194: {
                this.jj_consume_token(194);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 150: {
                this.jj_consume_token(150);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 200: {
                this.jj_consume_token(200);
                break;
            }
            case 103: {
                this.jj_consume_token(103);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                break;
            }
            case 201: {
                this.jj_consume_token(201);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                break;
            }
            case 149: {
                this.jj_consume_token(149);
                break;
            }
            case 135: {
                this.jj_consume_token(135);
                break;
            }
            case 101: {
                this.jj_consume_token(101);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 121: {
                this.jj_consume_token(121);
                break;
            }
            case 56: {
                this.jj_consume_token(56);
                break;
            }
            case 117: {
                this.jj_consume_token(117);
                break;
            }
            case 93: {
                this.jj_consume_token(93);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 95: {
                this.jj_consume_token(95);
                break;
            }
            case 94: {
                this.jj_consume_token(94);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 143: {
                this.jj_consume_token(143);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            case 102: {
                this.jj_consume_token(102);
                break;
            }
            case 76: {
                this.jj_consume_token(76);
                break;
            }
            case 136: {
                this.jj_consume_token(136);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                break;
            }
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 202: {
                this.jj_consume_token(202);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 111: {
                this.jj_consume_token(111);
                break;
            }
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                break;
            }
            case 193: {
                this.jj_consume_token(193);
                break;
            }
            case 208: {
                this.jj_consume_token(208);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 134: {
                this.jj_consume_token(134);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[219] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final String string() throws ParseException {
        this.jj_consume_token(202);
        return this.token.image;
    }

    public final String quotedString() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 196: {
                this.jj_consume_token(196);
                break;
            }
            case 197: {
                this.jj_consume_token(197);
                break;
            }
            default: {
                this.jj_la1[220] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.substring(1, this.token.image.length() - 1);
    }

    public final Boolean bool() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 94: 
            case 96: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 94: {
                        this.jj_consume_token(94);
                        break;
                    }
                    case 96: {
                        this.jj_consume_token(96);
                        break;
                    }
                    default: {
                        this.jj_la1[221] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return true;
            }
            case 95: 
            case 97: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 95: {
                        this.jj_consume_token(95);
                        break;
                    }
                    case 97: {
                        this.jj_consume_token(97);
                        break;
                    }
                    default: {
                        this.jj_la1[222] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return false;
            }
        }
        this.jj_la1[223] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int integer() throws ParseException {
        this.jj_consume_token(200);
        return Integer.parseInt(this.token.image);
    }

    public final long longValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 200: {
                this.jj_consume_token(200);
                return Long.parseLong(this.token.image);
            }
            case 201: {
                this.jj_consume_token(201);
                return Long.parseLong(this.token.image.substring(0, this.token.image.length() - 1));
            }
        }
        this.jj_la1[224] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final double floatValue() throws ParseException {
        this.jj_consume_token(199);
        return Double.valueOf(this.token.image);
    }

    public final Number number() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 199 -> this.floatValue();
            case 200, 201 -> this.longValue();
            default -> {
                this.jj_la1[225] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final void lbrace() throws ParseException {
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[226] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(128);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[227] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    private boolean jj_3_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_118()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(130)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_119()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_120()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_144() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_150()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_151()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_150() {
        return this.jj_3R_155();
    }

    private boolean jj_3R_116() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(128)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_118() {
        return this.jj_3R_126();
    }

    private boolean jj_3R_139() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_145()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_146()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_145() {
        return this.jj_3R_129();
    }

    private boolean jj_3R_146() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(195)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(188)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(138)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(12)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(13)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(154)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(159)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(32)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(118)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(155)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(119)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(141)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(107)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(52)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(120)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(123)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(124)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(146)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(113)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(148)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(51)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(42)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(108)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(50)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(49)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(189)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(152)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(64)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(140)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(144)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(145)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(43)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(157)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(11)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(184)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(161)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(160)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(185)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(183)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(114)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(116)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(19)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(18)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(48)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(20)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(21)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(187)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(142)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(99)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(58)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(181)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(190)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(33)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(59)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(139)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(182)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(147)) {
                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                            if (this.jj_scan_token(27)) {
                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                if (this.jj_scan_token(31)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(186)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(153)) {
                                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_151() {
        return this.jj_3R_156();
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(156)) {
            return true;
        }
        return this.jj_3R_116();
    }

    private boolean jj_3R_119() {
        return this.jj_3R_127();
    }

    private boolean jj_3R_127() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_136()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_137()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_138()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_136() {
        return this.jj_3R_142();
    }

    private boolean jj_3R_142() {
        Token xsp;
        if (this.jj_scan_token(128)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_147());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_148());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(129);
    }

    private boolean jj_3R_147() {
        return this.jj_3R_152();
    }

    private boolean jj_3R_148() {
        Token xsp;
        if (this.jj_scan_token(132)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        this.jj_scanpos = xsp;
        return this.jj_3R_152();
    }

    private boolean jj_3R_120() {
        return this.jj_3R_128();
    }

    private boolean jj_3R_152() {
        if (this.jj_3R_157()) {
            return true;
        }
        return this.jj_scan_token(130);
    }

    private boolean jj_3R_129() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(100)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(115)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(6)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(7)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(151)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(133)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(29)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(73)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(70)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(92)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(89)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(90)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(47)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(191)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(198)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(74)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(72)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(112)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(10)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(16)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(158)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(63)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(104)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(97)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(24)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(25)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(26)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(192)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(105)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(61)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(78)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(41)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(88)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(156)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(109)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(85)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(194)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(28)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(36)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(30)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(23)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(150)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(37)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(200)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(103)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(79)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(201)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(14)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(77)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(149)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(135)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(101)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(55)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(38)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(121)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(56)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(117)) {
                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                            if (this.jj_scan_token(93)) {
                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                if (this.jj_scan_token(106)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(87)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(95)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(94)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(17)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(143)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(122)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(53)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(44)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(81)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(69)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(84)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(57)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(102)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(76)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(136)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(8)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(9)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(82)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(54)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(71)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(110)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(65)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(66)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(67)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(68)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(62)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(86)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(80)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(15)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(202)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(22)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(45)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(46)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(60)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(98)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(83)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(39)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(111)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(96)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(35)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(75)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(91)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(193)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(208)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(34)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(134)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(40)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_137() {
        return this.jj_3R_143();
    }

    private boolean jj_3_7() {
        return this.jj_3R_115();
    }

    private boolean jj_3R_115() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_121()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(130)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_122()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_123()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_124()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_121() {
        return this.jj_3R_129();
    }

    private boolean jj_3R_122() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_143() {
        return this.jj_3R_149();
    }

    private boolean jj_3R_123() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_124() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(61)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(62)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_138() {
        return this.jj_3R_144();
    }

    private boolean jj_3R_128() {
        if (this.jj_scan_token(192)) {
            return true;
        }
        if (this.jj_scan_token(130)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(203)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(202)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(194)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_149() {
        Token xsp;
        if (this.jj_scan_token(219)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_153());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_154());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(220);
    }

    private boolean jj_3R_154() {
        Token xsp;
        if (this.jj_scan_token(132)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_160()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_161()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_166() {
        return this.jj_3R_144();
    }

    private boolean jj_3R_153() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_158()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_159()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_158() {
        return this.jj_3R_166();
    }

    private boolean jj_3R_160() {
        return this.jj_3R_166();
    }

    private boolean jj_3R_157() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_164()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_165()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_164() {
        return this.jj_3R_167();
    }

    private boolean jj_3R_165() {
        Token xsp;
        if (this.jj_scan_token(128)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_168());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_169());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(129);
    }

    private boolean jj_3R_172() {
        return this.jj_3R_129();
    }

    private boolean jj_3R_168() {
        return this.jj_3R_172();
    }

    private boolean jj_3R_117() {
        Token xsp;
        if (this.jj_3R_125()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_125());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_167() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_170()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_171()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_125() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_130()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_131()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_132()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_133()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_130() {
        return this.jj_3R_139();
    }

    private boolean jj_3R_159() {
        return this.jj_3R_149();
    }

    private boolean jj_3R_161() {
        return this.jj_3R_149();
    }

    private boolean jj_3R_170() {
        return this.jj_3R_129();
    }

    private boolean jj_3R_131() {
        return this.jj_scan_token(199);
    }

    private boolean jj_3_9() {
        if (this.jj_3R_117()) {
            return true;
        }
        if (this.jj_scan_token(130)) {
            return true;
        }
        if (this.jj_3R_117()) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_132() {
        return this.jj_3R_140();
    }

    private boolean jj_3R_133() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(217)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(218)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(131)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(132)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_171() {
        return this.jj_3R_140();
    }

    private boolean jj_3R_169() {
        return this.jj_scan_token(132);
    }

    private boolean jj_3R_141() {
        return this.jj_scan_token(125);
    }

    private boolean jj_3R_140() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(196)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(197)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_126() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_134()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_135()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_134() {
        return this.jj_3R_141();
    }

    private boolean jj_3R_135() {
        return this.jj_scan_token(158);
    }

    private boolean jj_3R_156() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_162()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_163()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_162() {
        return this.jj_scan_token(200);
    }

    private boolean jj_3R_163() {
        return this.jj_scan_token(201);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(133)) {
            return true;
        }
        return this.jj_scan_token(206);
    }

    private boolean jj_3R_155() {
        return this.jj_scan_token(199);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(134)) {
            return true;
        }
        return this.jj_scan_token(206);
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(135)) {
            return true;
        }
        return this.jj_scan_token(206);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_scan_token(206);
    }

    private boolean jj_3_5() {
        return this.jj_scan_token(125);
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(136);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 66305, 768, 0x800000, 356581440, 32, 32, 356581440, 65536, 32, 2009319360, 32, 32, 0x800000, 32, 0x1400040, 32, 32, 32, 0x800000, 32, 0x1400040, 32, 0x1400040, 0, 0, 0, 0, -939524096, 32, 0, -64, 0x2000000, 32, 0x2000000, 32, 0x800000, 32, 0x800000, 0x1000000, 32, 32, 32, 0x800000, 0x1000000, 32, 0, 2009319360, 32, 0, 0, 32, -939524096, 32, -939524096, -939524096, 0, 2009319360, 0, 0, 32, 32, 0, 2009319360, 2009319360, 0, 32, 32, 0, 32, 32, 0, 0, 0, 2009319360, 0, 0, 0, 32, 2009319392, 2009319360, 0, 0, 0, 2009319360, 0, 32, 0, 0, 0, 0, 0, 0, 0, 32, 32, 0, -64, 2009319360, 0, 32, 32, 0, 0, 0, 32, 32, 0, 0x800000, 32, 32, 0, 0, 32, 32, 2009319360, 0, 0, 32, 32, 0, 0, 32, 0, 0, 32, 0, 0, 0, 32, 0, 0, 0, 32, 32, 0, 0x800000, 32768, 32, 32768, 0, 0x3C0000, 0x3C0000, 32, 0, 0, 0, 0, 2009319360, 32, 0, 1024, 32, 0, 1024, 14336, 32, 49152, 14336, 0, 32, 0, 0, 32, 0, 0, 32, 0, 32, 2009319360, 32, 0, 32, 0, 2009319360, 0, 0, 0, 0, 0, 32, -64, 0, -64, -64, 32, 2009319360, 32, 0, 32, 0, 0, 0, 2009319360, 0, 32, 0, 0, 32, 0, 2009319360, 0, 32, 32, 0, 0, 0, 0, 32, 0, 2009319360, 0, 2009319360, 32, 2009319360, 0, 0, -2009319424, -64, 2009319360, 0, 0, 0, 0, 0, 0, 32, 32};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 209813521, 0, 0, 209813521, 0, 0, -203361284, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000016, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -203361284, 0, 0, 0, 0, 0x10000000, 0, 0x10000016, 0x10000000, 0, -203361284, 0, 0, 0, 0, 0, -203361284, -203361284, 0, 0, 0, 0, 0, 0, 0, 0, 0, -203361284, 0, 8, -536870912, 0, -203361284, -203361284, 0x60000000, -536870912, 8, -203361284, -536870912, 0, -536870912, 0x60000000, -536870912, 0, 0, 0, 0, 0, 0, 0, -1, -203361284, 32704, 0, 0, 29632, 32704, 0, 0, 0, 0, 0, 0x10000000, 0x10000000, 0, 4096, 0, 0, -203361284, 0, 4096, 0, 0, 4096, 0, 0, 0, 0, 0, 0x1E0000, 0x600000, 0x1E0000, 0, 8, 8, 0, 0, 0, 0x4800000, 0, 16842790, 0, 16842790, 0, 0, 0, 0, 0, 0, 0, 0, -203361284, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -203361284, 0, 0, 0, 0, -203361284, 0, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, -203361284, 0, 0, 0, 0, 0, 0, -203361284, 0, 0, 8, 8, 0, 0, -203361284, 0, 0, 0, 0, 0, 0, 0, 0, 0, -203361284, 0, -203361284, 0, -203361284, 0, 0, 203361283, -1, -203361284, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0x400000, 0, 0, 0x400000, 0, 0, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10C001C0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 64, 0, 0x10C001C0, 64, 0, -2, 0, 0, 0, 0, 0, -2, -2, 128, 0, 0, 116224, 0, 0, 14336, 0x3E0000, 116224, -2, 128, 0, 0x10000001, 0, -2, -2, 0, 1, 0, -2, 0x10000001, 0, 0x10000001, 0, 1, 0, 0, 0, 0xF000000, 0, 0, 0xF000000, -1, -2, 0xC000000, 0, 0, 0xC000000, 0xC000000, 0, 0, 0, 0, 0, 0, 0, 0, 0x400000, 0, 0, -2, 0, 0x400000, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 16384, 0, 0, 0, 0, 0, 16384, 0, 0, -2, 0, 0, 64, 0, 1536, 64, 64, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, -2, 0, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2, 0, -2, 0, -2, 0, 0, 1, -1, -2, 0, 0x40000000, Integer.MIN_VALUE, -1073741824, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103409655, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 8312, 0, 0, 0x1FFFFFFF, 40, 0, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103409655, 0, 8192, 32, 0, 104, 0, 8312, 104, 0, 103409655, 0, 0, 0, 0, 0, 103409655, 103409655, 532676624, 0, 0, 0, 0, 0, 0, 0, 0, 103409655, 532676624, 0, 49152, 0, 103409655, 103409655, 0, 0, 0, 103409655, 49152, 0, 49152, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0x1FFFFFFF, 103409655, 2304, 0, 0, 256, 2304, 1664, 0, 0, 1664, 0, 393216, 393216, 0, 16, 0, 0, 103409655, 0, 16, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4160, 0, 4160, 0, 0, 0, 0, 0, 0, 0, 0, 103409655, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103409655, 0, 0x20000000, 0, 0, 103409655, 0x20000000, 0, 3, 0, 0, 0, 0x1FFFFFFF, 0, 0x1FFFFFFF, 0x1FFFFFFF, 0, 103409655, 0, 0x20000000, 0, 0, 0, 0, 103409655, 0, 0, -1073741824, -1073741824, 0, 0, 103409655, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103409655, 0, 103409655, 0, 103409655, -1073741824, 0, 433461256, 0x1FFFFFFF, 103409655, 0, 1, 2, 3, 0, 0, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1356890592, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 16, 16, 64, 0, 16, -544, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1356890592, 0, 0, 0, 0, 0, 0, 64, 0, 4, 1356890592, 16, 3072, 0, 5, 3072, 1356890592, 1356890592, Integer.MIN_VALUE, 0, 5, 0, 0, 5, 0, 0, 0, 1356890592, Integer.MIN_VALUE, 0, 0, 0, 1356890593, 1356890592, 0, 0, 0, 1356890592, 0, 0, 0, 0, 0, 16, 0, 16, 0, 0, 5, 0, -544, 1356890592, 0, 0, 5, 0, 0, 0, 0, 5, 0, 0, 0, 0, 16, 528482304, 0, 5, 1356890592, 16, 528482304, 0, 5, 528482304, 0x20000000, 0, 0x10000000, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3936256, 0, 3936256, 16, 0, 0, 0, 0, 0x200000, 0, 16, 1356890592, 0, 0x400000, 253952, 0, 0, 253952, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1356890592, 0, 0x40000000, 0, 4, 1356890592, 0x40000000, 0, 0, 0, 0, 0, -520, 24, -520, -520, 0, 1356890592, 0, 0x40000000, 0, 1, 5, 5, 1356890592, 0, 0, 0, 0, 0, 1, 1356890593, 16, 0, 0, 0, 0, 0, 16, 0, 0, 1356890592, 16, 1356890593, 0, 1356890592, 0, 0, -1356891136, -544, 1356890592, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2097149, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2097149, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1616903172, 0, -1616903172, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x60000C00, 0, 0x60000C00, 0x400C00, 0, 0x400C00, 0x400C00, 0, 0x400C00, 0, Integer.MIN_VALUE, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 224, 0, 28, 768, 0, -2097149, 0, -2097149, -2097149, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, 3072, 2145386499, -2097149, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_6() {
        jj_la1_6 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67399, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67455, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 67399, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67399, 0, 0, 0, 0, 0, 67399, 67399, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67399, 0, 0, 0, 0, 67399, 67399, 0, 0, 0, 67399, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67455, 67399, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67399, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 393219, 0, 393219, 0, 3, 3, 3076, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0xE00000, 0, 0x1000000, 0, 67399, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67399, 0, 0, 0, 0, 67399, 0, 0, 0, 0, 0, 0, 100730879, 0x6000000, 100730879, 100730879, 0, 67399, 0, 0, 0, 134218625, 0, 0, 67399, 388, 0, 0, 0, 0, 0x8000380, 67447, 0, 0, 0, 0x8000380, 0x8000380, 0x8000380, 0, 0, 0x8000380, 67399, 0, 67447, 0, 67447, 0, 0, 8, 67407, 67399, 48, 0, 0, 0, 768, 896, 0, 0};
    }

    public SchemaParser(CharStream stream) {
        int i;
        this.token_source = new SchemaParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 228; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 228; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SchemaParser(SchemaParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 228; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SchemaParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 228; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            if (t.next == null) {
                t.next = this.token_source.getNextToken();
            }
            t = t.next;
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[221];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 228; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) != 0) {
                    la1tokens[160 + j] = true;
                }
                if ((jj_la1_6[i] & 1 << j) == 0) continue;
                la1tokens[192 + j] = true;
            }
        }
        for (i = 0; i < 221; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return false;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 10; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_scanpos = p.first;
                    this.jj_lastpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SchemaParser.jj_la1_init_0();
        SchemaParser.jj_la1_init_1();
        SchemaParser.jj_la1_init_2();
        SchemaParser.jj_la1_init_3();
        SchemaParser.jj_la1_init_4();
        SchemaParser.jj_la1_init_5();
        SchemaParser.jj_la1_init_6();
    }

    private static final class LookaheadSuccess
    extends IllegalStateException {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

