/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.documentmodel;

import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.Field;
import com.yahoo.document.StructDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.annotation.AnnotationType;
import com.yahoo.document.annotation.AnnotationTypeRegistry;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.documentmodel.DataTypeCollection;
import com.yahoo.documentmodel.DataTypeRepo;
import com.yahoo.documentmodel.NewDocumentReferenceDataType;
import com.yahoo.schema.FieldSets;
import com.yahoo.schema.document.FieldSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class NewDocumentType
extends StructuredDataType
implements DataTypeCollection {
    private final Name name;
    private final DataTypeRepo dataTypes = new DataTypeRepo();
    private final Map<Integer, NewDocumentType> inherits = new LinkedHashMap<Integer, NewDocumentType>();
    private final AnnotationTypeRegistry annotations = new AnnotationTypeRegistry();
    private final StructDataType contentStruct;
    private final Set<FieldSet> fieldSets = new LinkedHashSet<FieldSet>();
    private final Set<Name> documentReferences;
    private final Set<String> importedFieldNames;
    private NewDocumentReferenceDataType refToThis = null;

    public NewDocumentType(Name name) {
        this(name, Collections.emptySet());
    }

    public NewDocumentType(Name name, Set<Name> documentReferences, Set<String> importedFieldNames) {
        this(name, new StructDataType(name.getName() + ".header"), new FieldSets(Optional.empty()), documentReferences, importedFieldNames);
    }

    public NewDocumentType(Name name, Set<Name> documentReferences) {
        this(name, documentReferences, Collections.emptySet());
    }

    public NewDocumentType(Name name, StructDataType contentStruct, FieldSets fs, Set<Name> documentReferences, Set<String> importedFieldNames) {
        super(name.getName());
        this.name = name;
        this.contentStruct = contentStruct;
        if (fs != null) {
            this.fieldSets.addAll(fs.userFieldSets().values());
            for (FieldSet f : fs.builtInFieldSets().values()) {
                if (f.getName() == "[internal]" || f.getName() == "[search]") continue;
                this.fieldSets.add(f);
            }
        }
        this.documentReferences = documentReferences;
        this.importedFieldNames = importedFieldNames;
    }

    public Name getFullName() {
        return this.name;
    }

    public DataType getContentStruct() {
        return this.contentStruct;
    }

    public Collection<NewDocumentType> getInherited() {
        return this.inherits.values();
    }

    public NewDocumentType getInherited(Name inherited) {
        return this.inherits.get(inherited.getId());
    }

    public Class<Document> getValueClass() {
        return Document.class;
    }

    public boolean isValueCompatible(FieldValue value) {
        if (!(value instanceof Document)) {
            return false;
        }
        return false;
    }

    private void verifyInheritance(NewDocumentType inherited) {
        for (Field f : this.getFields()) {
            Field inhF = inherited.getField(f.getName());
            if (inhF == null || inhF.equals((Object)f)) continue;
            throw new IllegalArgumentException("Inherited document '" + inherited + "' already contains field '" + inhF.getName() + "'. Can not override with '" + f.getName() + "'.");
        }
        for (Field f : inherited.getAllFields()) {
            for (NewDocumentType side : this.inherits.values()) {
                Field sideF = side.getField(f.getName());
                if (sideF == null || sideF.equals((Object)f)) continue;
                throw new IllegalArgumentException("Inherited document '" + side + "' already contains field '" + sideF.getName() + "'. Document '" + inherited + "' also defines field '" + f.getName() + "'.Multiple inheritance must be disjunctive.");
            }
        }
    }

    public void inherit(NewDocumentType inherited) {
        if (!this.inherits.containsKey(inherited.getId())) {
            this.verifyInheritance(inherited);
            this.inherits.put(inherited.getId(), inherited);
        }
    }

    public boolean inherits(NewDocumentType superType) {
        if (this.getId() == superType.getId()) {
            return true;
        }
        for (NewDocumentType type : this.inherits.values()) {
            if (!type.inherits(superType)) continue;
            return true;
        }
        return false;
    }

    public Field getField(String name) {
        Field field = this.contentStruct.getField(name);
        if (field == null) {
            for (NewDocumentType inheritedType : this.inherits.values()) {
                field = inheritedType.getField(name);
                if (field == null) continue;
                return field;
            }
        }
        return field;
    }

    public boolean containsField(String fieldName) {
        return this.getField(fieldName) != null;
    }

    public Field getField(int id) {
        Field field = this.contentStruct.getField(id);
        if (field == null) {
            for (NewDocumentType inheritedType : this.inherits.values()) {
                field = inheritedType.getField(id);
                if (field == null) continue;
                return field;
            }
        }
        return field;
    }

    public Collection<Field> getAllFields() {
        LinkedList<Field> collection = new LinkedList<Field>();
        for (NewDocumentType type : this.inherits.values()) {
            collection.addAll(type.getAllFields());
        }
        collection.addAll(this.contentStruct.getFields());
        return Collections.unmodifiableCollection(collection);
    }

    public Collection<Field> getFields() {
        return this.contentStruct.getFields();
    }

    public Document createFieldValue() {
        throw new RuntimeException("Cannot create an instance of " + this);
    }

    @Override
    public Collection<DataType> getTypes() {
        return this.dataTypes.getTypes();
    }

    public DataTypeCollection getAllTypes() {
        DataTypeRepo repo = new DataTypeRepo();
        HashSet<Name> seen = new HashSet<Name>();
        LinkedList<NewDocumentType> stack = new LinkedList<NewDocumentType>();
        stack.push(this);
        while (!stack.isEmpty()) {
            NewDocumentType docType = (NewDocumentType)stack.pop();
            if (seen.contains(docType.name)) continue;
            seen.add(docType.name);
            for (DataType dataType : docType.getTypes()) {
                if (repo.getDataType(dataType.getId()) != null) continue;
                repo.add(dataType);
            }
            stack.addAll(docType.inherits.values());
        }
        return repo;
    }

    public Collection<AnnotationType> getAnnotations() {
        return this.annotations.getTypes().values();
    }

    public Collection<AnnotationType> getAllAnnotations() {
        LinkedList<AnnotationType> collection = new LinkedList<AnnotationType>();
        for (NewDocumentType type : this.inherits.values()) {
            collection.addAll(type.getAllAnnotations());
        }
        collection.addAll(this.getAnnotations());
        return Collections.unmodifiableCollection(collection);
    }

    @Override
    public DataType getDataType(String name) {
        return this.dataTypes.getDataType(name);
    }

    @Override
    public DataType getDataType(int id) {
        return this.dataTypes.getDataType(id);
    }

    public DataType getDataTypeRecursive(String name) {
        DataType a = this.dataTypes.getDataType(name);
        if (a != null) {
            return a;
        }
        for (NewDocumentType dt : this.getInherited()) {
            a = dt.getDataTypeRecursive(name);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public DataType getDataTypeRecursive(int id) {
        DataType a = this.dataTypes.getDataType(id);
        if (a != null) {
            return a;
        }
        for (NewDocumentType dt : this.getInherited()) {
            a = dt.getDataTypeRecursive(id);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public AnnotationType getAnnotationType(String name) {
        AnnotationType a = this.annotations.getType(name);
        if (a != null) {
            return a;
        }
        for (NewDocumentType dt : this.getInherited()) {
            a = dt.getAnnotationType(name);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public NewDocumentType add(AnnotationType type) {
        this.annotations.register(type);
        return this;
    }

    public NewDocumentType add(DataType type) {
        this.dataTypes.add(type);
        return this;
    }

    public NewDocumentType replace(DataType type) {
        this.dataTypes.replace(type);
        return this;
    }

    public Set<FieldSet> getFieldSets() {
        return Collections.unmodifiableSet(this.fieldSets);
    }

    public Set<Name> getDocumentReferences() {
        return this.documentReferences;
    }

    public Set<String> getImportedFieldNames() {
        return this.importedFieldNames;
    }

    public NewDocumentReferenceDataType getReferenceDataType() {
        if (this.refToThis == null) {
            this.refToThis = new NewDocumentReferenceDataType(this);
        }
        return this.refToThis;
    }

    public static final class Name {
        private final String name;
        private final int id;

        public Name(String name) {
            this(name.hashCode(), name);
        }

        public Name(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Name)) {
                return false;
            }
            return this.name.equals(((Name)other).getName());
        }
    }
}

