/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.FileReference;
import com.yahoo.config.LeafNode;
import com.yahoo.config.Serializer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OptionalPathNode
extends LeafNode<Optional<Path>> {
    private final Optional<FileReference> fileReference;

    public OptionalPathNode() {
        this.fileReference = Optional.empty();
    }

    public OptionalPathNode(FileReference fileReference) {
        super(true);
        this.value = Optional.of(Path.of(fileReference.value(), new String[0]));
        this.fileReference = Optional.of(fileReference);
    }

    public OptionalPathNode(Optional<FileReference> fileReference) {
        super(true);
        this.value = fileReference.map(reference -> Path.of(reference.value(), new String[0]));
        this.fileReference = fileReference;
    }

    @Override
    public Optional<Path> value() {
        return (Optional)this.value;
    }

    @Override
    public String getValue() {
        return ((Optional)this.value).toString();
    }

    @Override
    public String toString() {
        return ((Optional)this.value).isEmpty() ? "(empty)" : "\"" + ((Path)((Optional)this.value).get()).toString() + "\"";
    }

    @Override
    protected boolean doSetValue(String stringVal) {
        throw new UnsupportedOperationException("doSetValue should not be necessary anymore!");
    }

    @Override
    void serialize(String name, Serializer serializer) {
        ((Optional)this.value).ifPresent(path -> serializer.serialize(name, path.toString()));
    }

    @Override
    void serialize(Serializer serializer) {
        ((Optional)this.value).ifPresent(path -> serializer.serialize(path.toString()));
    }

    public Optional<FileReference> getFileReference() {
        return this.fileReference;
    }

    public static List<Optional<FileReference>> toFileReferences(List<OptionalPathNode> pathNodes) {
        ArrayList<Optional<FileReference>> fileReferences = new ArrayList<Optional<FileReference>>();
        for (OptionalPathNode pathNode : pathNodes) {
            fileReferences.add(pathNode.getFileReference());
        }
        return fileReferences;
    }

    public static Map<String, Optional<FileReference>> toFileReferenceMap(Map<String, OptionalPathNode> map) {
        LinkedHashMap<String, Optional<FileReference>> ret = new LinkedHashMap<String, Optional<FileReference>>();
        for (Map.Entry<String, OptionalPathNode> e : map.entrySet()) {
            ret.put(e.getKey(), e.getValue().getFileReference());
        }
        return ret;
    }
}

