/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.InnerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.NodeVector;
import com.yahoo.config.Serializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ConfigInstance
extends InnerNode {
    String configId;

    public static String getDefName(Class<?> type) {
        return ConfigInstance.getStaticStringField(type, "CONFIG_DEF_NAME");
    }

    public static String getDefNamespace(Class<?> type) {
        return ConfigInstance.getStaticStringField(type, "CONFIG_DEF_NAMESPACE");
    }

    public static List<String> serialize(InnerNode node) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Map.Entry<String, LeafNode<?>> entry : ConfigInstance.getAllDescendantLeafNodes(node).entrySet()) {
            ret.add(entry.getKey() + " " + entry.getValue().toString());
        }
        return ret;
    }

    public static void serialize(InnerNode node, Serializer serializer) {
        ConfigInstance.serializeMap(node.getChildren(), serializer);
    }

    private static void serializeObject(String name, Object child, Serializer serializer) {
        if (child instanceof InnerNode) {
            Serializer childSerializer = serializer.createInner(name);
            ConfigInstance.serialize((InnerNode)child, childSerializer);
        } else if (child instanceof Map) {
            Serializer mapSerializer = serializer.createMap(name);
            ConfigInstance.serializeMap((Map)child, mapSerializer);
        } else if (child instanceof NodeVector) {
            Serializer arraySerializer = serializer.createArray(name);
            ConfigInstance.serializeArray((NodeVector)child, arraySerializer);
        } else if (child instanceof LeafNode) {
            ((LeafNode)child).serialize(name, serializer);
        }
    }

    private static void serializeMap(Map<String, Object> childMap, Serializer serializer) {
        for (Map.Entry<String, Object> entry : childMap.entrySet()) {
            String name = entry.getKey();
            Object child = entry.getValue();
            ConfigInstance.serializeObject(name, child, serializer);
        }
    }

    private static void serializeArray(NodeVector<?> nodeVector, Serializer arraySerializer) {
        for (Object child : nodeVector.vector) {
            if (child instanceof InnerNode) {
                Serializer childSerializer = arraySerializer.createInner();
                ConfigInstance.serialize((InnerNode)child, childSerializer);
                continue;
            }
            if (!(child instanceof LeafNode)) continue;
            ((LeafNode)child).serialize(arraySerializer);
        }
    }

    private static String getStaticStringField(Class<?> type, String fieldName) {
        try {
            return (String)type.getField(fieldName).get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage() + ": Static field " + fieldName + " not accessible in " + type.getName());
        }
    }

    public static interface Producer {
    }

    public static interface Builder
    extends ConfigBuilder {
        public boolean dispatchGetConfig(Producer var1);

        public String getDefName();

        public String getDefNamespace();

        public String getDefMd5();

        default public boolean getApplyOnRestart() {
            return false;
        }

        default public void setApplyOnRestart(boolean applyOnRestart) {
            throw new UnsupportedOperationException();
        }
    }
}

