/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Scheme {
    HTTP,
    HTTPS,
    WS,
    WSS;

    private static Map<String, Scheme> names;

    @JsonCreator
    public static Scheme forValue(String value) {
        return names.get(value.toLowerCase());
    }

    @JsonValue
    public String toValue() {
        for (Map.Entry<String, Scheme> entry : names.entrySet()) {
            if (entry.getValue() != this) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        names = new HashMap<String, Scheme>();
        names.put("http", HTTP);
        names.put("https", HTTPS);
        names.put("ws", WS);
        names.put("wss", WSS);
    }
}

