/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.standard.app.development.listener.ref;

import com.webank.wedatasphere.dss.standard.app.development.listener.async.RefExecutionResponseListener;
import com.webank.wedatasphere.dss.standard.app.development.listener.common.RefExecutionAction;
import com.webank.wedatasphere.dss.standard.app.development.listener.core.LongTermRefExecutionOperation;
import com.webank.wedatasphere.dss.standard.app.development.listener.ref.ExecutionResponseRef;
import com.webank.wedatasphere.dss.standard.app.development.listener.ref.RefExecutionRequestRef;
import com.webank.wedatasphere.dss.standard.common.entity.ref.AsyncResponseRef;
import com.webank.wedatasphere.dss.standard.common.entity.ref.ResponseRef;
import com.webank.wedatasphere.dss.standard.common.entity.ref.ResponseRefImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public interface AsyncExecutionResponseRef
extends AsyncResponseRef {
    public RefExecutionAction getAction();

    public RefExecutionRequestRef getExecutionRequestRef();

    public LongTermRefExecutionOperation getRefExecutionOperation();

    public long getAskStatePeriod();

    public void setCompleted(ExecutionResponseRef var1);

    public long getMaxLoopTime();

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final AsyncExecutionResponseRefImpl asyncResponseRef = new AsyncExecutionResponseRefImpl();

        public Builder setAction(RefExecutionAction action) {
            this.asyncResponseRef.action = action;
            return this;
        }

        public Builder addListener(RefExecutionResponseListener listener) {
            this.asyncResponseRef.listeners.add(listener);
            return this;
        }

        public Builder setRefExecutionOperation(LongTermRefExecutionOperation refExecutionOperation) {
            this.asyncResponseRef.refExecutionOperation = refExecutionOperation;
            return this;
        }

        public Builder setExecutionRequestRef(RefExecutionRequestRef requestRef) {
            this.asyncResponseRef.requestRef = requestRef;
            return this;
        }

        public Builder setMaxLoopTime(long maxLoopTime) {
            this.asyncResponseRef.maxLoopTime = maxLoopTime;
            return this;
        }

        public Builder setAskStatePeriod(long askStatePeriod) {
            this.asyncResponseRef.askStatePeriod = askStatePeriod;
            return this;
        }

        public Builder setAsyncExecutionResponseRef(AsyncExecutionResponseRef responseRef) {
            if (!(responseRef instanceof AsyncExecutionResponseRefImpl)) {
                return this;
            }
            AsyncExecutionResponseRefImpl asyncResponseRef = (AsyncExecutionResponseRefImpl)responseRef;
            if (this.asyncResponseRef.action == null) {
                this.asyncResponseRef.action = asyncResponseRef.action;
            }
            if (!asyncResponseRef.listeners.isEmpty()) {
                this.asyncResponseRef.listeners.addAll(asyncResponseRef.listeners);
            }
            if (this.asyncResponseRef.refExecutionOperation == null) {
                this.asyncResponseRef.refExecutionOperation = asyncResponseRef.refExecutionOperation;
            }
            if (this.asyncResponseRef.requestRef == null) {
                this.asyncResponseRef.requestRef = asyncResponseRef.requestRef;
            }
            if (this.asyncResponseRef.maxLoopTime <= 0L) {
                this.asyncResponseRef.maxLoopTime = asyncResponseRef.maxLoopTime;
            }
            if (this.asyncResponseRef.askStatePeriod == 1000L) {
                this.asyncResponseRef.askStatePeriod = asyncResponseRef.askStatePeriod;
            }
            if (this.asyncResponseRef.response == null) {
                this.asyncResponseRef.response = asyncResponseRef.response;
            }
            this.asyncResponseRef.startTime = asyncResponseRef.startTime;
            if (!this.asyncResponseRef.isCompleted) {
                this.asyncResponseRef.isCompleted = asyncResponseRef.isCompleted;
            }
            return this;
        }

        public AsyncExecutionResponseRef build() {
            return this.asyncResponseRef;
        }

        class AsyncExecutionResponseRefImpl
        extends ResponseRefImpl
        implements AsyncExecutionResponseRef {
            RefExecutionAction action;
            List<RefExecutionResponseListener> listeners;
            LongTermRefExecutionOperation refExecutionOperation;
            RefExecutionRequestRef requestRef;
            ExecutionResponseRef response;
            long maxLoopTime;
            long askStatePeriod;
            long startTime;
            boolean isCompleted;
            private final Object lock;

            public AsyncExecutionResponseRefImpl() {
                super("", 1, "", new HashMap(0));
                this.listeners = new ArrayList<RefExecutionResponseListener>();
                this.askStatePeriod = 1000L;
                this.startTime = System.currentTimeMillis();
                this.isCompleted = false;
                this.lock = new Object();
            }

            @Override
            public RefExecutionAction getAction() {
                return this.action;
            }

            @Override
            public RefExecutionRequestRef getExecutionRequestRef() {
                return this.requestRef;
            }

            @Override
            public LongTermRefExecutionOperation getRefExecutionOperation() {
                return this.refExecutionOperation;
            }

            @Override
            public long getAskStatePeriod() {
                return this.askStatePeriod;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCompleted(ExecutionResponseRef response) {
                this.isCompleted = true;
                this.response = response;
                this.status = response.getStatus();
                this.responseBody = response.getResponseBody();
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
                this.listeners.forEach(l -> l.onRefExecutionCompleted(response));
            }

            @Override
            public long getMaxLoopTime() {
                return this.maxLoopTime;
            }

            public long getStartTime() {
                return this.startTime;
            }

            public ResponseRef getResponse() {
                return this.response;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void waitForCompleted() throws InterruptedException {
                Object object = this.lock;
                synchronized (object) {
                    while (!this.isCompleted) {
                        this.lock.wait(2000L);
                    }
                }
            }

            public void notifyMe(Consumer<ResponseRef> notifyListener) {
                Builder.this.addListener(notifyListener::accept);
            }

            public Map<String, Object> toMap() {
                if (this.response != null) {
                    return this.response.toMap();
                }
                return super.toMap();
            }

            public String getErrorMsg() {
                if (this.response != null) {
                    return this.response.getErrorMsg();
                }
                return this.errorMsg;
            }

            public boolean isSucceed() {
                return this.response != null && this.response.isSucceed();
            }

            public boolean isFailed() {
                return this.response != null && this.response.isFailed();
            }
        }
    }
}

