/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.standard.app.development.listener.core;

import com.webank.wedatasphere.dss.standard.app.development.listener.async.RefExecutionStatusListener;
import com.webank.wedatasphere.dss.standard.app.development.listener.common.AbstractRefExecutionAction;
import com.webank.wedatasphere.dss.standard.app.development.listener.common.RefExecutionAction;
import com.webank.wedatasphere.dss.standard.app.development.listener.common.RefExecutionState;
import com.webank.wedatasphere.dss.standard.app.development.listener.core.ExecutionRequestRefContext;
import com.webank.wedatasphere.dss.standard.app.development.listener.core.SchedulerManager;
import com.webank.wedatasphere.dss.standard.app.development.listener.ref.AsyncExecutionResponseRef;
import com.webank.wedatasphere.dss.standard.app.development.listener.ref.ExecutionResponseRef;
import com.webank.wedatasphere.dss.standard.app.development.listener.ref.RefExecutionRequestRef;
import com.webank.wedatasphere.dss.standard.app.development.listener.scheduler.LongTermRefExecutionScheduler;
import com.webank.wedatasphere.dss.standard.app.development.operation.AbstractDevelopmentOperation;
import com.webank.wedatasphere.dss.standard.app.development.operation.RefExecutionOperation;
import com.webank.wedatasphere.dss.standard.common.entity.ref.ResponseRef;
import com.webank.wedatasphere.dss.standard.common.exception.operation.ExternalOperationFailedException;
import java.util.ArrayList;
import java.util.List;

public abstract class LongTermRefExecutionOperation<K extends RefExecutionRequestRef<K>>
extends AbstractDevelopmentOperation<K, ResponseRef>
implements RefExecutionOperation<K> {
    private List<RefExecutionStatusListener<K>> refExecutionListener = new ArrayList<RefExecutionStatusListener<K>>();
    private LongTermRefExecutionScheduler scheduler = SchedulerManager.getScheduler();

    public void addRefExecutionStatusListener(RefExecutionStatusListener<K> refExecutionListener) {
        for (RefExecutionStatusListener<K> listener : this.refExecutionListener) {
            if (!listener.getClass().equals(refExecutionListener.getClass())) continue;
            return;
        }
        this.refExecutionListener.add(refExecutionListener);
    }

    protected abstract RefExecutionAction submit(K var1) throws ExternalOperationFailedException;

    public abstract RefExecutionState state(RefExecutionAction var1) throws ExternalOperationFailedException;

    public abstract ExecutionResponseRef result(RefExecutionAction var1) throws ExternalOperationFailedException;

    protected ExecutionRequestRefContext createExecutionRequestRefContext(K requestRef) {
        return requestRef.getExecutionRequestRefContext();
    }

    public final ResponseRef execute(K requestRef) throws ExternalOperationFailedException {
        this.refExecutionListener.forEach(l -> l.beforeSubmit(requestRef));
        RefExecutionAction action = this.submit(requestRef);
        if (action instanceof AbstractRefExecutionAction) {
            ((AbstractRefExecutionAction)action).setExecutionRequestRefContext(this.createExecutionRequestRefContext(requestRef));
        }
        this.refExecutionListener.forEach(l -> l.afterSubmit(requestRef, action));
        RefExecutionState state = this.state(action);
        if (state != null && state.isCompleted()) {
            ExecutionResponseRef response = this.result(action);
            this.refExecutionListener.forEach(l -> l.afterCompletedExecutionResponseRef(requestRef, action, response));
            return response;
        }
        AsyncExecutionResponseRef oldResponse = this.createAsyncResponseRef(requestRef, action);
        AsyncExecutionResponseRef response = AsyncExecutionResponseRef.newBuilder().setAsyncExecutionResponseRef(oldResponse).setRefExecutionOperation(this).addListener(r -> this.refExecutionListener.forEach(l -> l.afterCompletedExecutionResponseRef(requestRef, action, r))).build();
        this.refExecutionListener.forEach(l -> l.afterAsyncResponseRef(response));
        this.scheduler.addAsyncResponse(response);
        return response;
    }

    protected AsyncExecutionResponseRef createAsyncResponseRef(K requestRef, RefExecutionAction action) {
        return AsyncExecutionResponseRef.newBuilder().setAction(action).setExecutionRequestRef((RefExecutionRequestRef)requestRef).build();
    }
}

