/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.common.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.conf.BDPConfiguration$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class DSSConfiguration$
implements Logging {
    public static DSSConfiguration$ MODULE$;
    private final String MAPPER_LOCATIONS;
    private final String TYPE_ALIASES_PACKAGE;
    private final String BASE_PACKAGE;
    private final String RESTFUL_SCAN_PACKAGES;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new DSSConfiguration$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        DSSConfiguration$ dSSConfiguration$ = this;
        synchronized (dSSConfiguration$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String MAPPER_LOCATIONS() {
        return this.MAPPER_LOCATIONS;
    }

    private String TYPE_ALIASES_PACKAGE() {
        return this.TYPE_ALIASES_PACKAGE;
    }

    private String BASE_PACKAGE() {
        return this.BASE_PACKAGE;
    }

    private String RESTFUL_SCAN_PACKAGES() {
        return this.RESTFUL_SCAN_PACKAGES;
    }

    public Properties getAllProperties() {
        return BDPConfiguration$.MODULE$.properties();
    }

    public void addLegacyConfiguration(String[] serverConfs) {
        ArrayList mapperLocationList = new ArrayList();
        ArrayList typeAliasesPackageList = new ArrayList();
        ArrayList basePackageList = new ArrayList();
        ArrayList restfulScanPackagesList = new ArrayList();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])serverConfs)).foreach((Function1 & Serializable & scala.Serializable)serverConf -> {
            DSSConfiguration$.$anonfun$addLegacyConfiguration$1(mapperLocationList, typeAliasesPackageList, basePackageList, restfulScanPackagesList, serverConf);
            return BoxedUnit.UNIT;
        });
        this.setConfig(this.MAPPER_LOCATIONS(), this.distinctStr(String.join((CharSequence)",", mapperLocationList)));
        this.setConfig(this.TYPE_ALIASES_PACKAGE(), this.distinctStr(String.join((CharSequence)",", typeAliasesPackageList)));
        this.setConfig(this.BASE_PACKAGE(), this.distinctStr(String.join((CharSequence)",", basePackageList)));
        this.setConfig(this.RESTFUL_SCAN_PACKAGES(), this.distinctStr(String.join((CharSequence)",", restfulScanPackagesList)));
    }

    private String distinctStr(String str) {
        return String.join((CharSequence)",", Arrays.stream((Object[])new StringOps(Predef$.MODULE$.augmentString(str)).split(',')).collect(Collectors.toSet()));
    }

    private void initConfig(Properties config, String filePath) {
        ObjectRef inputStream = ObjectRef.create(null);
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            inputStream$1.elem = new FileInputStream(filePath);
            config.load((InputStream)inputStream$1.elem);
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            DSSConfiguration$.$anonfun$initConfig$3(filePath, x0$1);
            return BoxedUnit.UNIT;
        }), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((InputStream)((InputStream)inputStream$1.elem)));
    }

    public void setConfig(String key, String value) {
        this.logger().info(new StringBuilder(33).append("try to set a config, key:").append(key).append(", value:").append(value).toString());
        BDPConfiguration$.MODULE$.set(key, value);
    }

    public void setSpringApplicationName(String name) {
        BDPConfiguration$.MODULE$.set("spring.spring.application.name", name);
    }

    public static final /* synthetic */ void $anonfun$addLegacyConfiguration$1(ArrayList mapperLocationList$1, ArrayList typeAliasesPackageList$1, ArrayList basePackageList$1, ArrayList restfulScanPackagesList$1, String serverConf) {
        URL serverConfFileURL = MODULE$.getClass().getClassLoader().getResource(serverConf);
        if (serverConfFileURL != null && new File(serverConfFileURL.getPath()).exists()) {
            MODULE$.logger().info(new StringBuilder(80).append("*********************** Notice: The DSS serverConf file is ").append(serverConf).append(" ! ******************").toString());
            Properties config = new Properties();
            MODULE$.initConfig(config, serverConfFileURL.getPath());
            ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(config).asScala()).toMap(Predef$.MODULE$.$conforms()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = k;
                    String string2 = MODULE$.MAPPER_LOCATIONS();
                    String string3 = string;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        return BoxesRunTime.boxToBoolean((boolean)mapperLocationList$1.add(v));
                    }
                    String string4 = MODULE$.TYPE_ALIASES_PACKAGE();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        return BoxesRunTime.boxToBoolean((boolean)typeAliasesPackageList$1.add(v));
                    }
                    String string6 = MODULE$.BASE_PACKAGE();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        return BoxesRunTime.boxToBoolean((boolean)basePackageList$1.add(v));
                    }
                    String string8 = MODULE$.RESTFUL_SCAN_PACKAGES();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        return BoxesRunTime.boxToBoolean((boolean)restfulScanPackagesList$1.add(v));
                    }
                    MODULE$.setConfig(k, v);
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
        MODULE$.logger().warn(new StringBuilder(85).append("**************** Notice: The DSS serverConf file ").append(serverConf).append(" does not exist! *******************").toString());
    }

    public static final /* synthetic */ void $anonfun$initConfig$3(String filePath$1, Throwable x0$1) {
        Throwable throwable = x0$1;
        if (throwable instanceof IOException) {
            IOException iOException = (IOException)throwable;
            MODULE$.logger().error(new StringBuilder(11).append("Can't load ").append(filePath$1).toString(), (Throwable)iOException);
            return;
        }
        throw new MatchError((Object)throwable);
    }

    private DSSConfiguration$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.MAPPER_LOCATIONS = "wds.linkis.server.mybatis.mapperLocations";
        this.TYPE_ALIASES_PACKAGE = "wds.linkis.server.mybatis.typeAliasesPackage";
        this.BASE_PACKAGE = "wds.linkis.server.mybatis.BasePackage";
        this.RESTFUL_SCAN_PACKAGES = "wds.linkis.server.restful.scan.packages";
    }
}

