/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.common.utils;

import com.webank.wedatasphere.dss.common.conf.DSSCommonConf;
import com.webank.wedatasphere.dss.common.entity.IOType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoUtils {
    private static Logger logger = LoggerFactory.getLogger(IoUtils.class);
    private static final String DATE_FORMAT = "yyyyMMddHHmmssSSS";
    private static final String DEFAULT_IO_FILE_NAME = "IO.properties";

    public static String generateIOPath(String userName, String projectName, String subDir) {
        String baseUrl = (String)DSSCommonConf.DSS_EXPORT_URL.getValue();
        String dataStr = new SimpleDateFormat(DATE_FORMAT).format(new Date());
        return IoUtils.addFileSeparator(baseUrl, dataStr, userName, projectName, subDir);
    }

    private static String addFileSeparator(String ... str) {
        return Arrays.stream(str).reduce((a, b) -> a + File.separator + b).orElse("");
    }

    public static OutputStream generateExportOutputStream(String path) throws IOException {
        File file = new File(path);
        if (!file.getParentFile().exists()) {
            FileUtils.forceMkdir((File)file.getParentFile());
        }
        if (file.exists()) {
            logger.warn(String.format("%s is exist,delete it", path));
            file.delete();
        }
        file.createNewFile();
        return FileUtils.openOutputStream((File)file, (boolean)true);
    }

    public static InputStream generateInputInputStream(String path) throws IOException {
        return new FileInputStream(path);
    }

    public static void generateIOType(IOType ioType, String basePath) throws IOException {
        IoUtils.generateIOProperties("type", ioType.name(), basePath);
    }

    public static void generateIOProperties(String key, String value, String basePath) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(key, value);
        File file = new File(basePath + File.separator + DEFAULT_IO_FILE_NAME);
        if (!file.getParentFile().exists()) {
            FileUtils.forceMkdir((File)file.getParentFile());
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        try (FileOutputStream fileOutputStream = FileUtils.openOutputStream((File)file, (boolean)true);){
            properties.store(fileOutputStream, "");
        }
    }

    public static String readIOProperties(String key, String basepath) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(basepath + File.separator + DEFAULT_IO_FILE_NAME);){
            Properties properties = new Properties();
            properties.load(inputStream);
            String string = properties.get(key).toString();
            return string;
        }
    }

    public static void generateIOEnv(String basePath) throws IOException {
        IoUtils.generateIOProperties("env", IoUtils.getDSSServerEnv(), basePath);
    }

    public static String getDSSServerEnv() {
        return (String)DSSCommonConf.DSS_IO_ENV.getValue();
    }
}

