/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.common.utils;

import com.webank.wedatasphere.dss.common.conf.DSSCommonConf;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.conf.BDPConfiguration;
import org.apache.linkis.protocol.util.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalLimitsUtils {
    private static final Logger logger = LoggerFactory.getLogger(GlobalLimitsUtils.class);
    private static volatile Map<String, Object> globalLimits;
    private static final Map<String, Map<String, Object>> globalLimitContents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Object> getAllGlobalLimits() {
        if (globalLimits != null) return globalLimits;
        Class<GlobalLimitsUtils> clazz = GlobalLimitsUtils.class;
        synchronized (GlobalLimitsUtils.class) {
            if (globalLimits != null) return globalLimits;
            globalLimits = MapUtils.unmodifiableMap(GlobalLimitsUtils.getMap((String)DSSCommonConf.ALL_GLOBAL_LIMITS_PREFIX.acquireNew()));
            logger.info("loaded global limits is {}.", globalLimits);
            // ** MonitorExit[var0] (shouldn't be in output)
            return globalLimits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getGlobalLimitMap(String globalLimitName) {
        if (globalLimitContents.containsKey(globalLimitName)) {
            return globalLimitContents.get(globalLimitName);
        }
        Map<String, Map<String, Object>> map = globalLimitContents;
        synchronized (map) {
            if (!globalLimitContents.containsKey(globalLimitName)) {
                Map<String, Object> globalLimitContent = GlobalLimitsUtils.getMap((String)DSSCommonConf.GLOBAL_LIMIT_PREFIX.acquireNew() + globalLimitName + ".");
                logger.info("loaded global limit {}, the contents are {}.", (Object)globalLimitName, globalLimitContent);
                globalLimitContents.put(globalLimitName, MapUtils.unmodifiableMap(globalLimitContent));
            }
        }
        return globalLimitContents.get(globalLimitName);
    }

    private static Map<String, Object> getMap(String prefix) {
        return BDPConfiguration.properties().entrySet().stream().filter(entry -> entry.getKey().toString().startsWith(prefix) && entry.getValue() != null && StringUtils.isNotBlank((String)entry.getValue().toString())).map(entry -> {
            String key = ((String)entry.getKey()).substring(prefix.length());
            if ("true".equals(entry.getValue()) || "false".equals(entry.getValue())) {
                return new ImmutablePair((Object)key, (Object)Boolean.parseBoolean((String)entry.getValue()));
            }
            return new ImmutablePair((Object)key, entry.getValue());
        }).collect(HashMap::new, (map, pair) -> map.put((String)pair.getKey(), pair.getValue()), HashMap::putAll);
    }

    static {
        globalLimitContents = new HashMap<String, Map<String, Object>>();
    }
}

