/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.common.utils;

import com.webank.wedatasphere.dss.common.exception.Apply;
import com.webank.wedatasphere.dss.common.exception.DSSRuntimeException;
import com.webank.wedatasphere.dss.common.exception.ThrowingApply;
import com.webank.wedatasphere.dss.common.exception.ThrowingConsumer;
import com.webank.wedatasphere.dss.common.exception.ThrowingFunction;
import com.webank.wedatasphere.dss.common.exception.ThrowingSupplier;
import java.lang.reflect.Constructor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.common.exception.WarnException;
import org.apache.linkis.server.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSSExceptionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DSSExceptionUtils.class);

    public static <T, E extends Exception> Consumer<T> handling(ThrowingConsumer<T, E> throwingConsumer) {
        return i -> {
            try {
                throwingConsumer.accept(i);
            }
            catch (Exception e) {
                LOGGER.error("execute failed, reason: ", (Throwable)e);
                throw new DSSRuntimeException(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, R> map(ThrowingFunction<T, R, E> throwingFunction) {
        return i -> {
            try {
                return throwingFunction.accept(i);
            }
            catch (Exception e) {
                LOGGER.error("execute failed,reason:", (Throwable)e);
                throw new DSSRuntimeException(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        };
    }

    public static <R, E extends Exception> R tryAndWarn(ThrowingFunction<Void, R, E> throwingFunction) {
        Function<Void, Object> function = i -> {
            try {
                return throwingFunction.accept((Void)i);
            }
            catch (Exception e) {
                LOGGER.error("execute failed,reason:", (Throwable)e);
                throw new DSSRuntimeException(53320, ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        };
        return (R)function.apply(null);
    }

    public static <T extends ErrorException> void dealErrorException(int errorCode, String errorDesc, Throwable throwable, Class<T> clazz) throws T {
        ErrorException errorException;
        try {
            Constructor<T> constructor = clazz.getConstructor(Integer.TYPE, String.class);
            errorException = (ErrorException)constructor.newInstance(errorCode, errorDesc);
        }
        catch (Exception e) {
            if (throwable == null) {
                throw new DSSRuntimeException(errorCode, errorDesc, e);
            }
            throw new DSSRuntimeException(errorCode, errorDesc, throwable);
        }
        errorException.setErrCode(errorCode);
        errorException.setDesc(errorDesc);
        if (throwable != null) {
            errorException.initCause(throwable);
        }
        throw errorException;
    }

    public static <T extends ErrorException> void dealErrorException(int errorCode, String errorDesc, Class<T> clazz) throws T {
        DSSExceptionUtils.dealErrorException(errorCode, errorDesc, null, clazz);
    }

    public static <T extends WarnException> void dealWarnException(int errorCode, String errorDesc, Class<T> clazz) {
        DSSExceptionUtils.dealWarnException(errorCode, errorDesc, null, clazz);
    }

    public static <T extends WarnException> void dealWarnException(int errorCode, String errorDesc, Throwable throwable, Class<T> clazz) {
        WarnException warnException;
        try {
            Constructor<T> constructor = clazz.getConstructor(Integer.TYPE, String.class);
            warnException = (WarnException)constructor.newInstance(errorCode, errorDesc);
        }
        catch (Exception e) {
            if (throwable == null) {
                throw new DSSRuntimeException(errorCode, errorDesc, e);
            }
            throw new DSSRuntimeException(errorCode, errorDesc, throwable);
        }
        warnException.setErrCode(errorCode);
        warnException.setDesc(errorDesc);
        if (throwable != null) {
            warnException.initCause(throwable);
        }
        throw warnException;
    }

    public static <T> Message getMessage(ThrowingSupplier<T, Exception> supplier, Function<T, Message> function, String errorMsg) {
        T result;
        try {
            result = supplier.get();
        }
        catch (ErrorException e) {
            LOGGER.error(errorMsg, (Throwable)e);
            return Message.error((String)(errorMsg + e.getDesc()));
        }
        catch (WarnException e) {
            LOGGER.error(errorMsg, (Throwable)e);
            return Message.error((String)(errorMsg + e.getDesc()));
        }
        catch (Exception e) {
            LOGGER.error(errorMsg, (Throwable)e);
            return Message.error((String)(errorMsg + " \u539f\u56e0\uff1a" + ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
        return function.apply(result);
    }

    public static Message getMessage(ThrowingApply<Exception> apply, Supplier<Message> supplier, String errorMsg) {
        try {
            apply.apply();
        }
        catch (ErrorException e) {
            LOGGER.error(errorMsg, (Throwable)e);
            return Message.error((String)(errorMsg + e.getDesc()));
        }
        catch (WarnException e) {
            LOGGER.error(errorMsg, (Throwable)e);
            return Message.error((String)(errorMsg + e.getDesc()));
        }
        catch (Exception e) {
            LOGGER.error(errorMsg, (Throwable)e);
            return Message.error((String)(errorMsg + " \u539f\u56e0\uff1a" + ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
        return supplier.get();
    }

    public static <T> Message applyMessage(Supplier<T> supplier, Function<T, Message> function, String errorMsg) {
        return DSSExceptionUtils.getMessage(supplier::get, function, errorMsg);
    }

    public static <T> Message applyMessage(Apply apply, Supplier<Message> supplier, String errorMsg) {
        return DSSExceptionUtils.getMessage(apply::apply, supplier, errorMsg);
    }
}

