/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.common.utils;

import com.webank.wedatasphere.dss.common.exception.DSSErrorException;
import com.webank.wedatasphere.dss.common.exception.DSSRuntimeException;
import com.webank.wedatasphere.dss.common.utils.DSSExceptionUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.reflections.Reflections;

public class ClassUtils {
    private static final ClassHelper CLASS_HELPER = new ClassHelper(){

        @Override
        protected Reflections getReflections(Class<?> clazz) {
            return org.apache.linkis.common.utils.ClassUtils.reflections();
        }
    };

    public static <T> T getInstance(Class<T> clazz) throws DSSErrorException {
        return CLASS_HELPER.getInstance(clazz);
    }

    public static <T> T getInstanceOrWarn(Class<T> clazz) {
        return CLASS_HELPER.getInstanceOrWarn(clazz);
    }

    public static <T> T getInstanceOrDefault(Class<T> clazz, T defaultValue) {
        return CLASS_HELPER.getInstanceOrDefault(clazz, defaultValue);
    }

    public static <T> T getInstanceOrDefault(Class<T> clazz, Predicate<Class<? extends T>> filterOp, T defaultValue) {
        return CLASS_HELPER.getInstanceOrDefault(clazz, filterOp, defaultValue);
    }

    public static <T> List<T> getInstances(Class<T> clazz) {
        return CLASS_HELPER.getInstances(clazz);
    }

    public static <T> List<T> getInstances(Class<T> clazz, Predicate<Class<? extends T>> filterOp) {
        return CLASS_HELPER.getInstances(clazz, filterOp);
    }

    public static <T> List<Class<? extends T>> getClasses(Class<T> clazz) {
        return CLASS_HELPER.getClasses(clazz);
    }

    public static abstract class ClassHelper {
        protected abstract Reflections getReflections(Class<?> var1);

        public <T> T getInstance(Class<T> clazz) throws DSSErrorException {
            List factoryClasses = this.getReflections(clazz).getSubTypesOf(clazz).stream().filter(c -> !org.apache.linkis.common.utils.ClassUtils.isInterfaceOrAbstract((Class)c)).collect(Collectors.toList());
            if (factoryClasses.isEmpty()) {
                DSSExceptionUtils.dealErrorException(60053, "Cannot find instance for " + clazz.getSimpleName(), DSSErrorException.class);
            } else if (factoryClasses.size() > 1) {
                DSSExceptionUtils.dealErrorException(60053, "Too many instances for " + clazz.getSimpleName() + ", exists: " + factoryClasses, DSSErrorException.class);
            }
            T t = null;
            try {
                t = ((Class)factoryClasses.get(0)).newInstance();
            }
            catch (Exception e) {
                DSSExceptionUtils.dealErrorException(60053, "Instance " + clazz.getSimpleName() + " failed", e, DSSErrorException.class);
            }
            return t;
        }

        public <T> T getInstanceOrWarn(Class<T> clazz) {
            try {
                return this.getInstance(clazz);
            }
            catch (DSSErrorException e) {
                DSSExceptionUtils.dealWarnException(60053, e.getDesc(), ExceptionUtils.getCause((Throwable)((Object)e)), DSSRuntimeException.class);
                return null;
            }
        }

        public <T> T getInstanceOrDefault(Class<T> clazz, T defaultValue) {
            Optional<Object> optional = this.getReflections(clazz).getSubTypesOf(clazz).stream().filter(c -> !org.apache.linkis.common.utils.ClassUtils.isInterfaceOrAbstract((Class)c) && !c.isInstance(defaultValue)).findFirst().map(DSSExceptionUtils.map(Class::newInstance));
            return (T)optional.orElse(defaultValue);
        }

        public <T> T getInstanceOrDefault(Class<T> clazz, Predicate<Class<? extends T>> filterOp, T defaultValue) {
            Optional<Object> optional = this.getReflections(clazz).getSubTypesOf(clazz).stream().filter(c -> !org.apache.linkis.common.utils.ClassUtils.isInterfaceOrAbstract((Class)c) && filterOp.test((Class)c)).findFirst().map(DSSExceptionUtils.map(Class::newInstance));
            return (T)optional.orElse(defaultValue);
        }

        public <T> List<T> getInstances(Class<T> clazz) {
            return this.getInstances(clazz, c -> true);
        }

        public <T> List<T> getInstances(Class<T> clazz, Predicate<Class<? extends T>> filterOp) {
            return this.getReflections(clazz).getSubTypesOf(clazz).stream().filter(c -> !org.apache.linkis.common.utils.ClassUtils.isInterfaceOrAbstract((Class)c) && filterOp.test((Class)c)).map(DSSExceptionUtils.map(Class::newInstance)).collect(Collectors.toList());
        }

        public <T> List<Class<? extends T>> getClasses(Class<T> clazz) {
            return this.getReflections(clazz).getSubTypesOf(clazz).stream().filter(c -> !org.apache.linkis.common.utils.ClassUtils.isInterfaceOrAbstract((Class)c)).collect(Collectors.toList());
        }
    }
}

