/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.common.service;

import com.webank.wedatasphere.dss.common.entity.BmlResource;
import com.webank.wedatasphere.dss.common.exception.DSSErrorException;
import com.webank.wedatasphere.dss.common.service.BMLService$;
import com.webank.wedatasphere.dss.common.utils.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.bml.client.BmlClient;
import org.apache.linkis.bml.client.BmlClientFactory;
import org.apache.linkis.bml.protocol.BmlAttachResourceAndProjectResponse;
import org.apache.linkis.bml.protocol.BmlCreateProjectResponse;
import org.apache.linkis.bml.protocol.BmlDeleteResponse;
import org.apache.linkis.bml.protocol.BmlDownloadResponse;
import org.apache.linkis.bml.protocol.BmlUpdateProjectPrivResponse;
import org.apache.linkis.bml.protocol.BmlUpdateResponse;
import org.apache.linkis.bml.protocol.BmlUploadResponse;
import org.apache.linkis.common.utils.JavaLog;
import org.apache.linkis.common.utils.Utils$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.mutable.Map;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u000f\u001f\u0001-BQ!\u000f\u0001\u0005\u0002iB\u0011\"\u0010\u0001A\u0002\u0003\u0007I\u0011\u0001 \t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0003A\u0005\"C)\u0001\u0001\u0004\u0005\t\u0015)\u0003@\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015)\u0007\u0001\"\u0001}\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\b\u0001\t\u0003\tI\u0003C\u0004\u00022\u0001!\t!a\r\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003C\u0002A\u0011AA2\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!a\u001d\u0001\t\u0003\t)\bC\u0004\u0002~\u0001!I!a \t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAS\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003c\u0003A\u0011AAZ\u000f\u001d\tIL\bE\u0001\u0003w3a!\b\u0010\t\u0002\u0005u\u0006BB\u001d\u0018\t\u0003\t)\rC\u0006\u0002H^\u0001\r\u00111A\u0005\u0002\u0005%\u0007bCAf/\u0001\u0007\t\u0019!C\u0001\u0003\u001bD!\"!5\u0018\u0001\u0004\u0005\t\u0015)\u0003<\u0011\u0019\t)n\u0006C\u0001u\tQ!)\u0014'TKJ4\u0018nY3\u000b\u0005}\u0001\u0013aB:feZL7-\u001a\u0006\u0003C\t\naaY8n[>t'BA\u0012%\u0003\r!7o\u001d\u0006\u0003K\u0019\nAb^3eCR\f7\u000f\u001d5fe\u0016T!a\n\u0015\u0002\r],'-\u00198l\u0015\u0005I\u0013aA2p[\u000e\u00011C\u0001\u0001-!\tis'D\u0001/\u0015\ty\u0003'A\u0003vi&d7O\u0003\u0002\"c)\u0011!gM\u0001\u0007Y&t7.[:\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0005\u0003q9\u0012qAS1wC2{w-\u0001\u0004=S:LGO\u0010\u000b\u0002wA\u0011A\bA\u0007\u0002=\u0005I!-\u001c7DY&,g\u000e^\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0007G2LWM\u001c;\u000b\u0005\u0011\u000b\u0014a\u00012nY&\u0011a)\u0011\u0002\n\u00056d7\t\\5f]R\fQBY7m\u00072LWM\u001c;`I\u0015\fHCA%P!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u0011)f.\u001b;\t\u000fA\u001b\u0011\u0011!a\u0001\u007f\u0005\u0019\u0001\u0010J\u0019\u0002\u0015\tlGn\u00117jK:$\b\u0005\u000b\u0002\u0005'B\u0011!\nV\u0005\u0003+.\u0013\u0001B^8mCRLG.Z\u0001\rO\u0016$()\u001c7DY&,g\u000e\u001e\u000b\u0003\u007faCQ!W\u0003A\u0002i\u000b\u0001\"^:fe:\u000bW.\u001a\t\u00037\nt!\u0001\u00181\u0011\u0005u[U\"\u00010\u000b\u0005}S\u0013A\u0002\u001fs_>$h(\u0003\u0002b\u0017\u00061\u0001K]3eK\u001aL!a\u00193\u0003\rM#(/\u001b8h\u0015\t\t7*\u0001\u0004va2|\u0017\r\u001a\u000b\u0006OV4\bP\u001f\t\u0005Q6Tv.D\u0001j\u0015\tQ7.\u0001\u0003vi&d'\"\u00017\u0002\t)\fg/Y\u0005\u0003]&\u00141!T1q!\t\u00018/D\u0001r\u0015\t\u00118.\u0001\u0003mC:<\u0017B\u0001;r\u0005\u0019y%M[3di\")\u0011L\u0002a\u00015\")qO\u0002a\u00015\u000691m\u001c8uK:$\b\"B=\u0007\u0001\u0004Q\u0016\u0001\u00034jY\u0016t\u0015-\\3\t\u000bm4\u0001\u0019\u0001.\u0002\u0017A\u0014xN[3di:\u000bW.\u001a\u000b\n{\u0006\u001d\u0011\u0011BA\r\u00037\u00012A`A\u0002\u001b\u0005y(bAA\u0001A\u00051QM\u001c;jifL1!!\u0002\u0000\u0005-\u0011U\u000e\u001c*fg>,(oY3\t\u000be;\u0001\u0019\u0001.\t\u000f\u0005-q\u00011\u0001\u0002\u000e\u0005Y\u0011N\u001c9viN#(/Z1n!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\nW\u0006\u0011\u0011n\\\u0005\u0005\u0003/\t\tBA\u0006J]B,Ho\u0015;sK\u0006l\u0007\"B=\b\u0001\u0004Q\u0006\"B>\b\u0001\u0004Q\u0016AB;qI\u0006$X\rF\u0004h\u0003C\t\u0019#a\n\t\u000beC\u0001\u0019\u0001.\t\r\u0005\u0015\u0002\u00021\u0001[\u0003)\u0011Xm]8ve\u000e,\u0017\n\u001a\u0005\b\u0003\u0017A\u0001\u0019AA\u0007)\u001d9\u00171FA\u0017\u0003_AQ!W\u0005A\u0002iCa!!\n\n\u0001\u0004Q\u0006\"B<\n\u0001\u0004Q\u0016!B9vKJLHcB4\u00026\u0005]\u0012\u0011\b\u0005\u00063*\u0001\rA\u0017\u0005\u0007\u0003KQ\u0001\u0019\u0001.\t\r\u0005m\"\u00021\u0001[\u0003\u001d1XM]:j_:\f\u0001\u0002Z8x]2|\u0017\r\u001a\u000b\bO\u0006\u0005\u00131IA#\u0011\u0015I6\u00021\u0001[\u0011\u0019\t)c\u0003a\u00015\"1\u00111H\u0006A\u0002i\u000b1\u0003Z8x]2|\u0017\r\u001a+p\u0019>\u001c\u0017\r\u001c)bi\"$\u0012BWA&\u0003\u001b\ny%!\u0015\t\u000bec\u0001\u0019\u0001.\t\r\u0005\u0015B\u00021\u0001[\u0011\u0019\tY\u0004\u0004a\u00015\"1\u00111\u000b\u0007A\u0002i\u000bA\u0001]1uQ\u0006\u0011Bm\\<oY>\fG-\u00118e\u000f\u0016$H+\u001a=u)%Q\u0016\u0011LA.\u0003;\ny\u0006C\u0003Z\u001b\u0001\u0007!\f\u0003\u0004\u0002&5\u0001\rA\u0017\u0005\u0007\u0003wi\u0001\u0019\u0001.\t\r\u0005MS\u00021\u0001[\u0003U\u0011X-\u00193M_\u000e\fGNU3t_V\u00148-\u001a$jY\u0016$b!!\u0004\u0002f\u0005\u001d\u0004\"B-\u000f\u0001\u0004Q\u0006BBA5\u001d\u0001\u0007!,\u0001\u0005sK\u0006$\u0007+\u0019;i\u0003E\u0011X-\u00193M_\u000e\fG\u000eV3yi\u001aKG.\u001a\u000b\u00065\u0006=\u0014\u0011\u000f\u0005\u00063>\u0001\rA\u0017\u0005\u0007\u0003Sz\u0001\u0019\u0001.\u0002\u001fI,\u0017\r\u001a+fqR4%o\\7C\u001b2#rAWA<\u0003s\nY\bC\u0003Z!\u0001\u0007!\f\u0003\u0004\u0002&A\u0001\rA\u0017\u0005\u0007\u0003w\u0001\u0002\u0019\u0001.\u0002%%t\u0007/\u001e;tiJ,W\u000eV8TiJLgn\u001a\u000b\u00045\u0006\u0005\u0005bBA\u0006#\u0001\u0007\u0011QB\u0001\u0011GJ,\u0017\r^3C[2\u0004&o\u001c6fGR$\u0012\"SAD\u0003\u0017\u000bi)a&\t\r\u0005%%\u00031\u0001[\u0003!)8/\u001a:oC6,\u0007\"B>\u0013\u0001\u0004Q\u0006bBAH%\u0001\u0007\u0011\u0011S\u0001\nK\u0012LG/V:feN\u0004B\u0001[AJ5&\u0019\u0011QS5\u0003\t1K7\u000f\u001e\u0005\b\u00033\u0013\u0002\u0019AAI\u0003-\t7mY3tgV\u001bXM]:\u00021\u0005$H/Y2i%\u0016\u001cx.\u001e:dK\u0006sG\r\u0015:pU\u0016\u001cG\u000fF\u0004J\u0003?\u000b\t+a)\t\r\u0005%5\u00031\u0001[\u0011\u0015Y8\u00031\u0001[\u0011\u0019\t)c\u0005a\u00015\u0006\tR\u000f\u001d3bi\u0016\u0004&o\u001c6fGR\u0004&/\u001b<\u0015\u0013%\u000bI+a+\u0002.\u0006=\u0006\"B>\u0015\u0001\u0004Q\u0006BBAE)\u0001\u0007!\fC\u0004\u0002\u0010R\u0001\r!!%\t\u000f\u0005eE\u00031\u0001\u0002\u0012\u0006\tB-\u001a7fi\u0016\u0014U\u000e\u001c*fg>,(oY3\u0015\u000b%\u000b),a.\t\r\u0005%U\u00031\u0001[\u0011\u0019\t)#\u0006a\u00015\u0006Q!)\u0014'TKJ4\u0018nY3\u0011\u0005q:2cA\f\u0002@B\u0019!*!1\n\u0007\u0005\r7J\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003w\u000b!BY7m'\u0016\u0014h/[2f+\u0005Y\u0014A\u00042nYN+'O^5dK~#S-\u001d\u000b\u0004\u0013\u0006=\u0007b\u0002)\u001b\u0003\u0003\u0005\raO\u0001\fE6d7+\u001a:wS\u000e,\u0007\u0005\u000b\u0002\u001c'\u0006Yq-\u001a;J]N$\u0018M\\2f\u0001")
public class BMLService
extends JavaLog {
    private volatile BmlClient bmlClient;

    public static BMLService getInstance() {
        return BMLService$.MODULE$.getInstance();
    }

    public static void bmlService_$eq(BMLService bMLService) {
        BMLService$.MODULE$.bmlService_$eq(bMLService);
    }

    public static BMLService bmlService() {
        return BMLService$.MODULE$.bmlService();
    }

    public BmlClient bmlClient() {
        return this.bmlClient;
    }

    public void bmlClient_$eq(BmlClient x$1) {
        this.bmlClient = x$1;
    }

    public BmlClient getBmlClient(String userName) {
        if (this.bmlClient() == null) {
            BMLService bMLService = this;
            synchronized (bMLService) {
                if (this.bmlClient() == null) {
                    this.bmlClient_$eq(BmlClientFactory.createBmlClient((String)userName));
                }
            }
        }
        return this.bmlClient();
    }

    public java.util.Map<String, Object> upload(String userName, String content, String fileName, String projectName) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes("utf-8"));
        BmlClient client = this.getBmlClient(userName);
        BmlUploadResponse resource = client.uploadShareResource(userName, projectName, fileName, (InputStream)inputStream);
        if (!resource.isSuccess()) {
            throw new DSSErrorException(911113, "\u4e0a\u4f20\u5931\u8d25");
        }
        HashMap map = new HashMap();
        JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resource.resourceId()));
        return JavaConversions$.MODULE$.deprecated$u0020mutableMapAsJavaMap((Map)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)resource.version())));
    }

    public BmlResource upload(String userName, InputStream inputStream, String fileName, String projectName) {
        BmlClient client = this.getBmlClient(userName);
        BmlUploadResponse resource = client.uploadShareResource(userName, projectName, fileName, inputStream);
        if (!resource.isSuccess()) {
            throw new DSSErrorException(911113, "\u4e0a\u4f20\u5931\u8d25");
        }
        return new BmlResource(resource.resourceId(), resource.version());
    }

    public java.util.Map<String, Object> update(String userName, String resourceId, InputStream inputStream) {
        BmlClient client = this.getBmlClient(userName);
        BmlUpdateResponse resource = client.updateShareResource(userName, resourceId, "", inputStream);
        if (!resource.isSuccess()) {
            throw new DSSErrorException(911114, "\u66f4\u65b0\u5931\u8d25");
        }
        HashMap map = new HashMap();
        JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resource.resourceId()));
        return JavaConversions$.MODULE$.deprecated$u0020mutableMapAsJavaMap((Map)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)resource.version())));
    }

    public java.util.Map<String, Object> update(String userName, String resourceId, String content) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes("utf-8"));
        BmlClient client = this.getBmlClient(userName);
        BmlUpdateResponse resource = client.updateShareResource(userName, resourceId, new StringBuilder(5).append(UUID.randomUUID().toString()).append(".json").toString(), (InputStream)inputStream);
        if (!resource.isSuccess()) {
            throw new DSSErrorException(911114, "\u66f4\u65b0\u5931\u8d25");
        }
        HashMap map = new HashMap();
        JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resource.resourceId()));
        return JavaConversions$.MODULE$.deprecated$u0020mutableMapAsJavaMap((Map)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)resource.version())));
    }

    public java.util.Map<String, Object> query(String userName, String resourceId, String version) {
        BmlClient client = this.getBmlClient(userName);
        BmlDownloadResponse resource = null;
        resource = version == null ? client.downloadShareResource(userName, resourceId) : client.downloadShareResource(userName, resourceId, version);
        if (!resource.isSuccess()) {
            throw new DSSErrorException(911115, "\u4e0b\u8f7d\u5931\u8d25");
        }
        HashMap map = new HashMap();
        JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)resource.fullFilePath()));
        return JavaConversions$.MODULE$.deprecated$u0020mutableMapAsJavaMap((Map)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string"), (Object)this.inputstremToString(resource.inputStream()))));
    }

    public java.util.Map<String, Object> download(String userName, String resourceId, String version) {
        BmlClient client = this.getBmlClient(userName);
        BmlDownloadResponse resource = null;
        resource = version == null ? client.downloadShareResource(userName, resourceId) : client.downloadShareResource(userName, resourceId, version);
        if (!resource.isSuccess()) {
            throw new DSSErrorException(911115, "\u4e0b\u8f7d\u5931\u8d25");
        }
        HashMap map = new HashMap();
        JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)resource.fullFilePath()));
        return JavaConversions$.MODULE$.deprecated$u0020mutableMapAsJavaMap((Map)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"is"), (Object)resource.inputStream())));
    }

    public String downloadToLocalPath(String userName, String resourceId, String version, String path) {
        java.util.Map<String, Object> result = this.download(userName, resourceId, version);
        InputStream is = (InputStream)result.get("is");
        OutputStream os = IoUtils.generateExportOutputStream(path);
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> IOUtils.copy((InputStream)is, (OutputStream)os), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            IOUtils.closeQuietly((OutputStream)os);
            IOUtils.closeQuietly((InputStream)is);
        });
        return path;
    }

    public String downloadAndGetText(String userName, String resourceId, String version, String path) {
        this.downloadToLocalPath(userName, resourceId, version, path);
        InputStream is = IoUtils.generateInputInputStream(path);
        return (String)Utils$.MODULE$.tryFinally((Function0 & Serializable & scala.Serializable)() -> this.inputstremToString(is), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((InputStream)is));
    }

    public InputStream readLocalResourceFile(String userName, String readPath) {
        return IoUtils.generateInputInputStream(readPath);
    }

    public String readLocalTextFile(String userName, String readPath) {
        ObjectRef inputStream = ObjectRef.create(null);
        ObjectRef text = ObjectRef.create(null);
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            inputStream$1.elem = IoUtils.generateInputInputStream(readPath);
            text$1.elem = this.inputstremToString((InputStream)inputStream$1.elem);
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((InputStream)((InputStream)inputStream$1.elem)));
        return (String)text.elem;
    }

    public String readTextFromBML(String userName, String resourceId, String version) {
        java.util.Map<String, Object> result = this.download(userName, resourceId, version);
        InputStream is = (InputStream)result.get("is");
        ObjectRef inputStream = ObjectRef.create(null);
        ObjectRef text = ObjectRef.create(null);
        Utils$.MODULE$.tryFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            inputStream$2.elem = is;
            text$2.elem = this.inputstremToString((InputStream)inputStream$2.elem);
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> IOUtils.closeQuietly((InputStream)((InputStream)inputStream$2.elem)));
        return (String)text.elem;
    }

    private String inputstremToString(InputStream inputStream) {
        return Source$.MODULE$.fromInputStream(inputStream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    public void createBmlProject(String username, String projectName, List<String> editUsers, List<String> accessUsers) {
        BmlClient client = this.getBmlClient(username);
        BmlCreateProjectResponse response = client.createBmlProject(username, projectName, accessUsers, editUsers);
        if (response.isSuccess()) {
            this.logger().info(new StringBuilder(37).append("for user ").append(username).append(" create bml project ").append(projectName).append(" success").toString());
            return;
        }
        this.logger().error(new StringBuilder(36).append("for user ").append(username).append(" create bml project ").append(projectName).append(" failed").toString());
    }

    public void attachResourceAndProject(String username, String projectName, String resourceId) {
        BmlClient client = this.getBmlClient(username);
        BmlAttachResourceAndProjectResponse response = client.attachResourceAndProject(projectName, resourceId);
        if (response.isSuccess()) {
            this.logger().info(new StringBuilder(20).append("attach ").append(username).append(" and ").append(projectName).append(" success").toString());
            return;
        }
        this.logger().error(new StringBuilder(19).append("attach ").append(username).append(" and ").append(projectName).append(" failed").toString());
    }

    public void updateProjectPriv(String projectName, String username, List<String> editUsers, List<String> accessUsers) {
        BmlClient client = this.getBmlClient(username);
        BmlUpdateProjectPrivResponse response = client.updateProjectPriv(username, projectName, editUsers, accessUsers);
        if (response.isSuccess()) {
            this.logger().info(new StringBuilder(20).append("attach ").append(username).append(" and ").append(projectName).append(" success").toString());
            return;
        }
        this.logger().error(new StringBuilder(19).append("attach ").append(username).append(" and ").append(projectName).append(" failed").toString());
    }

    public void deleteBmlResource(String username, String resourceId) {
        BmlClient client = this.getBmlClient(username);
        BmlDeleteResponse response = client.deleteResource(username, resourceId);
        if (response.isSuccess()) {
            this.logger().info(new StringBuilder(48).append("delete ").append(username).append(" bml  resource file success, resourceId: ").append(resourceId).toString());
            return;
        }
        this.logger().error(new StringBuilder(46).append("delete ").append(username).append(" bml resource file failed, resourceId: ").append(resourceId).toString());
    }
}

