/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.common.label;

import com.webank.wedatasphere.dss.common.label.DSSLabel;
import com.webank.wedatasphere.dss.common.label.EnvDSSLabel;
import com.webank.wedatasphere.dss.common.label.LabelBuilder;
import com.webank.wedatasphere.dss.common.label.LabelKeyConvertor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.linkis.manager.label.entity.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelInstanceFactory {
    private static final Logger log = LoggerFactory.getLogger(LabelInstanceFactory.class);
    private Map<String, Label<?>> labels = null;

    public LabelInstanceFactory(Map<String, Object> labelParam) {
        this.labels = this.getLabels(labelParam);
    }

    private Map<String, Label<?>> getLabels(Map<String, Object> originalLabels) {
        Map<String, Object> originalLabelsMap = LabelKeyConvertor.labelKeyConvert(originalLabels);
        return LabelBuilder.buildLabel(originalLabelsMap);
    }

    public Map<String, DSSLabel> getLabelsMap() {
        HashMap<String, DSSLabel> resultLabels = new HashMap<String, DSSLabel>();
        this.labels.entrySet().stream().map(item -> resultLabels.put((String)item.getKey(), (DSSLabel)((Object)((Object)item.getValue()))));
        return resultLabels;
    }

    public List<DSSLabel> getLabelList() {
        ArrayList<DSSLabel> dssLabelList = new ArrayList<DSSLabel>();
        this.labels.entrySet().stream().map(item -> dssLabelList.add((DSSLabel)((Object)((Object)item.getValue()))));
        return dssLabelList;
    }

    public EnvDSSLabel getEnvDssLabel() {
        return (EnvDSSLabel)this.labels.get("DSSEnv");
    }
}

