/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.common.MetricsToTimeseries;
import com.wavefront.common.Pair;
import com.wavefront.integrations.metrics.SocketMetricsProcessor;
import com.wavefront.metrics.MetricTranslator;
import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.SafeVirtualMachineMetrics;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.core.WavefrontHistogram;
import com.yammer.metrics.reporting.AbstractReporter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class WavefrontYammerMetricsReporter
extends AbstractReporter
implements Runnable {
    protected static final Logger logger = Logger.getLogger(WavefrontYammerMetricsReporter.class.getCanonicalName());
    private static final Clock clock = Clock.defaultClock();
    private static final VirtualMachineMetrics vm = SafeVirtualMachineMetrics.getInstance();
    private final boolean includeJvmMetrics;
    private final ScheduledExecutorService executor;
    private final ConcurrentHashMap<String, Double> gaugeMap;
    private final SocketMetricsProcessor socketMetricProcessor;
    private final MetricTranslator metricTranslator;
    private AtomicInteger metricsGeneratedLastPass = new AtomicInteger();

    public WavefrontYammerMetricsReporter(MetricsRegistry metricsRegistry, String name, String hostname, int port, int wavefrontHistogramPort, Supplier<Long> timeSupplier) throws IOException {
        this(metricsRegistry, name, hostname, port, wavefrontHistogramPort, timeSupplier, false, null, false, false);
    }

    public WavefrontYammerMetricsReporter(MetricsRegistry metricsRegistry, String name, String hostname, int port, int wavefrontHistogramPort, Supplier<Long> timeSupplier, boolean prependGroupName, @Nullable MetricTranslator metricTranslator, boolean includeJvmMetrics, boolean clearMetrics) throws IOException {
        this(metricsRegistry, name, hostname, port, wavefrontHistogramPort, timeSupplier, prependGroupName, metricTranslator, includeJvmMetrics, clearMetrics, true, true);
    }

    public WavefrontYammerMetricsReporter(MetricsRegistry metricsRegistry, String name, String hostname, int port, int wavefrontHistogramPort, Supplier<Long> timeSupplier, boolean prependGroupName, @Nullable MetricTranslator metricTranslator, boolean includeJvmMetrics, boolean clearMetrics, boolean sendZeroCounters, boolean sendEmptyHistograms) throws IOException {
        this(metricsRegistry, name, hostname, port, wavefrontHistogramPort, timeSupplier, prependGroupName, metricTranslator, includeJvmMetrics, clearMetrics, sendZeroCounters, sendEmptyHistograms, null);
    }

    public WavefrontYammerMetricsReporter(MetricsRegistry metricsRegistry, String name, String hostname, int port, int wavefrontHistogramPort, Supplier<Long> timeSupplier, boolean prependGroupName, @Nullable MetricTranslator metricTranslator, boolean includeJvmMetrics, boolean clearMetrics, boolean sendZeroCounters, boolean sendEmptyHistograms, @Nullable Long connectionTimeToLiveMillis) throws IOException {
        super(metricsRegistry);
        this.executor = metricsRegistry.newScheduledThreadPool(1, name);
        this.metricTranslator = metricTranslator;
        this.socketMetricProcessor = new SocketMetricsProcessor(hostname, port, wavefrontHistogramPort, timeSupplier, prependGroupName, clearMetrics, sendZeroCounters, sendEmptyHistograms, connectionTimeToLiveMillis);
        this.includeJvmMetrics = includeJvmMetrics;
        this.gaugeMap = new ConcurrentHashMap();
    }

    private void upsertGauges(final String metricName, Double t) {
        this.gaugeMap.put(metricName, t);
        this.getMetricsRegistry().newGauge(new MetricName("", "", MetricsToTimeseries.sanitize((String)metricName)), (Gauge)new Gauge<Double>(){

            public Double value() {
                return (Double)WavefrontYammerMetricsReporter.this.gaugeMap.get(metricName);
            }
        });
    }

    private void upsertGauges(String base, Map<String, Double> metrics) {
        for (Map.Entry<String, Double> entry : metrics.entrySet()) {
            this.upsertGauges(base + "." + entry.getKey(), entry.getValue());
        }
    }

    private void upsertJavaMetrics() {
        this.upsertGauges("jvm.memory", MetricsToTimeseries.memoryMetrics((VirtualMachineMetrics)vm));
        this.upsertGauges("jvm.buffers.direct", MetricsToTimeseries.buffersMetrics((VirtualMachineMetrics.BufferPoolStats)((VirtualMachineMetrics.BufferPoolStats)vm.getBufferPoolStats().get("direct"))));
        this.upsertGauges("jvm.buffers.mapped", MetricsToTimeseries.buffersMetrics((VirtualMachineMetrics.BufferPoolStats)((VirtualMachineMetrics.BufferPoolStats)vm.getBufferPoolStats().get("mapped"))));
        this.upsertGauges("jvm.thread-states", MetricsToTimeseries.threadStateMetrics((VirtualMachineMetrics)vm));
        this.upsertGauges("jvm", MetricsToTimeseries.vmMetrics((VirtualMachineMetrics)vm));
        this.upsertGauges("current_time", Double.valueOf(clock.time()));
        for (Map.Entry entry : vm.garbageCollectors().entrySet()) {
            this.upsertGauges("jvm.garbage-collectors." + (String)entry.getKey(), MetricsToTimeseries.gcMetrics((VirtualMachineMetrics.GarbageCollectorStats)((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue())));
        }
    }

    @VisibleForTesting
    int getMetricsGeneratedLastPass() {
        return this.metricsGeneratedLastPass.get();
    }

    public void start(long period, TimeUnit unit) {
        this.executor.scheduleAtFixedRate(this, period, period, unit);
    }

    public void start(long initialDelay, long period, TimeUnit unit) {
        this.executor.scheduleAtFixedRate(this, initialDelay, period, unit);
    }

    public void shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeout, unit);
    }

    public void shutdown() {
        this.executor.shutdown();
        super.shutdown();
    }

    @Override
    public void run() {
        this.metricsGeneratedLastPass.set(0);
        try {
            if (this.includeJvmMetrics) {
                this.upsertJavaMetrics();
            }
            this.getMetricsRegistry().allMetrics().entrySet().stream().filter(m -> !(m.getValue() instanceof WavefrontHistogram)).forEach(this::processEntry);
            this.getMetricsRegistry().allMetrics().entrySet().stream().filter(m -> m.getValue() instanceof WavefrontHistogram).forEach(this::processEntry);
            this.socketMetricProcessor.flush();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot report point to Wavefront! Trying again next iteration.", e);
        }
    }

    private void processEntry(Map.Entry<MetricName, Metric> entry) {
        try {
            MetricName metricName = entry.getKey();
            Metric metric = entry.getValue();
            if (this.metricTranslator != null) {
                Pair pair = (Pair)this.metricTranslator.apply((Object)Pair.of((Object)metricName, (Object)metric));
                if (pair == null) {
                    return;
                }
                metricName = (MetricName)pair._1;
                metric = (Metric)pair._2;
            }
            metric.processWith((MetricProcessor)this.socketMetricProcessor, metricName, null);
            this.metricsGeneratedLastPass.incrementAndGet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

