/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations.metrics;

import com.google.common.collect.Maps;
import com.tdunning.math.stats.Centroid;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.integrations.metrics.WavefrontMetricsProcessor;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.clients.WavefrontClientFactory;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.WavefrontHistogram;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpMetricsProcessor
extends WavefrontMetricsProcessor {
    private final Logger log = Logger.getLogger(HttpMetricsProcessor.class.getCanonicalName());
    private final Supplier<Long> timeSupplier;
    private final WavefrontSender wavefrontSender;
    private final String defaultSource;

    HttpMetricsProcessor(Builder builder) {
        super(builder.prependGroupName, builder.clear, builder.sendZeroCounters, builder.sendEmptyHistograms);
        this.timeSupplier = builder.timeSupplier;
        this.defaultSource = builder.defaultSource;
        WavefrontClientFactory factory = new WavefrontClientFactory();
        factory.addClient("proxy://" + builder.hostname + ":" + builder.metricsPort, builder.batchSize, builder.queueSize, Integer.valueOf(builder.flushInterval), builder.timeUnit, null, true, builder.sdkInternalTags);
        if (builder.secondaryHostname != null) {
            factory.addClient("proxy://" + builder.secondaryHostname + ":" + builder.secondaryPort, builder.batchSize, builder.queueSize, Integer.valueOf(builder.flushInterval), builder.timeUnit, null, true, builder.sdkInternalTags);
        }
        this.wavefrontSender = factory.getClient();
    }

    @Override
    void writeMetric(MetricName name, String nameSuffix, double value) {
        Map tags = Collections.emptyMap();
        if (name instanceof TaggedMetricName) {
            tags = ((TaggedMetricName)name).getTags();
        }
        try {
            String metricName = this.getName(name);
            if (nameSuffix != null && !nameSuffix.equals("")) {
                metricName = metricName + "." + nameSuffix;
            }
            this.wavefrontSender.sendMetric(metricName, value, Long.valueOf(this.timeSupplier.get() / 1000L), this.defaultSource, tags);
        }
        catch (IOException ex) {
            this.log.log(Level.SEVERE, "Unable to forward point to the wavefront service", ex);
        }
    }

    @Override
    void writeHistogram(MetricName name, WavefrontHistogram histogram, Void context) {
        try {
            List bins;
            Map tags = Collections.emptyMap();
            if (name instanceof TaggedMetricName) {
                tags = ((TaggedMetricName)name).getTags();
            }
            if ((bins = histogram.bins(this.clear)).isEmpty()) {
                return;
            }
            HashSet<HistogramGranularity> granularities = new HashSet<HistogramGranularity>();
            granularities.add(HistogramGranularity.MINUTE);
            for (WavefrontHistogram.MinuteBin bin : bins) {
                ArrayList<Pair> centroids = new ArrayList<Pair>();
                long timestamp = bin.getMinMillis() / 1000L;
                Centroid accumulator = null;
                for (Centroid c : bin.getDist().centroids()) {
                    if (accumulator != null && c.mean() != accumulator.mean()) {
                        centroids.add(new Pair((Object)accumulator.mean(), (Object)accumulator.count()));
                        accumulator = new Centroid(c.mean(), c.count());
                        continue;
                    }
                    if (accumulator == null) {
                        accumulator = new Centroid(c.mean(), c.count());
                        continue;
                    }
                    accumulator.add(c.mean(), c.count());
                }
                if (accumulator != null) {
                    centroids.add(new Pair((Object)accumulator.mean(), (Object)accumulator.count()));
                }
                this.wavefrontSender.sendDistribution(this.getName(name), centroids, granularities, Long.valueOf(timestamp), this.defaultSource, tags);
            }
        }
        catch (IOException ex) {
            this.log.log(Level.SEVERE, "Unable to forward histogram to the wavefront service", ex);
        }
    }

    @Override
    void flush() {
        try {
            this.wavefrontSender.flush();
        }
        catch (IOException ex) {
            this.log.log(Level.SEVERE, "Failed to flush clients", ex);
        }
    }

    public static class Builder {
        private Integer queueSize = null;
        private Integer batchSize = null;
        private boolean prependGroupName = false;
        private boolean clear = false;
        private boolean sendZeroCounters = true;
        private boolean sendEmptyHistograms = true;
        private String defaultSource;
        private String hostname;
        private int metricsPort = 2878;
        private String secondaryHostname;
        private int secondaryPort = 2878;
        private Supplier<Long> timeSupplier = System::currentTimeMillis;
        private Map<String, String> sdkInternalTags = Maps.newConcurrentMap();
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private int flushInterval = 1;

        public Builder withEndpoint(String hostname, int port) {
            this.hostname = hostname;
            this.metricsPort = port;
            return this;
        }

        public Builder withSecondaryEndpoint(String hostname, int port) {
            this.secondaryHostname = hostname;
            this.secondaryPort = port;
            return this;
        }

        public Builder withDefaultSource(String defaultSource) {
            this.defaultSource = defaultSource;
            return this;
        }

        public Builder withQueueOptions(int batchSize, int queueSize) {
            this.batchSize = batchSize;
            this.queueSize = queueSize;
            return this;
        }

        public Builder withPrependedGroupNames(boolean prependGroupName) {
            this.prependGroupName = prependGroupName;
            return this;
        }

        public Builder clearHistogramsAndTimers(boolean clear) {
            this.clear = clear;
            return this;
        }

        public Builder sendZeroCounters(boolean send) {
            this.sendZeroCounters = send;
            return this;
        }

        public Builder sendEmptyHistograms(boolean send) {
            this.sendEmptyHistograms = send;
            return this;
        }

        public Builder withTimeSupplier(Supplier<Long> timeSupplier) {
            this.timeSupplier = timeSupplier;
            return this;
        }

        public Builder withSdkInternalTags(Map<String, String> tags) {
            this.sdkInternalTags.putAll(tags);
            return this;
        }

        public Builder withFlushInterval(TimeUnit timeUnit, int flushInterval) {
            this.timeUnit = timeUnit;
            this.flushInterval = flushInterval;
            return this;
        }

        public HttpMetricsProcessor build() {
            if (this.batchSize != null && this.queueSize != null && this.batchSize > this.queueSize) {
                throw new IllegalArgumentException("Batch size cannot be larger than queue sizes");
            }
            return new HttpMetricsProcessor(this);
        }
    }
}

