/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.appagent.jvm.reporter;

import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.common.application.HeartbeaterService;
import com.wavefront.sdk.entities.metrics.WavefrontMetricSender;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class WavefrontJvmReporter {
    private final WavefrontInternalReporter wfReporter;
    private final int reportingIntervalSeconds;
    private final HeartbeaterService heartbeaterService;

    private WavefrontJvmReporter(WavefrontInternalReporter wfReporter, int reportingIntervalSeconds, WavefrontMetricSender wavefrontMetricSender, ApplicationTags applicationTags, String source) {
        this.wfReporter = wfReporter;
        this.reportingIntervalSeconds = reportingIntervalSeconds;
        this.heartbeaterService = new HeartbeaterService(wavefrontMetricSender, applicationTags, Collections.singletonList("jvm"), source);
    }

    public void start() {
        this.wfReporter.start((long)this.reportingIntervalSeconds, TimeUnit.SECONDS);
    }

    public void stop() {
        this.wfReporter.stop();
        this.heartbeaterService.close();
    }

    public static class Builder {
        private final ApplicationTags applicationTags;
        private final String prefix = "app-agent";
        private int reportingIntervalSeconds = 60;
        @Nullable
        private String source;

        public Builder(ApplicationTags applicationTags) {
            this.applicationTags = applicationTags;
        }

        public Builder reportingIntervalSeconds(int reportingIntervalSeconds) {
            this.reportingIntervalSeconds = reportingIntervalSeconds;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        public WavefrontJvmReporter build(WavefrontSender wavefrontSender) {
            if (this.source == null) {
                try {
                    this.source = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    this.source = "unknown";
                }
            }
            HashMap<String, String> pointTags = new HashMap<String, String>();
            pointTags.put("application", this.applicationTags.getApplication());
            pointTags.put("service", this.applicationTags.getService());
            pointTags.put("cluster", this.applicationTags.getCluster() == null ? "none" : this.applicationTags.getCluster());
            pointTags.put("shard", this.applicationTags.getShard() == null ? "none" : this.applicationTags.getShard());
            if (this.applicationTags.getCustomTags() != null) {
                pointTags.putAll(this.applicationTags.getCustomTags());
            }
            WavefrontInternalReporter wfReporter = new WavefrontInternalReporter.Builder().prefixedWith("app-agent").withSource(this.source).withReporterPointTags(pointTags).includeJvmMetrics().build(wavefrontSender);
            return new WavefrontJvmReporter(wfReporter, this.reportingIntervalSeconds, (WavefrontMetricSender)wavefrontSender, this.applicationTags, this.source);
        }
    }
}

