/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.ext.toc.TocBlock;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TocBlockParser
extends AbstractBlockParser {
    private final TocBlock block;
    private final TocOptions options;

    private TocBlockParser(DataHolder options, BasedSequence tocChars, BasedSequence styleChars) {
        this.options = new TocOptions(options, false);
        this.block = new TocBlock(tocChars, styleChars);
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        return BlockContinue.none();
    }

    public void addLine(ParserState state, BasedSequence line) {
    }

    public void closeBlock(ParserState state) {
    }

    public void parseInlines(InlineParser inlineParser) {
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final TocOptions options;
        private final TocParsing myParsing;

        private BlockFactory(DataHolder options) {
            super(options);
            this.options = new TocOptions(options, false);
            this.myParsing = new TocParsing(options);
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            BasedSequence line = state.getLine();
            int nextNonSpace = state.getNextNonSpaceIndex();
            BasedSequence trySequence = line.subSequence(nextNonSpace, line.length());
            Matcher matcher = this.myParsing.TOC_BLOCK_START.matcher((CharSequence)line);
            if (matcher.matches()) {
                BasedSequence tocChars = state.getLineWithEOL();
                BasedSequence styleChars = null;
                Object titleChars = null;
                if (matcher.start(1) != -1) {
                    int styleStart = matcher.start(1);
                    int styleEnd = matcher.end(1);
                    styleChars = trySequence.subSequence(styleStart, styleEnd);
                }
                TocBlockParser tocBlockParser = new TocBlockParser((DataHolder)state.getProperties(), tocChars, styleChars);
                return BlockStart.of((BlockParser[])new BlockParser[]{tocBlockParser}).atIndex(state.getIndex());
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }

    static class TocParsing
    extends Parsing {
        final Pattern TOC_BLOCK_START;

        public TocParsing(DataHolder options) {
            super(options);
            this.TOC_BLOCK_START = (Boolean)TocExtension.CASE_SENSITIVE_TOC_TAG.getFrom(options) != false ? Pattern.compile("^\\[TOC(?:\\s+([^\\]]+))?]\\s*$") : Pattern.compile("^\\[(?i:TOC)(?:\\s+([^\\]]+))?]\\s*$");
        }
    }
}

