/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.ComponentDataGenerator;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public class ComponentRenderer<COMPONENT extends Component, SOURCE>
extends Renderer<SOURCE> {
    private SerializableSupplier<COMPONENT> componentSupplier;
    private SerializableFunction<SOURCE, COMPONENT> componentFunction;
    private SerializableBiFunction<Component, SOURCE, Component> componentUpdateFunction;
    private SerializableBiConsumer<COMPONENT, SOURCE> itemConsumer;
    private String componentRendererTag = "flow-component-renderer";

    public ComponentRenderer(SerializableSupplier<COMPONENT> componentSupplier, SerializableBiConsumer<COMPONENT, SOURCE> itemConsumer) {
        this.componentSupplier = componentSupplier;
        this.itemConsumer = itemConsumer;
    }

    public ComponentRenderer(SerializableSupplier<COMPONENT> componentSupplier) {
        this(componentSupplier, null);
    }

    public ComponentRenderer(SerializableFunction<SOURCE, COMPONENT> componentFunction) {
        this(componentFunction, null);
    }

    public ComponentRenderer(SerializableFunction<SOURCE, COMPONENT> componentFunction, SerializableBiFunction<Component, SOURCE, Component> componentUpdateFunction) {
        this.componentFunction = componentFunction;
        this.componentUpdateFunction = componentUpdateFunction;
    }

    protected ComponentRenderer() {
    }

    @Override
    public Rendering<SOURCE> render(Element container, DataKeyMapper<SOURCE> keyMapper, Element contentTemplate) {
        ComponentRendering rendering = new ComponentRendering(keyMapper == null ? null : arg_0 -> keyMapper.key(arg_0));
        rendering.setTemplateElement(contentTemplate);
        container.getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> this.setupTemplateWhenAttached((UI)ui, container, rendering, keyMapper));
        return rendering;
    }

    public void setComponentRendererTag(String componentRendererTag) {
        Objects.requireNonNull(componentRendererTag, "The componentRendererTag should not be null");
        this.componentRendererTag = componentRendererTag;
    }

    private void setupTemplateWhenAttached(UI ui, Element owner, ComponentRendering rendering, DataKeyMapper<SOURCE> keyMapper) {
        String templateInnerHtml;
        String appId = ui.getInternals().getAppId();
        Element templateElement = rendering.getTemplateElement();
        owner.appendChild(new Element[]{templateElement});
        Element container = new Element("div");
        owner.appendVirtualChild(new Element[]{container});
        rendering.setContainer(container);
        if (keyMapper != null) {
            String nodeIdPropertyName = "_renderer_" + templateElement.getNode().getId();
            templateInnerHtml = String.format("<%s appid=\"%s\" nodeid=\"[[item.%s]]\"></%s>", this.componentRendererTag, appId, nodeIdPropertyName, this.componentRendererTag);
            rendering.setNodeIdPropertyName(nodeIdPropertyName);
        } else {
            COMPONENT component = this.createComponent(null);
            if (component != null) {
                container.appendChild(new Element[]{component.getElement()});
                templateInnerHtml = String.format("<%s appid=\"%s\" nodeid=\"%s\"></%s>", this.componentRendererTag, appId, component.getElement().getNode().getId(), this.componentRendererTag);
            } else {
                templateInnerHtml = "";
            }
        }
        templateElement.setProperty("innerHTML", templateInnerHtml);
    }

    public COMPONENT createComponent(SOURCE item) {
        if (this.componentFunction != null) {
            return (COMPONENT)((Component)this.componentFunction.apply(item));
        }
        Component component = (Component)this.componentSupplier.get();
        if (this.itemConsumer != null) {
            this.itemConsumer.accept((Object)component, item);
        }
        return (COMPONENT)component;
    }

    public Component updateComponent(Component currentComponent, SOURCE item) {
        if (this.componentUpdateFunction != null) {
            return (Component)this.componentUpdateFunction.apply((Object)currentComponent, item);
        }
        return this.createComponent(item);
    }

    private class ComponentRendering
    extends ComponentDataGenerator<SOURCE>
    implements Rendering<SOURCE> {
        private Element templateElement;

        public ComponentRendering(ValueProvider<SOURCE, String> keyMapper) {
            super(ComponentRenderer.this, keyMapper);
        }

        public void setTemplateElement(Element templateElement) {
            this.templateElement = templateElement;
        }

        @Override
        public Element getTemplateElement() {
            return this.templateElement;
        }

        @Override
        public Optional<DataGenerator<SOURCE>> getDataGenerator() {
            return Optional.of(this);
        }
    }
}

