/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.listbox;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.listbox.VaadinItem;
import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.binder.HasItemsAndComponents;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Tag(value="vaadin-list-box")
@NpmPackage(value="@vaadin/vaadin-list-box", version="1.2.0")
@JsModule(value="@vaadin/vaadin-list-box/src/vaadin-list-box.js")
public abstract class ListBoxBase<C extends ListBoxBase<C, ITEM, VALUE>, ITEM, VALUE>
extends AbstractSinglePropertyField<C, VALUE>
implements HasItemsAndComponents<ITEM>,
HasDataProvider<ITEM>,
HasSize {
    private DataProvider<ITEM, ?> dataProvider = DataProvider.ofItems((Object[])new Object[0]);
    private List<ITEM> items;
    private ComponentRenderer<? extends Component, ITEM> itemRenderer = new TextRenderer();
    private SerializablePredicate<ITEM> itemEnabledProvider = (SerializablePredicate & Serializable)item -> this.isEnabled();

    <P> ListBoxBase(String propertyName, Class<P> elementPropertyType, VALUE defaultValue, SerializableBiFunction<C, P, VALUE> presentationToModel, SerializableBiFunction<C, VALUE, P> modelToPresentation) {
        super(propertyName, defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
    }

    public void setDataProvider(DataProvider<ITEM, ?> dataProvider) {
        this.dataProvider = Objects.requireNonNull(dataProvider);
        dataProvider.addDataProviderListener((DataProviderListener & Serializable)event -> {
            if (event instanceof DataChangeEvent.DataRefreshEvent) {
                this.refresh(((DataChangeEvent.DataRefreshEvent)event).getItem());
            } else {
                this.rebuild();
            }
        });
        this.rebuild();
    }

    public DataProvider<ITEM, ?> getDataProvider() {
        return this.dataProvider;
    }

    public ComponentRenderer<? extends Component, ITEM> getItemRenderer() {
        return this.itemRenderer;
    }

    public void setRenderer(ComponentRenderer<? extends Component, ITEM> itemRenderer) {
        this.itemRenderer = Objects.requireNonNull(itemRenderer);
        this.getItemComponents().forEach(this::refreshContent);
    }

    public void setItemEnabledProvider(SerializablePredicate<ITEM> itemEnabledProvider) {
        this.itemEnabledProvider = Objects.requireNonNull(itemEnabledProvider);
        this.getItemComponents().forEach(this::refreshEnabled);
    }

    public SerializablePredicate<ITEM> getItemEnabledProvider() {
        return this.itemEnabledProvider;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        throw new UnsupportedOperationException("Not supported by the client-side web-component: https://github.com/vaadin/vaadin-list-box/issues/19");
    }

    private void rebuild() {
        this.clear();
        this.removeAll();
        this.items = this.getDataProvider().fetch(new Query()).collect(Collectors.toList());
        this.items.stream().map(this::createItemComponent).forEach(xva$0 -> this.add(new Component[]{xva$0}));
    }

    private VaadinItem<ITEM> createItemComponent(ITEM item) {
        VaadinItem<ITEM> itemComponent = new VaadinItem<ITEM>(item);
        this.refresh(itemComponent);
        return itemComponent;
    }

    private void refresh(ITEM item) {
        VaadinItem itemComponent = this.getItemComponents().stream().filter(component -> component.getItem().equals(item)).findFirst().get();
        this.refresh(itemComponent);
    }

    private void refresh(VaadinItem<ITEM> itemComponent) {
        this.refreshContent(itemComponent);
        this.refreshEnabled(itemComponent);
    }

    private void refreshContent(VaadinItem<ITEM> itemComponent) {
        itemComponent.removeAll();
        itemComponent.add(new Component[]{this.itemRenderer.createComponent(itemComponent.getItem())});
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.getItemComponents().forEach(this::refreshEnabled);
    }

    private void refreshEnabled(VaadinItem<ITEM> itemComponent) {
        itemComponent.setEnabled(this.itemEnabledProvider.test(itemComponent.getItem()));
    }

    List<ITEM> getItems() {
        return this.items;
    }

    List<VaadinItem<ITEM>> getItemComponents() {
        return this.getChildren().filter(VaadinItem.class::isInstance).map(component -> (VaadinItem)((Object)component)).collect(Collectors.toList());
    }
}

