/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.viteproxy;

import jakarta.websocket.CloseReason;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViteWebsocketConnection
implements WebSocket.Listener {
    private final Consumer<String> onMessage;
    private final WebSocket clientWebSocket;
    private final Runnable onClose;
    private List<CharSequence> parts = new ArrayList<CharSequence>();

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    public ViteWebsocketConnection(int port, String path, String subProtocol, Consumer<String> onMessage, Runnable onClose) throws InterruptedException, ExecutionException {
        this.onMessage = onMessage;
        this.onClose = onClose;
        String wsHost = "http://127.0.0.1".replace("http://", "ws://");
        URI uri = URI.create(wsHost + ":" + port + path);
        this.clientWebSocket = HttpClient.newHttpClient().newWebSocketBuilder().subprotocols(subProtocol, new String[0]).buildAsync(uri, this).get();
        this.getLogger().debug("Connecting to {} using the {} protocol", (Object)uri, (Object)this.clientWebSocket.getSubprotocol());
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        this.getLogger().debug("Connected using the {} protocol", (Object)webSocket.getSubprotocol());
        WebSocket.Listener.super.onOpen(webSocket);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        this.onClose.run();
        return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        if (!last) {
            this.getLogger().debug("Partial message from Vite: {}", (Object)data);
            this.parts.add(data);
        } else {
            Object msg = "";
            while (!this.parts.isEmpty()) {
                msg = (String)msg + this.parts.remove(0);
            }
            msg = (String)msg + data;
            this.getLogger().debug("Message from Vite: {}", msg);
            this.onMessage.accept((String)msg);
        }
        return WebSocket.Listener.super.onText(webSocket, data, last);
    }

    public void send(String message) throws InterruptedException, ExecutionException {
        CompletableFuture<WebSocket> send = this.clientWebSocket.sendText(message, false);
        send.get();
    }

    public void close() throws InterruptedException, ExecutionException {
        this.getLogger().debug("Closing the connection");
        CompletableFuture<WebSocket> closeRequest = this.clientWebSocket.sendClose(CloseReason.CloseCodes.NORMAL_CLOSURE.getCode(), "");
        closeRequest.get();
    }
}

