/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.themeeditor.handlers;

import com.vaadin.base.devserver.themeeditor.messages.HistoryRequest;
import com.vaadin.base.devserver.themeeditor.utils.MessageHandler;
import com.vaadin.base.devserver.themeeditor.utils.MessageHandlerCommand;
import com.vaadin.base.devserver.themeeditor.utils.ThemeEditorException;
import com.vaadin.base.devserver.themeeditor.utils.ThemeEditorHistory;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonObject;
import java.util.Optional;

public class HistoryHandler
implements MessageHandler {
    @Override
    public MessageHandler.ExecuteAndUndo handle(JsonObject data) {
        HistoryRequest request = (HistoryRequest)JsonUtils.readToObject((JsonObject)data, HistoryRequest.class);
        ThemeEditorHistory history = ThemeEditorHistory.forUi(request.getUiId());
        if (request.getRedo() != null) {
            if (history.containsKey(request.getRedo())) {
                MessageHandlerCommand executeCommand = history.getExecuteCommand(request.getRedo());
                return new MessageHandler.ExecuteAndUndo(() -> executeCommand.execute(), Optional.empty());
            }
            throw new ThemeEditorException("Given redo operation does not exist.");
        }
        if (request.getUndo() != null) {
            if (history.containsKey(request.getUndo())) {
                Optional<MessageHandlerCommand> undoCommand = history.getUndoCommand(request.getUndo());
                return new MessageHandler.ExecuteAndUndo(() -> ((MessageHandlerCommand)undoCommand.get()).execute(), Optional.empty());
            }
            throw new ThemeEditorException("Given undo operation does not exist.");
        }
        throw new ThemeEditorException("At least one of undo or redo must be specified.");
    }

    @Override
    public String getCommandName() {
        return "themeEditorHistory";
    }
}

