/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.pool;

import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.pool.UnboundedApachePoolableProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedApachePoolableProvider
extends UnboundedApachePoolableProvider {
    private final Logger logger = LoggerFactory.getLogger(BoundedApachePoolableProvider.class);
    private long waitFor = 10000L;

    @Override
    protected void configureGenericObjectPoolConfig() {
        this.poolConfig.setMaxTotal(this.config.getInitParameter("org.atmosphere.pool.BoundedApachePoolableProvider.size", 200));
        this.waitFor = TimeUnit.SECONDS.toMillis(this.config.getInitParameter("org.atmosphere.pool.BoundedApachePoolableProvider.waitingTime", 10000));
    }

    @Override
    public Broadcaster borrowBroadcaster(Object id) {
        try {
            return ((DefaultBroadcaster)this.genericObjectPool.borrowObject(this.waitFor)).rename(id.toString());
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

