/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.protocol;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;

public class SimpleHttpProtocol
implements WebSocketProtocol,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(SimpleHttpProtocol.class);
    private String contentType = "text/plain";
    private String methodType = "POST";
    private String delimiter = "@@";
    private boolean destroyable;

    @Override
    public void configure(AtmosphereConfig config) {
        String contentType = config.getInitParameter("org.atmosphere.websocket.messageContentType");
        if (contentType == null) {
            contentType = "text/plain";
        }
        this.contentType = contentType;
        String methodType = config.getInitParameter("org.atmosphere.websocket.messageMethod");
        if (methodType == null) {
            methodType = "POST";
        }
        this.methodType = methodType;
        String delimiter = config.getInitParameter("org.atmosphere.websocket.pathDelimiter");
        if (delimiter == null) {
            delimiter = "@@";
        }
        this.delimiter = delimiter;
        String s = config.getInitParameter(ApplicationConfig.RECYCLE_ATMOSPHERE_REQUEST_RESPONSE);
        this.destroyable = s != null && Boolean.valueOf(s) != false;
    }

    @Override
    public List<AtmosphereRequest> onMessage(WebSocket webSocket, String d) {
        int delimiterLength;
        int bodyBeginIndex;
        AtmosphereResourceImpl resource = (AtmosphereResourceImpl)webSocket.resource();
        if (resource == null) {
            logger.trace("The WebSocket has been closed before the message was processed.");
            return null;
        }
        String pathInfo = resource.getRequest().getPathInfo();
        if (d.startsWith(this.delimiter) && (bodyBeginIndex = d.indexOf(this.delimiter, delimiterLength = this.delimiter.length())) != -1) {
            pathInfo = d.substring(delimiterLength, bodyBeginIndex);
            d = d.substring(bodyBeginIndex + delimiterLength);
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("websocket-subprotocol", "polling-websocket-message");
        m.putAll(resource.getRequest().attributes());
        ArrayList<AtmosphereRequest> list = new ArrayList<AtmosphereRequest>();
        list.add(new AtmosphereRequest.Builder().request((HttpServletRequest)resource.getRequest()).method(this.methodType).contentType(this.contentType).body(d).attributes(m).pathInfo(pathInfo).destroyable(this.destroyable).headers(resource.getRequest().headersMap()).session(resource.session()).build());
        return list;
    }

    @Override
    public List<AtmosphereRequest> onMessage(WebSocket webSocket, byte[] d, int offset, int length) {
        return this.onMessage(webSocket, new String(d, offset, length));
    }

    @Override
    public void onOpen(WebSocket webSocket) {
    }

    @Override
    public void onClose(WebSocket webSocket) {
    }

    @Override
    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException t) {
        logger.warn(t.getMessage() + " Status {} Message {}", (Object)t.response().getStatus(), (Object)t.response().getStatusMessage());
    }
}

