/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;

public final class SessionTimeoutRestorer
implements Serializable,
HttpSessionActivationListener {
    private static final Logger logger = LoggerFactory.getLogger(SessionTimeoutRestorer.class);
    private static final long serialVersionUID = -126253550299206646L;
    private final int timeout;
    private final AtomicInteger requestCount = new AtomicInteger(0);

    public SessionTimeoutRestorer(int timeout) {
        this.timeout = timeout;
    }

    public void setup(HttpSession session) {
        int oldCount = this.requestCount.getAndIncrement();
        logger.trace("requestCount => {}", (Object)this.requestCount);
        if (oldCount == 0) {
            this.refreshTimeout(session);
        }
    }

    public void restore(HttpSession session) {
        int count = this.requestCount.decrementAndGet();
        logger.trace("requestCount <= {}", (Object)this.requestCount);
        if (count == 0) {
            this.refreshTimeout(session);
        }
    }

    private synchronized void refreshTimeout(HttpSession session) {
        if (this.requestCount.get() > 0) {
            session.setMaxInactiveInterval(-1);
        } else {
            session.setMaxInactiveInterval(this.timeout);
        }
    }

    public void sessionWillPassivate(HttpSessionEvent hse) {
        this.requestCount.set(0);
        this.refreshTimeout(hse.getSession());
    }

    public void sessionDidActivate(HttpSessionEvent hse) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionTimeoutRestorer[timeout=");
        sb.append(this.timeout);
        sb.append(", requestCount=");
        sb.append(this.requestCount.get());
        sb.append(']');
        return sb.toString();
    }
}

