/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.client;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncIOInterceptor;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketResponseFilter;

public class TrackMessageSizeInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TrackMessageSizeInterceptor.class);
    private static final byte[] END = "|".getBytes();
    private byte[] end = END;
    private String endString = "|";

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(ApplicationConfig.MESSAGE_DELIMITER);
        if (s != null) {
            this.end = s.getBytes();
            this.endString = s;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Action inspect(AtmosphereResource r) {
        final AtmosphereResponse response = r.getResponse();
        if (r.transport() != AtmosphereResource.TRANSPORT.WEBSOCKET) {
            super.inspect(r);
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (!AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) throw new IllegalStateException("AsyncIOWriter must be an instance of " + AsyncIOWriter.class.getName());
            ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptor(){

                @Override
                public void prePayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                }

                @Override
                public byte[] transformPayload(byte[] responseDraft, byte[] data) throws IOException {
                    String s = new String(responseDraft, response.getCharacterEncoding());
                    if (s.trim().length() != 0) {
                        s = s.length() + TrackMessageSizeInterceptor.this.endString + s;
                        return s.getBytes(response.getCharacterEncoding());
                    }
                    return responseDraft;
                }

                @Override
                public void postPayload(AtmosphereResponse response2, byte[] data, int offset, int length) {
                }
            });
            return Action.CONTINUE;
        } else {
            ((WebSocket)response.getAsyncIOWriter()).webSocketResponseFilter(new WebSocketResponseFilter(){

                @Override
                public String filter(AtmosphereResponse r, String message) {
                    return message.length() + TrackMessageSizeInterceptor.this.endString + message;
                }

                @Override
                public byte[] filter(AtmosphereResponse r, byte[] message) {
                    String s = null;
                    try {
                        s = new String(message, r.getCharacterEncoding());
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.trace("", (Throwable)e);
                    }
                    s = s.length() + TrackMessageSizeInterceptor.this.endString + s;
                    try {
                        return s.getBytes(response.getCharacterEncoding());
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.trace("", (Throwable)e);
                        return message;
                    }
                }

                @Override
                public byte[] filter(AtmosphereResponse r, byte[] message, int offset, int length) {
                    String s = null;
                    try {
                        s = new String(message, offset, length, r.getCharacterEncoding());
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.trace("", (Throwable)e);
                    }
                    s = s.length() + TrackMessageSizeInterceptor.this.endString + s;
                    try {
                        return s.getBytes(response.getCharacterEncoding());
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.trace("", (Throwable)e);
                        return message;
                    }
                }
            });
        }
        return Action.CONTINUE;
    }

    public String toString() {
        return " Track Message Size Interceptor using " + this.endString;
    }
}

