/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import javax.servlet.http.HttpSession;
import org.atmosphere.cache.AbstractBroadcasterCache;
import org.atmosphere.cpr.AtmosphereResource;

public class SessionBroadcasterCache
extends AbstractBroadcasterCache {
    private static final Logger logger = LoggerFactory.getLogger(SessionBroadcasterCache.class);
    private static final String ERROR_MESSAGE = "Session was null. The request has been recycled by the underlying container";

    @Override
    public void cache(String id, AtmosphereResource r, AbstractBroadcasterCache.CachedMessage cm) {
        if (r != null) {
            try {
                HttpSession session = r.session();
                if (session == null) {
                    logger.error(ERROR_MESSAGE);
                    return;
                }
                session.setAttribute(id, (Object)cm);
            }
            catch (IllegalStateException ex) {
                logger.trace("", (Throwable)ex);
                logger.warn("The Session has been invalidated. Message will be loat.");
            }
        }
    }

    @Override
    public AbstractBroadcasterCache.CachedMessage retrieveLastMessage(String id, AtmosphereResource r) {
        try {
            HttpSession session = r.session();
            if (session == null) {
                logger.error(ERROR_MESSAGE);
                return null;
            }
            return (AbstractBroadcasterCache.CachedMessage)session.getAttribute(id);
        }
        catch (IllegalStateException ex) {
            logger.trace("", (Throwable)ex);
            logger.warn("The Session has been invalidated. Unable to retrieve cached messages");
            return null;
        }
    }
}

