/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.pa.config;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.efs.sdk.base.newsharedpreferences.SharedPreferencesUtils;
import com.efs.sdk.base.observer.IConfigCallback;
import com.efs.sdk.pa.config.IEfsReporter;
import com.efs.sdk.pa.config.PackageLevel;
import java.util.Map;
import java.util.Random;

public class ConfigManager {
    private static final String STATS_ANR_LOG_COUNT = "apm_anr_count";
    private static final int MAX_ANR_STATS_COUNT = 50;
    private final String TAG = "WpkPaConfig";
    public static final String PA_LEVEL = "pa_level";
    private final String APM_PATRACE_SWITCH_RATE_LAST = "apm_patrace_switch_rate_last";
    private final String APM_PATRACE_SWITCH_RATE_CURRENT = "apm_patrace_switch_rate";
    private final int DEF_CLOSE_RATE = 0;
    private static final int MAX_ANR_TRACE_RATE = 100;
    private PackageLevel mPackageLevel;
    private static final String MODEL_SP = "paconfig";
    private SharedPreferences mSharedPreferences;
    private IEfsReporter mEfsReporter;
    private int mCurrentRate;
    private int mLastRate;
    public static final String FLAG_PA_FORE_CHECK_TIME = "03f870871950c148387b251894ed3e88";
    public static final String FLAG_PA_CHECK_IN_STATE = "8f2f54c08600aa25915617fa1371441b";
    private static final int A_DAY = 86400000;
    private boolean mCheckIn = false;

    public ConfigManager(Context context, PackageLevel packageLevel, IEfsReporter iEfsReporter, boolean bl) {
        boolean bl2;
        ConfigManager configManager;
        this.mPackageLevel = packageLevel;
        this.mEfsReporter = iEfsReporter;
        this.mSharedPreferences = SharedPreferencesUtils.getSharedPreferences((Context)context, (String)MODEL_SP);
        this.initRate();
        if (bl) {
            this.resetUploadSmoothLogCnt();
            ConfigManager configManager2 = this;
            configManager = configManager2;
            bl2 = configManager2.enableAnrTracer();
        } else {
            ConfigManager configManager3 = this;
            configManager = configManager3;
            bl2 = configManager3.isCountEnable() && this.enableAnrTracer();
        }
        configManager.mCheckIn = bl2;
        this.resetRate();
    }

    private boolean isCountEnable() {
        return this.mSharedPreferences.getLong(STATS_ANR_LOG_COUNT, 0L) <= 50L;
    }

    private void resetUploadSmoothLogCnt() {
        this.putLongValue(STATS_ANR_LOG_COUNT, 0L);
    }

    public void increaseUploadSmoothLogCnt() {
        this.putLongValue(STATS_ANR_LOG_COUNT, this.mSharedPreferences.getLong(STATS_ANR_LOG_COUNT, 0L) + 1L);
    }

    public boolean enableTracer() {
        return this.mCheckIn;
    }

    private void initRate() {
        this.mLastRate = this.mSharedPreferences.getInt("apm_patrace_switch_rate_last", 0);
        int n = this.getCurrentConfigRate();
        if (n == -1) {
            if (this.mPackageLevel == PackageLevel.TRIAL) {
                this.mCurrentRate = 100;
                return;
            }
            this.mCurrentRate = 0;
            return;
        }
        this.mCurrentRate = n;
    }

    private int getCurrentConfigRate() {
        int n = this.mSharedPreferences.getInt("apm_patrace_switch_rate", -1);
        this.mEfsReporter.getReporter().getAllSdkConfig(new String[]{"apm_patrace_switch_rate"}, new IConfigCallback(){

            public final void onChange(Map<String, Object> object) {
                if ((object = object.get("apm_patrace_switch_rate")) != null) {
                    try {
                        ConfigManager.this.putIntValue("apm_patrace_switch_rate", Integer.parseInt(object.toString()));
                        return;
                    }
                    catch (Throwable throwable) {}
                }
            }
        });
        return n;
    }

    private void resetRate() {
        this.putIntValue("apm_patrace_switch_rate_last", this.mCurrentRate);
    }

    private boolean enableAnrTracer() {
        long l = this.mSharedPreferences.getLong(FLAG_PA_FORE_CHECK_TIME, 0L);
        boolean bl = this.mSharedPreferences.getBoolean(FLAG_PA_CHECK_IN_STATE, false);
        if (this.mCurrentRate == 0) {
            if (bl) {
                this.putBooleanValue(FLAG_PA_CHECK_IN_STATE, false);
            }
            if (l != 0L) {
                this.putLongValue(FLAG_PA_FORE_CHECK_TIME, 0L);
            }
            return false;
        }
        ConfigManager configManager = this;
        return configManager.checkIn(configManager.mCurrentRate != this.mLastRate, l, bl, this.mCurrentRate);
    }

    private void putLongValue(String string, long l) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putLong(string, l);
        editor.apply();
    }

    private void putIntValue(String string, int n) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putInt(string, n);
        editor.apply();
    }

    private void putBooleanValue(String string, boolean bl) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putBoolean(string, bl);
        editor.apply();
    }

    private boolean checkIn(boolean bl, Long l, boolean bl2, int n) {
        boolean bl3 = false;
        Long l2 = System.currentTimeMillis();
        l = l2 - l;
        if (bl2 && l < 86400000L && !bl) {
            Log.d((String)"WpkPaConfig", (String)" check in allready");
            return true;
        }
        if (l >= 86400000L || bl) {
            if (this.random(n)) {
                Log.d((String)"WpkPaConfig", (String)"random check in");
                bl3 = true;
            } else {
                Log.d((String)"WpkPaConfig", (String)"random not check in!");
                bl3 = false;
            }
            this.putBooleanValue(FLAG_PA_CHECK_IN_STATE, bl3);
            this.putLongValue(FLAG_PA_FORE_CHECK_TIME, l2);
        } else {
            Log.d((String)"WpkPaConfig", (String)"un repeat check in 24 hour!");
        }
        return bl3;
    }

    private boolean random(int n) {
        if (n == 0) {
            return false;
        }
        if (n == 100) {
            return true;
        }
        return new Random().nextInt(100) <= n;
    }
}

