/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.base.protocol.file;

import android.text.TextUtils;
import com.efs.sdk.base.core.config.a;
import com.efs.sdk.base.core.controller.ControllerCenter;
import com.efs.sdk.base.core.util.Log;
import com.efs.sdk.base.protocol.file.AbsFileLog;
import com.efs.sdk.base.protocol.file.section.AbsSection;
import com.efs.sdk.base.protocol.file.section.JSONSection;
import com.efs.sdk.base.protocol.file.section.KVSection;
import com.efs.sdk.base.protocol.file.section.TextSection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EfsTextFile
extends AbsFileLog {
    private static final String FILE_START = "*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***";
    private static final String SECTION_START = "--- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---";
    private List<AbsSection> sectionList = new ArrayList<AbsSection>();
    private String mLinkKey = null;
    private String mLinkID = null;
    private boolean mHasInitLinkInfo = false;

    public EfsTextFile(String string) {
        super(string);
    }

    private String changeToStr() {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(FILE_START);
        stringBuilder.append("\n");
        for (AbsSection absSection : this.sectionList) {
            if (n > 0) {
                stringBuilder.append("--- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---\n");
            }
            stringBuilder.append(absSection.changeToStr());
            ++n;
        }
        return stringBuilder.toString();
    }

    public KVSection createAndAddKVSection(String object) {
        object = new KVSection((String)object);
        this.sectionList.add((AbsSection)object);
        return object;
    }

    public TextSection createAndAddTextSection(String object) {
        object = new TextSection((String)object);
        this.sectionList.add((AbsSection)object);
        return object;
    }

    public JSONSection createAndAddJSONSection(String object) {
        object = new JSONSection((String)object);
        this.sectionList.add((AbsSection)object);
        return object;
    }

    @Override
    public void insertGlobal(a a2) {
        this.insertCustomInfoSection();
        this.sectionList.addAll(0, a2.a(this.getLogType()));
    }

    private void insertCustomInfoSection() {
        KVSection kVSection = new KVSection("custom_info");
        for (Map.Entry<String, String> entry : ControllerCenter.getGlobalEnvStruct().getPublicParamMap().entrySet()) {
            kVSection.put(entry.getKey(), entry.getValue());
        }
        this.sectionList.add(0, kVSection);
    }

    @Override
    public byte[] generate() {
        String string = this.changeToStr();
        if (ControllerCenter.getGlobalEnvStruct().isPrintLogDetail()) {
            Log.i("efs.base", string);
        }
        return string.getBytes();
    }

    @Override
    public String generateString() {
        return this.changeToStr();
    }

    @Override
    public String getLinkKey() {
        this.initLinkInfo();
        return this.mLinkKey;
    }

    @Override
    public String getLinkId() {
        this.initLinkInfo();
        return this.mLinkID;
    }

    private void initLinkInfo() {
        if (!TextUtils.isEmpty((CharSequence)this.mLinkID) && !TextUtils.isEmpty((CharSequence)this.mLinkKey)) {
            return;
        }
        if (this.mHasInitLinkInfo) {
            return;
        }
        for (AbsSection absSection : this.sectionList) {
            if (!(absSection instanceof KVSection)) continue;
            Map<String, Object> map = ((KVSection)absSection).getDataMap();
            if (TextUtils.isEmpty((CharSequence)this.mLinkID) && map.containsKey("w_frmid")) {
                this.mLinkID = String.valueOf(map.get("w_frmid"));
            }
            if (!TextUtils.isEmpty((CharSequence)this.mLinkKey) || !map.containsKey("w_linkKey")) continue;
            this.mLinkKey = String.valueOf(map.get("w_linkKey"));
        }
        this.mHasInitLinkInfo = true;
    }
}

