/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.junit5;

import com.tngtech.jgiven.impl.util.ParameterNameUtil;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import com.tngtech.jgiven.report.model.NamedArgument;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArgumentReflectionUtil {
    private static final Logger log = LoggerFactory.getLogger(ArgumentReflectionUtil.class);
    static final String METHOD_EXTENSION_CONTEXT = "org.junit.jupiter.engine.descriptor.MethodExtensionContext";
    static final String TEST_TEMPLATE_INVOCATION_TEST_DESCRIPTOR = "org.junit.jupiter.engine.descriptor.TestTemplateInvocationTestDescriptor";
    static final String PARAMETERIZED_TEST_INVOCATION_CONTEXT = "org.junit.jupiter.params.ParameterizedTestInvocationContext";
    static final String ERROR = "Not able to access field containing test method arguments. Probably the internal representation has changed. Consider writing a bug report.";

    ArgumentReflectionUtil() {
    }

    static List<NamedArgument> getNamedArgs(ExtensionContext context) {
        List<Object> namedArgs = new ArrayList<NamedArgument>();
        if (((Method)context.getTestMethod().get()).getParameterCount() > 0) {
            try {
                Object invocationContext;
                Field field;
                Object testDescriptor;
                if (context.getClass().getCanonicalName().equals(METHOD_EXTENSION_CONTEXT) && (testDescriptor = ReflectionUtil.getFieldValueOrNull((Field)(field = context.getClass().getSuperclass().getDeclaredField("testDescriptor")), (Object)context, (String)ERROR)) != null && testDescriptor.getClass().getCanonicalName().equals(TEST_TEMPLATE_INVOCATION_TEST_DESCRIPTOR) && (invocationContext = ReflectionUtil.getFieldValueOrNull((String)"invocationContext", (Object)testDescriptor, (String)ERROR)) != null && invocationContext.getClass().getCanonicalName().equals(PARAMETERIZED_TEST_INVOCATION_CONTEXT)) {
                    Object arguments = ReflectionUtil.getFieldValueOrNull((String)"arguments", (Object)invocationContext, (String)ERROR);
                    if (arguments instanceof Arguments) {
                        List<Object> args = Arrays.asList(((Arguments)arguments).get());
                        namedArgs = ParameterNameUtil.mapArgumentsWithParameterNames((AccessibleObject)((AccessibleObject)context.getTestMethod().get()), args);
                    } else {
                        log.warn("Not able to access field containing test method arguments. Probably the internal representation has changed. Consider writing a bug report. The type of arguments in the invocation context has changed. Please write a bug report.");
                    }
                }
            }
            catch (Exception e) {
                log.warn(ERROR, (Throwable)e);
            }
        }
        return namedArgs;
    }
}

