/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.junit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import com.tngtech.jgiven.impl.ScenarioBase;
import com.tngtech.jgiven.impl.util.ParameterNameUtil;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import com.tngtech.jgiven.junit.ScenarioModelHolder;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.NamedArgument;
import com.tngtech.jgiven.report.model.ReportModel;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.junit.Assume;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.MethodRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGivenMethodRule
implements MethodRule {
    private static final String DATAPROVIDER_FRAMEWORK_METHOD = "com.tngtech.java.junit.dataprovider.DataProviderFrameworkMethod";
    private static final String JUNITPARAMS_STATEMENT = "junitparams.internal.InvokeParameterisedMethod";
    private static final Logger log = LoggerFactory.getLogger(JGivenMethodRule.class);
    protected final ScenarioBase scenario;

    public JGivenMethodRule() {
        this(new ScenarioBase());
    }

    public JGivenMethodRule(ScenarioBase scenario) {
        this.scenario = scenario;
    }

    public ScenarioBase getScenario() {
        return this.scenario;
    }

    public Statement apply(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                JGivenMethodRule.this.starting(base, method, target);
                try {
                    base.evaluate();
                    JGivenMethodRule.this.succeeded();
                }
                catch (AssumptionViolatedException e) {
                    throw e;
                }
                catch (Throwable t) {
                    JGivenMethodRule.this.failed(t);
                    throw t;
                }
            }
        };
    }

    protected void succeeded() throws Throwable {
        this.scenario.finished();
        Assume.assumeTrue((boolean)EnumSet.of(ExecutionStatus.SUCCESS, ExecutionStatus.FAILED).contains(this.scenario.getScenarioModel().getExecutionStatus()));
    }

    protected void failed(Throwable e) throws Throwable {
        if (this.scenario.getExecutor().hasFailed()) {
            Throwable failedException = this.scenario.getExecutor().getFailedException();
            ArrayList errors = Lists.newArrayList((Object[])new Throwable[]{failedException, e});
            this.scenario.getExecutor().setFailedException((Exception)new MultipleFailureException((List)errors));
        } else {
            this.scenario.getExecutor().failed(e);
        }
        this.scenario.finished();
    }

    protected void starting(Statement base, FrameworkMethod testMethod, Object target) {
        ReportModel reportModel = ScenarioModelHolder.getInstance().getReportModel(target.getClass());
        this.scenario.setModel(reportModel);
        this.scenario.getExecutor().injectStages(target);
        this.scenario.startScenario(target.getClass(), testMethod.getMethod(), JGivenMethodRule.getNamedArguments(base, testMethod, target));
        this.scenario.getExecutor().readScenarioState(target);
    }

    @VisibleForTesting
    static List<NamedArgument> getNamedArguments(Statement base, FrameworkMethod method, Object target) {
        Executable constructorOrMethod = method.getMethod();
        List<Object> arguments = Collections.emptyList();
        if (DATAPROVIDER_FRAMEWORK_METHOD.equals(method.getClass().getCanonicalName())) {
            arguments = JGivenMethodRule.getArgumentsFrom(method, "parameters");
        }
        if (JUNITPARAMS_STATEMENT.equals(base.getClass().getCanonicalName())) {
            arguments = JGivenMethodRule.getArgumentsFrom(base, "params");
        }
        if (JGivenMethodRule.isParameterizedTest(target)) {
            Constructor<?> constructor = JGivenMethodRule.getOnlyConstructor(target.getClass());
            constructorOrMethod = constructor;
            arguments = JGivenMethodRule.getArgumentsFrom(constructor, target);
        }
        return ParameterNameUtil.mapArgumentsWithParameterNames((AccessibleObject)constructorOrMethod, arguments);
    }

    private static List<Object> getArgumentsFrom(Object object, String fieldName) {
        Class<?> methodClass = object.getClass();
        try {
            Field field = methodClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return Arrays.asList((Object[])field.get(object));
        }
        catch (NoSuchFieldException e) {
            log.warn(String.format("Could not find field containing test method arguments in '%s'. Probably the internal representation has changed. Consider writing a bug report.", methodClass.getSimpleName()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn(String.format("Not able to access field containing test method arguments in '%s'. Probably the internal representation has changed. Consider writing a bug report.", methodClass.getSimpleName()), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private static boolean isParameterizedTest(Object target) {
        RunWith runWith = target.getClass().getAnnotation(RunWith.class);
        return runWith != null && Parameterized.class.equals((Object)runWith.value());
    }

    private static Constructor<?> getOnlyConstructor(Class<?> testClass) {
        Constructor<?>[] constructors = testClass.getConstructors();
        if (constructors.length != 1) {
            log.warn("Test class can only have one public constructor, see org.junit.runners.Parameterized.TestClassRunnerForParameters.validateConstructor(List<Throwable>)");
        }
        return constructors[0];
    }

    private static List<Object> getArgumentsFrom(Constructor<?> constructor, Object target) {
        Class<?> testClass = target.getClass();
        Class<?>[] constructorParamClasses = constructor.getParameterTypes();
        List fieldValues = ReflectionUtil.getAllNonStaticFieldValuesFrom(testClass, (Object)target, (String)" Consider writing a bug report.");
        return JGivenMethodRule.getTypeMatchingValuesInOrderOf(constructorParamClasses, fieldValues);
    }

    private static List<Object> getTypeMatchingValuesInOrderOf(Class<?>[] expectedClasses, List<Object> values) {
        ArrayList valuesCopy = Lists.newArrayList(values);
        ArrayList<Object> result = new ArrayList<Object>();
        block0: for (Class<?> argumentClass : expectedClasses) {
            Iterator iterator = valuesCopy.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (!Primitives.wrap(argumentClass).isInstance(value)) continue;
                result.add(value);
                iterator.remove();
                continue block0;
            }
        }
        if (result.size() < expectedClasses.length) {
            log.warn(String.format("Couldn't find matching values in '%s' for expected classes '%s',", valuesCopy, Arrays.toString(expectedClasses)));
        }
        return result;
    }
}

