/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.TeraDriver;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.TimeZone;

public class ClientAttributesParcel
extends Parcel {
    public static final int JAVA_VERSION = ClientAttributesParcel.getJavaVersion();
    private static final short PCLCLIATT_HOSTNAME = 7;
    private static final short PCLCLIATT_PROCTHRID = 8;
    private static final short PCLCLIATT_SYSUSERID = 9;
    private static final short PCLCLIATT_PROGNAME = 10;
    private static final short PCLCLIATT_OSNAME = 11;
    private static final short PCLCLIATT_VMUSERID = 12;
    private static final short PCLCLIATT_JOBNAME = 13;
    private static final short PCLCLIATT_ENVNAME = 14;
    private static final short PCLCLIATT_UIDSECPROD = 15;
    private static final short PCLCLIATT_GRPSECPROD = 16;
    private static final short PCLCLIATT_COORDNAME = 17;
    private static final short PCLCLIATT_TRANID = 18;
    private static final short PCLCLIATT_TERMID = 19;
    private static final short PCLCLIATT_USEROPERID = 20;
    private static final short PCLCLIATT_JOBID = 21;
    private static final short PCLCLIATT_VMNAME = 22;
    private static final short PCLCLIATT_TDPRELID = 23;
    private static final short PCLCLIATT_CLIV2RELID = 24;
    private static final short PCLCLIATT_SESSDESC = 25;
    private static final short PCLCLIATT_WORKLOAD = 26;
    private static final short PCLCLIATT_JOBDATA = 27;
    private static final short PCLCLIATT_CLIENTKIND = 28;
    private static final short PCLCLIATT_CLIENTVERSION = 29;
    private static final short PCLCLIATT_ClIENTATTRIBUTESEX = 30;
    private static final short PCLCLIATT_CLIENT_IPADDR_BY_CLIENT = 31;
    private static final short PCLCLIATT_CLIENT_PORT_BY_CLIENT = 32;
    private static final short PCLCLIATT_SERVER_IPADDR_BY_CLIENT = 33;
    private static final short PCLCLIATT_SERVER_PORT_BY_CLIENT = 34;
    private static final short PCLCLIATT_COP_SUFFIXED_HOST_NAME = 45;
    private static final short PCLCLIATT_TDP_SESSION_POOL_NAME = 51;
    private static final short PCLCLIATT_CLIENT_CONFIDENTIALITY_TYPE = 58;
    private static final short PCLCLIATT_END = Short.MAX_VALUE;

    public ClientAttributesParcel(GenericTeradataConnection genericTeradataConnection) throws SQLException {
        super(genericTeradataConnection);
        Object object;
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        Extra extra = genericTeradataConnection.m_extraClientAttributes;
        byte by = genericTeradataConnection.getTdSessionCharSetCode();
        TDNetworkIOIF tDNetworkIOIF = genericTeradataConnection.getIO();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            boolean bl;
            int n;
            object = tDNetworkIOIF.getOriginalHostName() + (genericTeradataConnection.getConfigResponse().areUnityClientAttributesSupported() ? "" : ";" + tDNetworkIOIF.getRemoteAddress() + ":" + tDNetworkIOIF.getRemotePort());
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)7, (String)object);
            long l = System.currentTimeMillis();
            String string = ClientAttributesParcel.getJVMProcessID();
            if (this.log.isTimingEnabled()) {
                this.log.timing("getJVMProcessID " + string + " took " + (System.currentTimeMillis() - l) + " ms");
            }
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)8, string);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)9, System.getProperty("user.name"));
            String string2 = ClientAttributesParcel.getJavaProgramName();
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)10, string2);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)11, System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
            String string3 = System.getProperty("java.vm.info");
            if (string3 != null) {
                string3 = string3.replaceAll("\\s+", " ").trim();
            }
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)22, System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " " + string3);
            Provider[] providerArray = Security.getProviders();
            boolean bl2 = providerArray != null && providerArray.length > 0 && providerArray[0].getName().endsWith("FIPS");
            String string4 = providerArray != null && providerArray.length > 0 ? "" + providerArray[0] : "unavailable";
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)16, string4);
            String string5 = genericTeradataConnection.getIO().getProxyUsed();
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)17, string5);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)19, extra.sIdpProxyUsed);
            String[] stringArray = new String[1];
            String string6 = tDNetworkIOIF.getTLSProtocol(stringArray);
            String string7 = stringArray[0];
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)25, "C=" + (uRLParameters.getSSLCipher() != null ? "Y" : "N") + ";" + (string7 != null ? "D=" + string7 + ";" : "") + (extra.sIdpCipher != null ? "I=" + extra.sIdpCipher + ";" : ""));
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)28, "J");
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)29, Const.DRIVER_VERSION);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)14, extra.sOIDCMetadataURL);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)21, extra.sOIDCClientID);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)13, extra.sLogonOIDCScope);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)27, extra.sOIDCLoginHint);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)20, extra.sOIDCTokenKind);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)26, extra.sOAuthScopes);
            String string8 = Utility.coalesce(uRLParameters.getSSLCRC(), "DEFAULT") + (uRLParameters.getSSLCRCAny() ? ",ANY" : "");
            String string9 = Utility.coalesce(uRLParameters.getLogMech(), "DEF");
            boolean bl3 = "BROWSER".equalsIgnoreCase(string9);
            ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)30, "" + (uRLParameters.getApplicationESN() != null ? "AS=" + uRLParameters.getApplicationESN() + ";" : "") + "BA=" + (bl3 ? "Y" : "N") + ";" + "CCS=" + genericTeradataConnection.getCharsetInfo().getClientCharsetNameForClientAttributes() + ";" + "CERT=" + tDNetworkIOIF.getCertStatus() + ";" + "CF=" + uRLParameters.getConnectFunction() + ";" + "CID=" + tDNetworkIOIF.getConnectionID() + ";" + "CRC=" + string8 + ";" + "CRL=" + (uRLParameters.getSSLCRL() ? "Y" : "N") + ";" + (uRLParameters.getControlESN() != null ? "CS=" + uRLParameters.getControlESN() + ";" : "") + (uRLParameters.getDatabaseLSN() != null ? "DL=" + uRLParameters.getDatabaseLSN() + ";" : "") + "DP=" + uRLParameters.getDbsPort() + ";" + (uRLParameters.getLogonSequenceNumber() != null ? "EL=" + uRLParameters.getLogonSequenceNumber() + ";" : "") + "ENC=" + (genericTeradataConnection.getEncryptData() ? "Y" : "N") + ";" + "ES=" + genericTeradataConnection.getSessionNum() + ";" + "FIPS=" + (bl2 ? "Y" : "N") + ";" + "GOV=" + (uRLParameters.isGoverned() ? "Y" : "N") + ";" + "HP=" + uRLParameters.getHTTPSPort() + ";" + "HR=" + uRLParameters.getHTTPSRetry() + "," + tDNetworkIOIF.httpsRetries() + ";" + (extra.sIdpCertStatus != null ? "IDPC=" + extra.sIdpCertStatus + ";" : "") + "JAVA=" + System.getProperty("java.version") + ";" + (extra.sJWTHeaderParams != null ? "JH=" + extra.sJWTHeaderParams + ";" : "") + (extra.sJWSAlgorithm != null ? "JWS=" + extra.sJWSAlgorithm + ";" : "") + "LM=" + string9 + ";" + "LOB=" + (genericTeradataConnection.isLobSupported() ? "Y" : "N") + ";" + "MEM=" + Runtime.getRuntime().maxMemory() + ";" + "OA=" + uRLParameters.getOAuthLevel() + ";" + (extra.sOAuthReuseCounts != null ? "OAC=" + extra.sOAuthReuseCounts + ";" : "") + (extra.sOAuthRefreshAvail != null ? "OAR=" + extra.sOAuthRefreshAvail + ";" : "") + (extra.sTokenCacheStatus != null ? "OC=" + extra.sTokenCacheStatus + ";" : "") + "OCSP=" + (uRLParameters.getSSLOCSP() ? "Y" : "N") + ";" + "OP=" + (uRLParameters.getOIDCPrompt() != null ? "Y" : "N") + ";" + "OSL=" + uRLParameters.getOIDCSSLModeLevel() + ";" + "OSM=" + Utility.coalesce(uRLParameters.getOIDCSSLMode(), "DEFAULT") + ";" + "PART=" + uRLParameters.getPartition() + ";" + "RED=" + genericTeradataConnection.desiredRedriveLevel() + "," + genericTeradataConnection.databaseCapableOfRedriveLevel() + ";" + (extra.sOIDCRedirectPort != null ? "RP=" + extra.sOIDCRedirectPort + ";" : "") + (extra.sRefreshTokenAvail != null ? "RT=" + extra.sRefreshTokenAvail + ";" : "") + "SC=" + tDNetworkIOIF.connectAttempts() + "," + tDNetworkIOIF.connectFailures() + ";" + "SCS=" + uRLParameters.getCharSet() + ";" + "SE=" + (genericTeradataConnection.isStrictEncode() ? "Y" : "N") + ";" + "SIP=" + (genericTeradataConnection.isStatementInfoSupported() ? "Y" : "N") + ";" + "SSL=" + uRLParameters.getSSLModeLevel() + ";" + "SSLM=" + Utility.coalesce(uRLParameters.getSSLMode(), "DEFAULT") + ";" + "SSLP=" + Utility.coalesce(uRLParameters.getSSLProtocol(), "DEFAULT") + ";" + (extra.sTokenReuseCount != null ? "TC=" + extra.sTokenReuseCount + ";" : "") + "TM=" + (genericTeradataConnection.isAnsiMode() ? "A" : "T") + ";" + (extra.sTokenTTLSecs != null ? "TT=" + extra.sTokenTTLSecs + ";" : "") + "TVD=" + string6 + ";" + (extra.sIdpProtocol != null ? "TVI=" + extra.sIdpProtocol + ";" : "") + "TYPE=" + uRLParameters.getType() + ";" + "TZ=" + TDPreparedStatement.formatTimeZone(TimeZone.getDefault()) + ";");
            if (genericTeradataConnection.getConfigResponse().areUnityClientAttributesSupported()) {
                ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)31, tDNetworkIOIF.getLocalAddress().getHostAddress());
                dataOutputStream.writeShort(32);
                dataOutputStream.writeShort(2);
                dataOutputStream.writeShort(tDNetworkIOIF.getLocalPort());
                ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)33, tDNetworkIOIF.getRemoteAddress().getHostAddress());
                dataOutputStream.writeShort(34);
                dataOutputStream.writeShort(2);
                dataOutputStream.writeShort(tDNetworkIOIF.getRemotePort());
                int n2 = n = !tDNetworkIOIF.getRemoteAddress().toString().startsWith("/") ? 1 : 0;
                if (n != 0) {
                    ClientAttributesParcel.serializeStringAttribute(dataOutputStream, by, genericTeradataConnection, (short)45, tDNetworkIOIF.getRemoteAddress().getHostName());
                }
            }
            n = this.m_con.getURLParameters().getSSLModeLevel();
            boolean bl4 = bl = !tDNetworkIOIF.isSSLSocket() && genericTeradataConnection.getEncryptData();
            int n3 = n == 6 ? 86 : (n == 5 ? 67 : (tDNetworkIOIF.isSSLSocket() ? 82 : (n <= 2 ? (bl ? 69 : 85) : (bl ? 70 : 72))));
            dataOutputStream.writeShort(58);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeByte(n3);
            dataOutputStream.writeShort(Short.MAX_VALUE);
            dataOutputStream.writeShort(0);
        }
        catch (IOException iOException) {
            throw ErrorAnalyzer.analyzeIoError("ClientAttributesParcel construction", tDNetworkIOIF, iOException, false, false);
        }
        object = byteArrayOutputStream.toByteArray();
        this.setFlavor((short)189);
        this.setLength(this.headerLength() + ((Object)object).length);
        this.createBuffer(this.getLength());
        this.parcelHeaderToStream();
        this.buffer.put((byte[])object);
        this.buffer.rewind();
    }

    @Override
    public TDPacketStream toStream() throws SQLException {
        return this.buffer;
    }

    private static void serializeStringAttribute(DataOutputStream dataOutputStream, byte by, GenericTeradataConnection genericTeradataConnection, short s, String string) throws SQLException, IOException {
        if (string == null) {
            return;
        }
        if (string.length() > 1000) {
            string = string.substring(1000);
        }
        byte[] byArray = Encoder.encodeStringReplace(genericTeradataConnection, string);
        dataOutputStream.writeShort(s);
        dataOutputStream.writeShort(1 + byArray.length);
        dataOutputStream.writeByte(by);
        dataOutputStream.write(byArray);
    }

    public static String getJVMProcessID() {
        Object object;
        Object object2;
        GenericDeclaration genericDeclaration;
        Method method;
        Class<?> clazz;
        if (JAVA_VERSION >= 9000) {
            try {
                clazz = Class.forName("java.lang.ProcessHandle");
                method = clazz.getMethod("current", null);
                genericDeclaration = clazz.getMethod("pid", null);
                object2 = method.invoke(null, (Object[])null);
                object = ((Method)genericDeclaration).invoke(object2, null);
                if (object instanceof Long) {
                    return object.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            clazz = Class.forName("java.lang.management.ManagementFactory");
            method = clazz.getMethod("getRuntimeMXBean", null);
            genericDeclaration = Class.forName("java.lang.management.RuntimeMXBean");
            object2 = ((Class)genericDeclaration).getMethod("getName", null);
            object = method.invoke(null, (Object[])null);
            Object object3 = ((Method)object2).invoke(object, (Object[])null);
            if (object3 instanceof String) {
                return (String)object3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getJavaProgramName() {
        String string = ClientAttributesParcel.currentProcessExecutable();
        if (string.length() == 0) {
            string = System.getProperty("java.home", "");
        }
        String string2 = TeraDriver.class.getPackage().getName();
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        if (stackTraceElementArray != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
                String[] stringArray;
                String string3;
                String string4 = string3 = stackTraceElementArray[i] != null ? stackTraceElementArray[i].getClassName() : null;
                if (string3 == null || string3.startsWith("java.") || string3.startsWith("jdk.") || (stringArray = string3.split("\\.")).length <= 0 || stringArray[0].length() <= 0) continue;
                if (stringArray.length == 1) {
                    stringArray = new String[]{"", stringArray[0]};
                }
                String string5 = stringArray[0];
                if (stringArray.length >= 3) {
                    string5 = string5 + "." + stringArray[1];
                }
                String string6 = string5;
                if (stringArray.length >= 4) {
                    string6 = string6 + "." + stringArray[2];
                }
                String string7 = stringArray[stringArray.length - 1];
                if (string6.equals(string2)) {
                    string5 = string6;
                }
                if (hashSet.contains(string5)) continue;
                hashSet.add(string5);
                string = string + (string.length() > 0 ? " " : "") + string6 + (string6.length() > 0 ? " " : "") + string7;
            }
        }
        return string.length() > 0 ? string : null;
    }

    public static String currentProcessExecutable() {
        try {
            Class<?> clazz = Class.forName("java.lang.ProcessHandle");
            Object object = clazz.getMethod("current", null).invoke(null, (Object[])null);
            Object object2 = clazz.getMethod("info", null).invoke(object, (Object[])null);
            Object object3 = Class.forName("java.lang.ProcessHandle$Info").getMethod("command", null).invoke(object2, (Object[])null);
            return "" + object3.getClass().getMethod("orElse", Object.class).invoke(object3, "");
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static int parseUnsignedByte(String string) {
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static int getJavaVersion() {
        int[] nArray = new int[]{0, 0};
        String string = System.getProperty("java.version");
        if (string != null) {
            String[] stringArray = string.replaceAll("\\D+", " ").trim().split(" ");
            for (int i = 0; i < nArray.length && i < stringArray.length; ++i) {
                int n = ClientAttributesParcel.parseUnsignedByte(stringArray[i]);
                if (n < 0) continue;
                nArray[i] = n;
            }
        }
        return nArray[0] * 1000 + nArray[1];
    }

    public static class Extra {
        public String sIdpProxyUsed;
        public String sIdpProtocol;
        public String sIdpCipher;
        public String sIdpCertStatus;
        public String sOIDCMetadataURL;
        public String sOIDCClientID;
        public String sLogonOIDCScope;
        public String sOIDCLoginHint;
        public String sOIDCTokenKind;
        public String sOIDCRedirectPort;
        public String sTokenCacheStatus;
        public String sTokenReuseCount;
        public String sRefreshTokenAvail;
        public String sTokenTTLSecs;
        public String sJWSAlgorithm;
        public String sJWTHeaderParams;
        public String sOAuthReuseCounts;
        public String sOAuthRefreshAvail;
        public String sOAuthScopes;
    }
}

