/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.util.Vector;

public class LobBuffer {
    private TDStatement stmt;
    private TDPacketStream buf;
    private long lobLength;
    private int totalData;
    private int totalRecords = 0;
    private int currentRecordPosition = 0;
    private int currentRecordLength = 0;
    private int currentRecord = 0;
    private Vector recLength;
    private Vector slobBuffers;
    private boolean endOfFile = false;
    private boolean endOfData = false;
    private boolean init;
    protected Log log;

    public LobBuffer(StatementController statementController, Log log) {
        this.log = log;
        if (statementController != null) {
            this.stmt = statementController.getStatement();
        }
        this.buf = null;
        this.recLength = new Vector();
    }

    public void addBufferRecord(TDPacketStream tDPacketStream, int n) {
        if (this.buf == null) {
            this.initBufferForWriting(tDPacketStream);
        }
        this.addRecord(n);
    }

    public void addSlobBufferRecord(TDPacketStream tDPacketStream, int n) {
        tDPacketStream.mark();
        this.addBufferRecord(tDPacketStream, n);
        if (this.slobBuffers == null) {
            this.slobBuffers = new Vector();
        }
        this.slobBuffers.add(tDPacketStream);
    }

    public int read(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n2;
        int n4 = 0;
        while (n3 > 0) {
            int n5 = this.readBuffer(byArray, n, n3);
            if (n5 == -1) {
                this.log.debug("TotalAmountRead: " + n4);
                return n4 > 0 ? n4 : -1;
            }
            n3 -= n5;
            n4 += n5;
            n += n5;
        }
        this.log.debug("TotalAmountRead: " + n4);
        return n4;
    }

    protected int readBuffer(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = 0;
        if (this.endOfData && this.endOfFile) {
            return -1;
        }
        if (this.endOfData) {
            this.refillBuffer();
        }
        this.initBufferForReading();
        int n4 = this.currentRecordLength - this.currentRecordPosition;
        if (n2 < n4) {
            this.buf.get(byArray, n, n2);
            this.currentRecordPosition += n2;
            n3 = n2;
        } else {
            this.buf.get(byArray, n, n4);
            this.currentRecordPosition += n4;
            n3 = n4;
            if (this.haveMoreRecords()) {
                this.nextRecord();
                n3 += this.readBuffer(byArray, n + n4, n2 - n4);
            } else {
                this.endOfData = true;
            }
        }
        return n3;
    }

    public String readClobString(boolean bl) throws SQLException {
        String string = null;
        if (this.endOfData && this.endOfFile) {
            return null;
        }
        if (this.endOfData) {
            this.refillBuffer();
        }
        this.initBufferForReading();
        string = this.buf.getClobString(bl, (GenericTeradataConnection)((Object)this.stmt.getConnection()), this.currentRecordLength);
        if (this.haveMoreRecords()) {
            this.nextRecord();
        } else {
            this.endOfData = true;
        }
        return string;
    }

    public String readSlobString(boolean bl, int n, int n2) throws SQLException {
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        int n4 = n - 1;
        for (int i = 0; i < this.recLength.size(); ++i) {
            int n5 = (Integer)this.recLength.get(i);
            TDPacketStream tDPacketStream = (TDPacketStream)this.slobBuffers.get(i);
            String string = tDPacketStream.getSlobString(bl, (GenericTeradataConnection)((Object)this.stmt.getConnection()), n5);
            int n6 = string.length();
            if (!bl2 && n4 < n6) {
                n3 = n4;
                n4 += n4 + n2 - 1;
                bl2 = true;
            }
            if (bl2) {
                stringBuffer.append(string);
                if (n4 < n6) break;
            }
            n4 -= n6;
        }
        return stringBuffer.substring(n3, n3 + n2);
    }

    public void readSlobBytes(byte[] byArray, int n, int n2) throws SQLException {
        boolean bl = false;
        int n3 = n - 1;
        int n4 = 0;
        for (int i = 0; i < this.recLength.size(); ++i) {
            int n5 = 0;
            int n6 = (Integer)this.recLength.get(i);
            if (!bl && n3 <= n6) {
                n5 = n3;
                n3 += n2;
                bl = true;
            }
            if (bl) {
                if (n3 <= n6) {
                    ((TDPacketStream)this.slobBuffers.get(i)).getSlobBytes(byArray, n4, n5, n2 - n4);
                    break;
                }
                ((TDPacketStream)this.slobBuffers.get(i)).getSlobBytes(byArray, n4, n5, n6 - n5);
                n4 += n6 - n5;
            }
            n3 -= n6;
        }
    }

    public int nextByte() throws SQLException {
        if (this.endOfData && this.endOfFile) {
            return -1;
        }
        if (this.endOfData) {
            this.refillBuffer();
        }
        this.initBufferForReading();
        int n = this.buf.get() & 0xFF;
        ++this.currentRecordPosition;
        if (this.currentRecordPosition == this.currentRecordLength) {
            if (this.haveMoreRecords()) {
                this.nextRecord();
            } else {
                this.endOfData = true;
            }
        }
        return n;
    }

    public void setEndOfFile() {
        this.endOfFile = true;
    }

    public void setEndOfData() {
        this.endOfData = true;
    }

    public int lobLength() {
        return (int)this.lobLength;
    }

    public void setLobLength(long l) {
        this.lobLength = l;
    }

    public void close() throws SQLException {
        if (this.slobBuffers == null) {
            this.stmt.close();
        }
    }

    public void resetBuffer() throws SQLException {
        this.init = true;
        this.buf = (TDPacketStream)this.slobBuffers.get(0);
        this.initBufferForReading();
    }

    private void initBufferForReading() throws SQLException {
        if (this.init) {
            this.buf.reset();
            this.currentRecordLength = (Integer)this.recLength.get(0);
            this.currentRecordPosition = 0;
            this.currentRecord = 1;
            this.endOfData = false;
            this.init = false;
        }
    }

    private void initBufferForWriting(TDPacketStream tDPacketStream) {
        this.buf = tDPacketStream;
        this.buf.mark();
        this.totalData = 0;
        this.totalRecords = 0;
        this.init = true;
        this.recLength.clear();
    }

    private void addRecord(int n) {
        this.recLength.addElement(new Integer(n));
        this.totalData += n;
        ++this.totalRecords;
    }

    private void nextRecord() throws SQLException {
        this.currentRecordLength = (Integer)this.recLength.get(this.currentRecord);
        this.currentRecordPosition = 0;
        if (this.slobBuffers == null || this.slobBuffers.isEmpty()) {
            Parcel.readParcelHeader(this.buf, this.log);
        } else {
            this.buf = (TDPacketStream)this.slobBuffers.get(this.currentRecord);
            this.buf.reset();
        }
        ++this.currentRecord;
    }

    private boolean haveMoreRecords() {
        return this.currentRecord < this.totalRecords;
    }

    private void refillBuffer() throws SQLException {
        this.buf = null;
        if (this.slobBuffers != null || !(this.stmt instanceof TDPreparedStatement)) {
            throw ErrorFactory.makeDriverJDBCException("TJ805");
        }
        ((TDPreparedStatement)this.stmt).lobContinue();
    }

    public boolean slobBufferAdded() {
        return this.slobBuffers != null && this.slobBuffers.size() > 0;
    }
}

