/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.raw;

import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.raw.RawConnection;
import com.teradata.jdbc.jdbc.raw.RawParameterMetaData;
import com.teradata.jdbc.jdbc.raw.RawResultSet;
import com.teradata.jdbc.jdbc.raw.RawResultSetMetaData;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class RawPreparedStatement
implements PreparedStatement {
    protected RawConnection con = null;
    private RawParameterMetaData paramMetaData = null;
    private RawResultSet resultSet = null;
    private RawResultSetMetaData resultSetMetaData = null;
    private byte[] rawMessageToSend = null;
    private int rawMessageToSendLength = 0;
    private int queryTimeoutSeconds = 0;

    public RawPreparedStatement(RawConnection rawConnection) throws SQLException {
        this.con = rawConnection;
        this.paramMetaData = rawConnection.constructParameterMetaData(this);
        this.resultSetMetaData = rawConnection.constructResultSetMetaData(this);
    }

    protected void abortIfClosed() throws SQLException {
        if (this.con.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void abortIfIndexNotValid(int n) throws SQLException {
        if (n <= 0 || n > this.paramMetaData.getParameterCount()) {
            throw ErrorFactory.makeDriverJDBCException("TJ411", n);
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        return Utility.chainSQLExceptions(sQLException, sQLException2);
    }

    private void initMessage() throws SQLException {
        int n = this.con.getSessionNum();
        this.rawMessageToSend[20] = (byte)(n >> 24 & 0xFF);
        this.rawMessageToSend[21] = (byte)(n >> 16 & 0xFF);
        this.rawMessageToSend[22] = (byte)(n >> 8 & 0xFF);
        this.rawMessageToSend[23] = (byte)(n & 0xFF);
        long l = this.con.getAuthenticationNonce();
        this.rawMessageToSend[24] = (byte)(l >> 56 & 0xFFL);
        this.rawMessageToSend[25] = (byte)(l >> 48 & 0xFFL);
        this.rawMessageToSend[26] = (byte)(l >> 40 & 0xFFL);
        this.rawMessageToSend[27] = (byte)(l >> 32 & 0xFFL);
        this.rawMessageToSend[28] = (byte)(l >> 24 & 0xFFL);
        this.rawMessageToSend[29] = (byte)(l >> 16 & 0xFFL);
        this.rawMessageToSend[30] = (byte)(l >> 8 & 0xFFL);
        this.rawMessageToSend[31] = (byte)(l & 0xFFL);
    }

    private void requestResults() throws SQLException {
        this.initMessage();
        this.con.getIO().write(this.rawMessageToSend, null, true);
    }

    @Override
    public void addBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        this.rawMessageToSend = null;
    }

    @Override
    public boolean execute() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.abortIfClosed();
        if (this.rawMessageToSend == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ605");
        }
        SQLException sQLException = null;
        this.resultSet = this.con.constructResultSet(this);
        try {
            this.clearWarnings();
            this.requestResults();
        }
        catch (SQLException sQLException2) {
            sQLException = RawPreparedStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ567");
            sQLException3.setNextException(sQLException);
            throw sQLException3;
        }
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        return this.resultSetMetaData;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        return this.paramMetaData;
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setObject(n, (Object)byArray, -2, byArray == null ? 0 : byArray.length);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (object == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ604", n);
        }
        if (n2 != -2) {
            throw ErrorFactory.makeDriverJDBCException("TJ723", n, n2);
        }
        if (!(object instanceof byte[])) {
            throw ErrorFactory.makeDriverJDBCException("TJ724", String.valueOf(n), object.getClass().getName());
        }
        byte[] byArray = (byte[])object;
        if (byArray.length < n3) {
            throw ErrorFactory.makeDriverJDBCException("TJ725", n, byArray.length, n3);
        }
        if (byArray.length < 52 || n3 < 52) {
            throw ErrorFactory.makeDriverJDBCException("TJ606", 52, n);
        }
        if ((byArray[1] & 0x80) != 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ607", n);
        }
        int n4 = byArray[3] << 24 & 0xFF000000 | byArray[4] << 16 & 0xFF0000 | byArray[8] << 8 & 0xFF00 | byArray[9] & 0xFF;
        if (n3 - 52 != n4) {
            throw ErrorFactory.makeDriverJDBCException("TJ608", n, n3 - 52, n4);
        }
        this.rawMessageToSend = byArray;
        this.rawMessageToSendLength = n3;
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void close() throws SQLException {
        this.resultSet = null;
        this.paramMetaData = null;
        this.resultSetMetaData = null;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.con;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        this.resultSet = null;
        return false;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return this.queryTimeoutSeconds;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
        if (n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ603", n);
        }
        this.queryTimeoutSeconds = n;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.paramMetaData == null || this.resultSetMetaData == null;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.abortIfClosed();
        return true;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setAsciiStream(int,InputStream)");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setAsciiStream(int,InputStream,long)");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream,long)");
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream");
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream,long)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader,long)");
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader)");
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader,long)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader,long)");
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader)");
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader,long)");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,NClob)");
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

