/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.stub;

import javax.annotation.CheckReturnValue;
import javax.annotation.concurrent.ThreadSafe;
import shade.polaris.io.grpc.CallOptions;
import shade.polaris.io.grpc.Channel;
import shade.polaris.io.grpc.stub.AbstractStub;
import shade.polaris.io.grpc.stub.ClientCalls;

@CheckReturnValue
@ThreadSafe
public abstract class AbstractBlockingStub<S extends AbstractBlockingStub<S>>
extends AbstractStub<S> {
    protected AbstractBlockingStub(Channel channel, CallOptions callOptions) {
        super(channel, callOptions);
    }

    public static <T extends AbstractStub<T>> T newStub(AbstractStub.StubFactory<T> factory, Channel channel) {
        return AbstractBlockingStub.newStub(factory, channel, CallOptions.DEFAULT);
    }

    public static <T extends AbstractStub<T>> T newStub(AbstractStub.StubFactory<T> factory, Channel channel, CallOptions callOptions) {
        T stub = factory.newStub(channel, callOptions.withOption(ClientCalls.STUB_TYPE_OPTION, ClientCalls.StubType.BLOCKING));
        assert (stub instanceof AbstractBlockingStub) : String.format("Expected AbstractBlockingStub, but got %s.", stub.getClass());
        return stub;
    }
}

