/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.rls;

import javax.annotation.Nullable;
import shade.polaris.com.google.common.annotations.VisibleForTesting;
import shade.polaris.com.google.common.base.MoreObjects;
import shade.polaris.com.google.common.base.Preconditions;
import shade.polaris.io.grpc.ChannelLogger;
import shade.polaris.io.grpc.ConnectivityState;
import shade.polaris.io.grpc.LoadBalancer;
import shade.polaris.io.grpc.Status;
import shade.polaris.io.grpc.rls.AdaptiveThrottler;
import shade.polaris.io.grpc.rls.CachingRlsLbClient;
import shade.polaris.io.grpc.rls.ChildLbResolvedAddressFactory;
import shade.polaris.io.grpc.rls.LbPolicyConfiguration;

final class RlsLoadBalancer
extends LoadBalancer {
    private final ChannelLogger logger;
    private final LoadBalancer.Helper helper;
    @VisibleForTesting
    CachingRlsLbClientBuilderProvider cachingRlsLbClientBuilderProvider = new DefaultCachingRlsLbClientBuilderProvider();
    @Nullable
    private LbPolicyConfiguration lbPolicyConfiguration;
    @Nullable
    private CachingRlsLbClient routeLookupClient;

    RlsLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.logger = helper.getChannelLogger();
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Rls lb created. Authority: {0}", helper.getAuthority());
    }

    @Override
    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        LbPolicyConfiguration lbPolicyConfiguration = (LbPolicyConfiguration)resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull(lbPolicyConfiguration, "Missing rls lb config");
        if (!lbPolicyConfiguration.equals(this.lbPolicyConfiguration)) {
            boolean needToConnect;
            boolean bl = needToConnect = this.lbPolicyConfiguration == null || !this.lbPolicyConfiguration.getRouteLookupConfig().lookupService().equals(lbPolicyConfiguration.getRouteLookupConfig().lookupService());
            if (needToConnect) {
                if (this.routeLookupClient != null) {
                    this.routeLookupClient.close();
                }
                this.routeLookupClient = this.cachingRlsLbClientBuilderProvider.get().setHelper(this.helper).setLbPolicyConfig(lbPolicyConfiguration).setResolvedAddressesFactory(new ChildLbResolvedAddressFactory(resolvedAddresses.getAddresses(), resolvedAddresses.getAttributes())).build();
                this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "LbPolicyConfiguration updated to {0}", lbPolicyConfiguration);
            }
            this.lbPolicyConfiguration = lbPolicyConfiguration;
        }
    }

    @Override
    public void requestConnection() {
        if (this.routeLookupClient != null) {
            this.routeLookupClient.requestConnection();
        }
    }

    @Override
    public void handleNameResolutionError(final Status error) {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Received resolution error: {0}", error);
        if (this.routeLookupClient != null) {
            this.routeLookupClient.close();
            this.routeLookupClient = null;
            this.lbPolicyConfiguration = null;
        }
        class ErrorPicker
        extends LoadBalancer.SubchannelPicker {
            ErrorPicker() {
            }

            @Override
            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                return LoadBalancer.PickResult.withError(error);
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("error", error).toString();
            }
        }
        this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new ErrorPicker());
    }

    @Override
    public void shutdown() {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Rls lb shutdown");
        if (this.routeLookupClient != null) {
            this.routeLookupClient.close();
            this.routeLookupClient = null;
        }
    }

    static final class DefaultCachingRlsLbClientBuilderProvider
    implements CachingRlsLbClientBuilderProvider {
        DefaultCachingRlsLbClientBuilderProvider() {
        }

        @Override
        public CachingRlsLbClient.Builder get() {
            return CachingRlsLbClient.newBuilder().setThrottler(AdaptiveThrottler.builder().build());
        }
    }

    static interface CachingRlsLbClientBuilderProvider {
        public CachingRlsLbClient.Builder get();
    }
}

