/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.protobuf.services;

import shade.polaris.com.google.common.annotations.VisibleForTesting;
import shade.polaris.io.grpc.ExperimentalApi;
import shade.polaris.io.grpc.InternalChannelz;
import shade.polaris.io.grpc.InternalInstrumented;
import shade.polaris.io.grpc.Status;
import shade.polaris.io.grpc.StatusRuntimeException;
import shade.polaris.io.grpc.channelz.v1.ChannelzGrpc;
import shade.polaris.io.grpc.channelz.v1.GetChannelRequest;
import shade.polaris.io.grpc.channelz.v1.GetChannelResponse;
import shade.polaris.io.grpc.channelz.v1.GetServerRequest;
import shade.polaris.io.grpc.channelz.v1.GetServerResponse;
import shade.polaris.io.grpc.channelz.v1.GetServerSocketsRequest;
import shade.polaris.io.grpc.channelz.v1.GetServerSocketsResponse;
import shade.polaris.io.grpc.channelz.v1.GetServersRequest;
import shade.polaris.io.grpc.channelz.v1.GetServersResponse;
import shade.polaris.io.grpc.channelz.v1.GetSocketRequest;
import shade.polaris.io.grpc.channelz.v1.GetSocketResponse;
import shade.polaris.io.grpc.channelz.v1.GetSubchannelRequest;
import shade.polaris.io.grpc.channelz.v1.GetSubchannelResponse;
import shade.polaris.io.grpc.channelz.v1.GetTopChannelsRequest;
import shade.polaris.io.grpc.channelz.v1.GetTopChannelsResponse;
import shade.polaris.io.grpc.protobuf.services.ChannelzProtoUtil;
import shade.polaris.io.grpc.stub.StreamObserver;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4206")
public final class ChannelzService
extends ChannelzGrpc.ChannelzImplBase {
    private final InternalChannelz channelz;
    private final int maxPageSize;

    public static ChannelzService newInstance(int maxPageSize) {
        return new ChannelzService(InternalChannelz.instance(), maxPageSize);
    }

    @VisibleForTesting
    ChannelzService(InternalChannelz channelz, int maxPageSize) {
        this.channelz = channelz;
        this.maxPageSize = maxPageSize;
    }

    @Override
    public void getTopChannels(GetTopChannelsRequest request, StreamObserver<GetTopChannelsResponse> responseObserver) {
        GetTopChannelsResponse resp;
        InternalChannelz.RootChannelList rootChannels = this.channelz.getRootChannels(request.getStartChannelId(), this.maxPageSize);
        try {
            resp = ChannelzProtoUtil.toGetTopChannelResponse(rootChannels);
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getChannel(GetChannelRequest request, StreamObserver<GetChannelResponse> responseObserver) {
        GetChannelResponse resp;
        InternalInstrumented<InternalChannelz.ChannelStats> s2 = this.channelz.getRootChannel(request.getChannelId());
        if (s2 == null) {
            responseObserver.onError(Status.NOT_FOUND.withDescription("Can't find channel " + request.getChannelId()).asRuntimeException());
            return;
        }
        try {
            resp = GetChannelResponse.newBuilder().setChannel(ChannelzProtoUtil.toChannel(s2)).build();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getServers(GetServersRequest request, StreamObserver<GetServersResponse> responseObserver) {
        GetServersResponse resp;
        InternalChannelz.ServerList servers = this.channelz.getServers(request.getStartServerId(), this.maxPageSize);
        try {
            resp = ChannelzProtoUtil.toGetServersResponse(servers);
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getServer(GetServerRequest request, StreamObserver<GetServerResponse> responseObserver) {
        GetServerResponse resp;
        InternalInstrumented<InternalChannelz.ServerStats> s2 = this.channelz.getServer(request.getServerId());
        if (s2 == null) {
            responseObserver.onError(Status.NOT_FOUND.withDescription("Can't find server " + request.getServerId()).asRuntimeException());
            return;
        }
        try {
            resp = GetServerResponse.newBuilder().setServer(ChannelzProtoUtil.toServer(s2)).build();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getSubchannel(GetSubchannelRequest request, StreamObserver<GetSubchannelResponse> responseObserver) {
        GetSubchannelResponse resp;
        InternalInstrumented<InternalChannelz.ChannelStats> s2 = this.channelz.getSubchannel(request.getSubchannelId());
        if (s2 == null) {
            responseObserver.onError(Status.NOT_FOUND.withDescription("Can't find subchannel " + request.getSubchannelId()).asRuntimeException());
            return;
        }
        try {
            resp = GetSubchannelResponse.newBuilder().setSubchannel(ChannelzProtoUtil.toSubchannel(s2)).build();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getSocket(GetSocketRequest request, StreamObserver<GetSocketResponse> responseObserver) {
        GetSocketResponse resp;
        InternalInstrumented<InternalChannelz.SocketStats> s2 = this.channelz.getSocket(request.getSocketId());
        if (s2 == null) {
            responseObserver.onError(Status.NOT_FOUND.withDescription("Can't find socket " + request.getSocketId()).asRuntimeException());
            return;
        }
        try {
            resp = GetSocketResponse.newBuilder().setSocket(ChannelzProtoUtil.toSocket(s2)).build();
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }

    @Override
    public void getServerSockets(GetServerSocketsRequest request, StreamObserver<GetServerSocketsResponse> responseObserver) {
        GetServerSocketsResponse resp;
        InternalChannelz.ServerSocketsList serverSockets = this.channelz.getServerSockets(request.getServerId(), request.getStartSocketId(), this.maxPageSize);
        if (serverSockets == null) {
            responseObserver.onError(Status.NOT_FOUND.withDescription("Can't find server " + request.getServerId()).asRuntimeException());
            return;
        }
        try {
            resp = ChannelzProtoUtil.toGetServerSocketsResponse(serverSockets);
        }
        catch (StatusRuntimeException e) {
            responseObserver.onError(e);
            return;
        }
        responseObserver.onNext(resp);
        responseObserver.onCompleted();
    }
}

