/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.okhttp;

import javax.net.ssl.SSLSocketFactory;
import shade.polaris.com.google.common.base.Preconditions;
import shade.polaris.io.grpc.ExperimentalApi;
import shade.polaris.io.grpc.okhttp.OkHttpChannelBuilder;
import shade.polaris.io.grpc.okhttp.Utils;
import shade.polaris.io.grpc.okhttp.internal.ConnectionSpec;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1785")
public final class SslSocketFactoryServerCredentials {
    private SslSocketFactoryServerCredentials() {
    }

    public static shade.polaris.io.grpc.ServerCredentials create(SSLSocketFactory factory) {
        return new ServerCredentials(factory);
    }

    public static shade.polaris.io.grpc.ServerCredentials create(SSLSocketFactory factory, shade.polaris.com.squareup.okhttp.ConnectionSpec connectionSpec) {
        return new ServerCredentials(factory, Utils.convertSpec(connectionSpec));
    }

    static final class ServerCredentials
    extends shade.polaris.io.grpc.ServerCredentials {
        private final SSLSocketFactory factory;
        private final ConnectionSpec connectionSpec;

        ServerCredentials(SSLSocketFactory factory) {
            this(factory, OkHttpChannelBuilder.INTERNAL_DEFAULT_CONNECTION_SPEC);
        }

        ServerCredentials(SSLSocketFactory factory, ConnectionSpec connectionSpec) {
            this.factory = Preconditions.checkNotNull(factory, "factory");
            this.connectionSpec = Preconditions.checkNotNull(connectionSpec, "connectionSpec");
        }

        public SSLSocketFactory getFactory() {
            return this.factory;
        }

        public ConnectionSpec getConnectionSpec() {
            return this.connectionSpec;
        }
    }
}

