/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.com.squareup.okhttp.internal.http;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import shade.polaris.com.squareup.okhttp.Authenticator;
import shade.polaris.com.squareup.okhttp.Challenge;
import shade.polaris.com.squareup.okhttp.Credentials;
import shade.polaris.com.squareup.okhttp.HttpUrl;
import shade.polaris.com.squareup.okhttp.Request;
import shade.polaris.com.squareup.okhttp.Response;

public final class AuthenticatorAdapter
implements Authenticator {
    public static final Authenticator INSTANCE = new AuthenticatorAdapter();

    @Override
    public Request authenticate(Proxy proxy, Response response) throws IOException {
        List<Challenge> challenges = response.challenges();
        Request request = response.request();
        HttpUrl url = request.httpUrl();
        int size = challenges.size();
        for (int i = 0; i < size; ++i) {
            PasswordAuthentication auth;
            Challenge challenge = challenges.get(i);
            if (!"Basic".equalsIgnoreCase(challenge.getScheme()) || (auth = java.net.Authenticator.requestPasswordAuthentication(url.host(), this.getConnectToInetAddress(proxy, url), url.port(), url.scheme(), challenge.getRealm(), challenge.getScheme(), url.url(), Authenticator.RequestorType.SERVER)) == null) continue;
            String credential = Credentials.basic(auth.getUserName(), new String(auth.getPassword()));
            return request.newBuilder().header("Authorization", credential).build();
        }
        return null;
    }

    @Override
    public Request authenticateProxy(Proxy proxy, Response response) throws IOException {
        List<Challenge> challenges = response.challenges();
        Request request = response.request();
        HttpUrl url = request.httpUrl();
        int size = challenges.size();
        for (int i = 0; i < size; ++i) {
            InetSocketAddress proxyAddress;
            PasswordAuthentication auth;
            Challenge challenge = challenges.get(i);
            if (!"Basic".equalsIgnoreCase(challenge.getScheme()) || (auth = java.net.Authenticator.requestPasswordAuthentication((proxyAddress = (InetSocketAddress)proxy.address()).getHostName(), this.getConnectToInetAddress(proxy, url), proxyAddress.getPort(), url.scheme(), challenge.getRealm(), challenge.getScheme(), url.url(), Authenticator.RequestorType.PROXY)) == null) continue;
            String credential = Credentials.basic(auth.getUserName(), new String(auth.getPassword()));
            return request.newBuilder().header("Proxy-Authorization", credential).build();
        }
        return null;
    }

    private InetAddress getConnectToInetAddress(Proxy proxy, HttpUrl url) throws IOException {
        return proxy != null && proxy.type() != Proxy.Type.DIRECT ? ((InetSocketAddress)proxy.address()).getAddress() : InetAddress.getByName(url.host());
    }
}

