/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.com.google.common.collect;

import java.util.ListIterator;
import shade.polaris.com.google.common.annotations.GwtCompatible;
import shade.polaris.com.google.common.collect.ElementTypesAreNonnullByDefault;
import shade.polaris.com.google.common.collect.Iterators;
import shade.polaris.com.google.common.collect.ParametricNullness;
import shade.polaris.com.google.common.collect.TransformedIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class TransformedListIterator<F, T>
extends TransformedIterator<F, T>
implements ListIterator<T> {
    TransformedListIterator(ListIterator<? extends F> backingIterator) {
        super(backingIterator);
    }

    private ListIterator<? extends F> backingIterator() {
        return Iterators.cast(this.backingIterator);
    }

    @Override
    public final boolean hasPrevious() {
        return this.backingIterator().hasPrevious();
    }

    @Override
    @ParametricNullness
    public final T previous() {
        return this.transform(this.backingIterator().previous());
    }

    @Override
    public final int nextIndex() {
        return this.backingIterator().nextIndex();
    }

    @Override
    public final int previousIndex() {
        return this.backingIterator().previousIndex();
    }

    @Override
    public void set(@ParametricNullness T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(@ParametricNullness T element) {
        throw new UnsupportedOperationException();
    }
}

