/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.common.model;

import com.tencent.polaris.plugins.stat.common.model.AbstractSignatureStatInfoCollector;
import com.tencent.polaris.plugins.stat.common.model.MetricValueAggregationStrategy;
import com.tencent.polaris.plugins.stat.common.model.StatRevisionMetric;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class StatInfoRevisionCollector<T>
extends AbstractSignatureStatInfoCollector<T, StatRevisionMetric> {
    private final Object mutex = new Object();
    private final AtomicLong currentRevision = new AtomicLong();

    public long incRevision() {
        return this.currentRevision.incrementAndGet();
    }

    public long getCurrentRevision() {
        return this.currentRevision.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectStatInfo(T info, Map<String, String> metricLabels, MetricValueAggregationStrategy<T>[] strategies) {
        if (null != strategies) {
            for (MetricValueAggregationStrategy<T> strategy : strategies) {
                Object object;
                HashMap<String, String> labels;
                String metricName = strategy.getStrategyName();
                Long signature = StatInfoRevisionCollector.getSignature(metricName, labels = new HashMap<String, String>(metricLabels));
                StatRevisionMetric metrics = (StatRevisionMetric)this.metricContainer.get(signature);
                if (null == metrics) {
                    object = this.mutex;
                    synchronized (object) {
                        metrics = (StatRevisionMetric)this.metricContainer.get(signature);
                        if (null == metrics) {
                            StatRevisionMetric stateMetric = new StatRevisionMetric(metricName, labels, signature, this.currentRevision.get());
                            stateMetric.setValue(strategy.initMetricValue(info));
                            this.metricContainer.put(signature, stateMetric);
                            continue;
                        }
                    }
                }
                if (this.currentRevision.get() != metrics.getRevision()) {
                    object = this.mutex;
                    synchronized (object) {
                        if (this.currentRevision.get() != metrics.getRevision()) {
                            metrics.setValue(strategy.initMetricValue(info));
                            metrics.setRevision(this.currentRevision.get());
                            continue;
                        }
                    }
                }
                strategy.updateMetricValue(metrics, info);
            }
        }
    }
}

