/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.flow.cache.expired;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.utils.ThreadPoolUtils;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.plugins.flow.cache.expired.PatternCacheItem;
import com.tencent.polaris.plugins.flow.cache.expired.PluginCacheValues;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;

public class ExpiredFlowCache
implements FlowCache {
    private final Map<String, PatternCacheItem> regexPatterns = new ConcurrentHashMap<String, PatternCacheItem>();
    private final ThreadLocal<Map<Class<?>, Queue<Object>>> threadLocalValue = new ThreadLocal();
    private final Map<Integer, PluginCacheValues> pluginValues = new ConcurrentHashMap<Integer, PluginCacheValues>();
    private ScheduledExecutorService expireExecutor;
    private long expireIntervalMs;
    private boolean enable;

    @Override
    public Pattern loadOrStoreCompiledRegex(String regexStr) {
        if (!this.enable) {
            return Pattern.compile(regexStr);
        }
        PatternCacheItem patternCacheItem = this.regexPatterns.computeIfAbsent(regexStr, s2 -> new PatternCacheItem(Pattern.compile(s2)));
        patternCacheItem.updateLastAccessTimeMs();
        return patternCacheItem.getPattern();
    }

    private <T> T createObject(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("fail to create object with type " + clazz.getCanonicalName(), e);
        }
    }

    @Override
    public <T> T borrowThreadCacheObject(Class<T> clazz) {
        Queue objects;
        Object object;
        if (!this.enable) {
            return this.createObject(clazz);
        }
        Map<Class<?>, Queue<Object>> classQueueMap = this.threadLocalValue.get();
        if (null == classQueueMap) {
            classQueueMap = new WeakHashMap();
            this.threadLocalValue.set(classQueueMap);
        }
        if (null != (object = (objects = classQueueMap.computeIfAbsent(clazz, k -> new LinkedList())).poll())) {
            return (T)object;
        }
        return this.createObject(clazz);
    }

    @Override
    public <T> void giveBackThreadCacheObject(T object) {
        if (!this.enable) {
            return;
        }
        Class<?> clazz = object.getClass();
        Map<Class<?>, Queue<Object>> classQueueMap = this.threadLocalValue.get();
        if (null == classQueueMap) {
            classQueueMap = new WeakHashMap();
            this.threadLocalValue.set(classQueueMap);
        }
        Queue objects = classQueueMap.computeIfAbsent(clazz, k -> new LinkedList());
        objects.offer(object);
    }

    @Override
    public <T> T loadPluginCacheObject(int pluginIdx, Object key, Function<Object, T> createFunc) {
        PluginCacheValues cacheValues = this.pluginValues.get(pluginIdx);
        if (null == cacheValues) {
            cacheValues = this.pluginValues.computeIfAbsent(pluginIdx, idx -> new PluginCacheValues());
        }
        return cacheValues.getOrCreateValue(key, createFunc);
    }

    @Override
    public String getName() {
        return "simpleCache";
    }

    @Override
    public PluginType getType() {
        return PluginTypes.FLOW_CACHE.getBaseType();
    }

    @Override
    public void init(InitContext ctx) throws PolarisException {
        this.enable = ctx.getConfig().getGlobal().getSystem().getFlowCache().isEnable();
        this.expireIntervalMs = ctx.getConfig().getGlobal().getSystem().getFlowCache().getExpireInterval();
        this.expireExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory(this.getName()));
    }

    @Override
    public void postContextInit(Extensions ctx) throws PolarisException {
        this.expireExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (PluginCacheValues pluginCacheValues : ExpiredFlowCache.this.pluginValues.values()) {
                    pluginCacheValues.expireValues(ExpiredFlowCache.this.expireIntervalMs);
                }
            }
        }, this.expireIntervalMs, this.expireIntervalMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void destroy() {
        ThreadPoolUtils.waitAndStopThreadPools(new ExecutorService[]{this.expireExecutor});
    }
}

