/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.config.global.ClusterType;
import com.tencent.polaris.api.config.global.ServerConnectorConfig;
import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.compose.ServerServiceInfo;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.ThreadPoolUtils;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.pojo.Node;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.grpc.ChannelTlsCertificates;
import com.tencent.polaris.plugins.connector.grpc.Connection;
import com.tencent.polaris.plugins.connector.grpc.ManagedChannelUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import shade.polaris.io.grpc.ManagedChannel;
import shade.polaris.io.grpc.ManagedChannelBuilder;

public class ConnectionManager
extends Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionManager.class);
    private final Object lock = new Object();
    private final long connectTimeoutMs;
    private final long switchIntervalMs;
    private final ScheduledExecutorService switchExecutorService;
    private final String protocol;
    private final Map<ClusterType, ServerAddressList> serverAddresses = new HashMap<ClusterType, ServerAddressList>();
    private final Map<ClusterType, CompletableFuture<String>> readyNotifiers = new HashMap<ClusterType, CompletableFuture<String>>();
    private final String clientId;
    private Extensions extensions;
    private final ChannelTlsCertificates tlsCertificates;

    public ConnectionManager(InitContext initContext, ServerConnectorConfig serverConnectorConfig, Map<ClusterType, CompletableFuture<String>> notifiers) {
        this.clientId = initContext.getValueContext().getClientId();
        this.readyNotifiers.putAll(notifiers);
        if (serverConnectorConfig == null) {
            Configuration config = initContext.getConfig();
            serverConnectorConfig = config.getGlobal().getServerConnector();
        }
        this.connectTimeoutMs = serverConnectorConfig.getConnectTimeout();
        this.protocol = serverConnectorConfig.getProtocol();
        List<String> addresses = serverConnectorConfig.getAddresses();
        this.serverAddresses.put(ClusterType.BUILTIN_CLUSTER, new ServerAddressList(addresses, ClusterType.BUILTIN_CLUSTER));
        Collection<ServerServiceInfo> serverServices = initContext.getServerServices();
        ServerServiceInfo discoverService = null;
        ServerServiceInfo healthCheckService = null;
        ServerServiceInfo configService = null;
        if (CollectionUtils.isNotEmpty(serverServices)) {
            for (ServerServiceInfo serverService : serverServices) {
                if (serverService.getClusterType() == ClusterType.SERVICE_DISCOVER_CLUSTER) {
                    discoverService = serverService;
                    continue;
                }
                if (serverService.getClusterType() == ClusterType.HEALTH_CHECK_CLUSTER) {
                    healthCheckService = serverService;
                }
                if (serverService.getClusterType() != ClusterType.SERVICE_CONFIG_CLUSTER) continue;
                configService = serverService;
            }
        }
        if (null == discoverService) {
            this.serverAddresses.put(ClusterType.SERVICE_DISCOVER_CLUSTER, new ServerAddressList(addresses, ClusterType.SERVICE_DISCOVER_CLUSTER));
        } else {
            this.serverAddresses.put(ClusterType.SERVICE_DISCOVER_CLUSTER, new ServerAddressList(discoverService, ClusterType.SERVICE_DISCOVER_CLUSTER));
        }
        if (null == configService) {
            this.serverAddresses.put(ClusterType.SERVICE_CONFIG_CLUSTER, new ServerAddressList(addresses, ClusterType.SERVICE_CONFIG_CLUSTER));
        } else {
            this.serverAddresses.put(ClusterType.SERVICE_CONFIG_CLUSTER, new ServerAddressList(configService, ClusterType.SERVICE_CONFIG_CLUSTER));
        }
        if (null == healthCheckService) {
            this.serverAddresses.put(ClusterType.HEALTH_CHECK_CLUSTER, new ServerAddressList(addresses, ClusterType.HEALTH_CHECK_CLUSTER));
        } else {
            this.serverAddresses.put(ClusterType.HEALTH_CHECK_CLUSTER, new ServerAddressList(healthCheckService, ClusterType.HEALTH_CHECK_CLUSTER));
        }
        this.switchIntervalMs = serverConnectorConfig.getServerSwitchInterval();
        this.switchExecutorService = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("connection-manager"));
        this.tlsCertificates = ChannelTlsCertificates.build(serverConnectorConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtensions(Extensions extensions) {
        Object object = this.lock;
        synchronized (object) {
            this.extensions = extensions;
        }
        this.switchExecutorService.scheduleAtFixedRate(new SwitchServerTask(), this.switchIntervalMs, this.switchIntervalMs, TimeUnit.MILLISECONDS);
    }

    public boolean checkReady(ClusterType clusterType) {
        ServerAddressList serverAddressList = this.serverAddresses.get((Object)clusterType);
        if (null == serverAddressList) {
            return false;
        }
        return serverAddressList.ready.get();
    }

    public void makeReady(ServiceEventKey serviceEventKey) {
        for (ServerAddressList serverAddressList : this.serverAddresses.values()) {
            if (!serverAddressList.checkAndSetReady(serviceEventKey)) continue;
            return;
        }
    }

    public Connection getConnection(String opKey, ClusterType clusterType) {
        Connection connection;
        do {
            try {
                connection = this.tryGetConnection(opKey, clusterType);
            }
            catch (PolarisException e) {
                LOG.error("fail to get connection, opKey is {}, cluster {}", new Object[]{opKey, clusterType, e});
                throw e;
            }
        } while (!connection.acquire());
        LOG.debug("connection id={} acquired", (Object)connection.getConnID());
        return connection;
    }

    private Connection tryGetConnection(String opKey, ClusterType clusterType) throws PolarisException {
        if (null == this.extensions) {
            throw new PolarisException(ErrorCode.INVALID_STATE, "connection manager not ready");
        }
        ServerAddressList serverAddressList = this.serverAddresses.get((Object)clusterType);
        if (null == serverAddressList) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("unknown clusterType %s", new Object[]{clusterType}));
        }
        return serverAddressList.tryGetConnection(opKey, this.connectTimeoutMs);
    }

    @Override
    public void doDestroy() {
        ThreadPoolUtils.waitAndStopThreadPools(new ExecutorService[]{this.switchExecutorService});
        for (Map.Entry<ClusterType, ServerAddressList> entry : this.serverAddresses.entrySet()) {
            ServerAddressList serverAddressList = entry.getValue();
            serverAddressList.shutdown();
        }
    }

    public void reportFailConnection(Connection.ConnID connId) {
        if (this.isDestroyed()) {
            return;
        }
        LOG.debug("connection id={} reportFailConnection", (Object)connId);
        this.switchExecutorService.execute(new SwitchTargetTask(connId));
    }

    private class ServerAddressList {
        private final ServerServiceInfo serverServiceInfo;
        private final ClusterType clusterType;
        private final AtomicReference<Connection> curConnectionValue = new AtomicReference();
        private final List<Node> nodes = new ArrayList<Node>();
        private final Object lock = new Object();
        private final AtomicBoolean ready = new AtomicBoolean(false);
        private int curIndex;

        ServerAddressList(List<String> addresses, ClusterType clusterType) {
            for (String address : addresses) {
                int colonIdx = address.lastIndexOf(":");
                String host = address.substring(0, colonIdx);
                int port = Integer.parseInt(address.substring(colonIdx + 1));
                this.nodes.add(new Node(host, port));
            }
            this.clusterType = clusterType;
            this.serverServiceInfo = null;
            this.makeReady();
        }

        ServerAddressList(ServerServiceInfo serverServiceInfo, ClusterType clusterType) {
            this.clusterType = clusterType;
            this.serverServiceInfo = serverServiceInfo;
        }

        public boolean checkAndSetReady(ServiceEventKey serviceEventKey) {
            if (null == this.serverServiceInfo) {
                return false;
            }
            if (this.serverServiceInfo.getServiceKey().equals(serviceEventKey.getServiceKey())) {
                this.makeReady();
                return true;
            }
            return false;
        }

        private void makeReady() {
            CompletableFuture future;
            LOG.info("[ServerConnector]cluster {}, service {} has been made ready", (Object)this.clusterType, (Object)this.serverServiceInfo);
            if (this.ready.compareAndSet(false, true) && null != (future = (CompletableFuture)ConnectionManager.this.readyNotifiers.get((Object)this.clusterType))) {
                future.complete("ready");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Connection tryGetConnection(String opKey, long timeoutMs) throws PolarisException {
            Connection curConnection = this.curConnectionValue.get();
            if (Connection.isAvailableConnection(curConnection)) {
                return curConnection;
            }
            Object object = this.lock;
            synchronized (object) {
                curConnection = this.curConnectionValue.get();
                if (Connection.isAvailableConnection(curConnection)) {
                    return curConnection;
                }
                Node servAddress = this.getServerAddress();
                ServiceKey svcKey = null;
                if (null != this.serverServiceInfo) {
                    svcKey = this.serverServiceInfo.getServiceKey();
                }
                Connection.ConnID connID = new Connection.ConnID(svcKey, this.clusterType, servAddress.getHost(), servAddress.getPort(), ConnectionManager.this.protocol);
                Connection connection = this.connectTarget(connID);
                if (null != curConnection) {
                    curConnection.lazyClose();
                }
                this.curConnectionValue.set(connection);
                return connection;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.lock;
            synchronized (object) {
                Connection curConnection = this.curConnectionValue.get();
                if (Connection.isAvailableConnection(curConnection)) {
                    curConnection.lazyClose();
                }
            }
        }

        private Node getServerAddress() throws PolarisException {
            if (null == this.serverServiceInfo) {
                Node node = this.nodes.get(this.curIndex % this.nodes.size());
                ++this.curIndex;
                return node;
            }
            Extensions extensions = ConnectionManager.this.extensions;
            Instance instance = this.getDiscoverInstance(extensions);
            return new Node(instance.getHost(), instance.getPort());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void switchClientOnFail(Connection.ConnID lastConn) throws PolarisException {
            Object object = this.lock;
            synchronized (object) {
                Connection curConnection = this.curConnectionValue.get();
                if (null != curConnection && !curConnection.getConnID().equals(lastConn)) {
                    return;
                }
                Node servAddress = this.getServerAddress();
                if (null == servAddress) {
                    return;
                }
                if (null != curConnection) {
                    if (servAddress.getHost().equals(curConnection.getConnID().getHost()) && servAddress.getPort() == curConnection.getConnID().getPort()) {
                        return;
                    }
                    curConnection.lazyClose();
                }
                Connection.ConnID connID = new Connection.ConnID(this.serverServiceInfo.getServiceKey(), this.clusterType, servAddress.getHost(), servAddress.getPort(), ConnectionManager.this.protocol);
                Connection connection = this.connectTarget(connID);
                this.curConnectionValue.set(connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void switchClient() throws PolarisException {
            Connection curConnection = this.curConnectionValue.get();
            if (!Connection.isAvailableConnection(curConnection)) {
                return;
            }
            LOG.info("start switch for {}", (Object)this.serverServiceInfo.getServiceKey());
            Object object = this.lock;
            synchronized (object) {
                curConnection = this.curConnectionValue.get();
                if (!Connection.isAvailableConnection(curConnection)) {
                    return;
                }
                Node servAddress = this.getServerAddress();
                if (null == servAddress) {
                    return;
                }
                if (servAddress.getHost().equals(curConnection.getConnID().getHost()) && servAddress.getPort() == curConnection.getConnID().getPort()) {
                    return;
                }
                Connection.ConnID connID = new Connection.ConnID(this.serverServiceInfo.getServiceKey(), this.clusterType, servAddress.getHost(), servAddress.getPort(), ConnectionManager.this.protocol);
                Connection connection = this.connectTarget(connID);
                curConnection.lazyClose();
                this.curConnectionValue.set(connection);
            }
        }

        private Instance getDiscoverInstance(Extensions extensions) throws PolarisException {
            ServiceKey serviceKey = this.serverServiceInfo.getServiceKey();
            Instance instance = BaseFlow.commonGetOneInstance(extensions, serviceKey, this.serverServiceInfo.getRouters(), this.serverServiceInfo.getLbPolicy(), ConnectionManager.this.protocol, ConnectionManager.this.clientId);
            LOG.info("[ConnectionManager]success to get instance for service {}, instance is {}:{}", new Object[]{serviceKey, instance.getHost(), instance.getPort()});
            return instance;
        }

        private Connection connectTarget(Connection.ConnID connID) throws PolarisException {
            try {
                Object builder = ManagedChannelBuilder.forAddress(connID.getHost(), connID.getPort()).usePlaintext();
                if (ConnectionManager.this.tlsCertificates != null) {
                    ManagedChannelUtil.setChannelTls(builder, ConnectionManager.this.tlsCertificates);
                    ((ManagedChannelBuilder)builder).useTransportSecurity();
                }
                ManagedChannel channel = ((ManagedChannelBuilder)builder).build();
                return new Connection(channel, connID, ConnectionManager.this);
            }
            catch (Throwable e) {
                throw new PolarisException(ErrorCode.NETWORK_ERROR, String.format("[ConnectionManager]fail to create connection by %s", connID.toString()), e);
            }
        }
    }

    private class SwitchServerTask
    implements Runnable {
        private SwitchServerTask() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : ConnectionManager.this.serverAddresses.entrySet()) {
                ClusterType clusterType = (ClusterType)((Object)entry.getKey());
                if (clusterType == ClusterType.BUILTIN_CLUSTER) continue;
                try {
                    ServerAddressList serverAddressList = (ServerAddressList)entry.getValue();
                    serverAddressList.switchClient();
                }
                catch (PolarisException e) {
                    LOG.error("switch client for {}, e:{}", (Object)clusterType, (Object)e);
                }
            }
        }
    }

    private class SwitchTargetTask
    implements Runnable {
        private final Connection.ConnID connID;

        public SwitchTargetTask(Connection.ConnID connID) {
            this.connID = connID;
        }

        @Override
        public void run() {
            ServerAddressList serverAddressList = (ServerAddressList)ConnectionManager.this.serverAddresses.get((Object)this.connID.getClusterType());
            if (null != serverAddressList) {
                try {
                    serverAddressList.switchClientOnFail(this.connID);
                }
                catch (PolarisException e) {
                    LOG.error("switch client on fail for {}, e:{}", (Object)this.connID, (Object)e);
                }
            }
        }
    }
}

