/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.composite;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.server.ServerEvent;
import com.tencent.polaris.api.plugin.server.ServiceEventHandler;
import com.tencent.polaris.api.pojo.DefaultInstance;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.Services;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.pb.ResponseProto;
import com.tencent.polaris.client.pb.ServiceProto;
import com.tencent.polaris.client.pojo.ServiceInstancesByProto;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.connector.common.DestroyableServerConnector;
import com.tencent.polaris.plugins.connector.common.ServiceInstancesResponse;
import com.tencent.polaris.plugins.connector.common.ServiceUpdateTask;
import com.tencent.polaris.plugins.connector.common.constant.ServiceUpdateTaskConstant;
import com.tencent.polaris.plugins.connector.composite.CompositeConnector;
import com.tencent.polaris.plugins.connector.composite.CompositeRevision;
import com.tencent.polaris.plugins.connector.grpc.GrpcServiceUpdateTask;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import shade.polaris.com.google.protobuf.BoolValue;
import shade.polaris.com.google.protobuf.StringValue;
import shade.polaris.com.google.protobuf.UInt32Value;

public class CompositeServiceUpdateTask
extends ServiceUpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeServiceUpdateTask.class);

    public CompositeServiceUpdateTask(ServiceEventHandler handler, DestroyableServerConnector connector) {
        super(handler, connector);
    }

    @Override
    protected void execute() {
        CompositeConnector connector = (CompositeConnector)this.serverConnector;
        for (DestroyableServerConnector sc : connector.getServerConnectors()) {
            if (!"grpc".equals(sc.getName()) || !sc.isDiscoveryEnable()) continue;
            GrpcServiceUpdateTask grpcServiceUpdateTask = new GrpcServiceUpdateTask(this.serviceEventHandler, sc);
            grpcServiceUpdateTask.execute(this);
            return;
        }
        boolean svcDeleted = this.notifyServerEvent(new ServerEvent(this.serviceEventKey, ResponseProto.DiscoverResponse.newBuilder().build(), null));
        if (!svcDeleted) {
            this.addUpdateTaskSet();
        }
    }

    @Override
    protected void handle(Throwable throwable) {
        LOG.error("Composite service task execute error.", throwable);
    }

    @Override
    public boolean notifyServerEvent(ServerEvent serverEvent) {
        this.taskStatus.compareAndSet(ServiceUpdateTaskConstant.Status.RUNNING, ServiceUpdateTaskConstant.Status.READY);
        this.lastUpdateTime.set(System.currentTimeMillis());
        try {
            if (serverEvent.getValue() instanceof ResponseProto.DiscoverResponse) {
                ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)serverEvent.getValue();
                ResponseProto.DiscoverResponse.Builder newDiscoverResponseBuilder = ResponseProto.DiscoverResponse.newBuilder().mergeFrom(discoverResponse);
                CompositeConnector connector = (CompositeConnector)this.serverConnector;
                if (ServiceEventKey.EventType.INSTANCE.equals((Object)this.serviceEventKey.getEventType())) {
                    serverEvent.setPolarisRevision(discoverResponse.getService().getRevision().getValue());
                    if (discoverResponse.getCode().getValue() == 200001) {
                        newDiscoverResponseBuilder.setCode(UInt32Value.newBuilder().setValue(200000).build());
                        RegistryCacheValue value = this.getEventHandler().getValue();
                        if (value != null) {
                            ServiceInstancesByProto cacheValue = (ServiceInstancesByProto)value;
                            newDiscoverResponseBuilder.addAllInstances(cacheValue.getOriginInstancesList());
                        }
                    }
                    ArrayList<DefaultInstance> extendInstanceList = new ArrayList<DefaultInstance>();
                    CompositeRevision compositeRevision = new CompositeRevision();
                    compositeRevision.setRevision("grpc", discoverResponse.getService().getRevision().getValue());
                    for (DestroyableServerConnector destroyableServerConnector : connector.getServerConnectors()) {
                        ServiceInstancesResponse serviceInstancesResponse;
                        if ("grpc".equals(destroyableServerConnector.getName()) || !destroyableServerConnector.isDiscoveryEnable() || (serviceInstancesResponse = destroyableServerConnector.syncGetServiceInstances(this)) == null) continue;
                        compositeRevision.setRevision(destroyableServerConnector.getName(), serviceInstancesResponse.getRevision());
                        if (!extendInstanceList.isEmpty()) continue;
                        extendInstanceList.addAll(serviceInstancesResponse.getServiceInstanceList());
                    }
                    List<ServiceProto.Instance> polarisInstanceList = discoverResponse.getInstancesList();
                    for (DefaultInstance i : extendInstanceList) {
                        boolean needAdd = true;
                        for (ServiceProto.Instance j : polarisInstanceList) {
                            if (!i.getHost().equals(j.getHost().getValue()) || i.getPort() != j.getPort().getValue()) continue;
                            needAdd = false;
                            break;
                        }
                        if (needAdd) {
                            ServiceProto.Instance.Builder instanceBuilder = ServiceProto.Instance.newBuilder().setNamespace(StringValue.of(this.serviceEventKey.getNamespace())).setService(StringValue.of(i.getService())).setHost(StringValue.of(i.getHost())).setPort(UInt32Value.of(i.getPort())).setHealthy(BoolValue.of(true));
                            if (StringUtils.isNotBlank(i.getId())) {
                                instanceBuilder.setId(StringValue.of(i.getId()));
                            }
                            newDiscoverResponseBuilder.addInstances(instanceBuilder.build());
                        }
                        ServiceProto.Service.Builder newServiceBuilder = ServiceProto.Service.newBuilder().mergeFrom(newDiscoverResponseBuilder.getService());
                        newServiceBuilder.setRevision(StringValue.of(compositeRevision.getCompositeRevisionString()));
                        newDiscoverResponseBuilder.setService(newServiceBuilder.build());
                    }
                    if (!newDiscoverResponseBuilder.getInstancesList().isEmpty()) {
                        serverEvent.setError(null);
                    }
                } else if (ServiceEventKey.EventType.SERVICE.equals((Object)this.serviceEventKey.getEventType())) {
                    ArrayList<ServiceInfo> extendServiceList = new ArrayList<ServiceInfo>();
                    for (DestroyableServerConnector sc : connector.getServerConnectors()) {
                        if ("grpc".equals(sc.getName()) || !sc.isDiscoveryEnable()) continue;
                        Services services = sc.syncGetServices(this);
                        if (!extendServiceList.isEmpty()) continue;
                        extendServiceList.addAll(services.getServices());
                    }
                    List<ServiceProto.Service> polarisServiceList = discoverResponse.getServicesList();
                    for (ServiceInfo serviceInfo : extendServiceList) {
                        boolean needAdd = true;
                        for (ServiceProto.Service j : polarisServiceList) {
                            if (!serviceInfo.getService().equals(j.getName().getValue())) continue;
                            needAdd = false;
                            break;
                        }
                        if (!needAdd) continue;
                        ServiceProto.Service service = ServiceProto.Service.newBuilder().setNamespace(StringValue.of(this.serviceEventKey.getNamespace())).setName(StringValue.of(serviceInfo.getService())).build();
                        newDiscoverResponseBuilder.addServices(service);
                    }
                    if (!newDiscoverResponseBuilder.getServicesList().isEmpty()) {
                        serverEvent.setError(null);
                    }
                }
                serverEvent.setValue(newDiscoverResponseBuilder.build());
            }
        }
        catch (PolarisException e) {
            LOG.error("Merge other server response failed.", (Throwable)e);
            serverEvent.setError(e);
        }
        catch (Throwable throwable) {
            LOG.error("Merge other server response failed.", throwable);
            serverEvent.setError(new PolarisException(ErrorCode.INTERNAL_ERROR));
        }
        if (null == serverEvent.getError()) {
            this.successUpdates.addAndGet(1L);
        }
        return this.getEventHandler().onEventUpdate(serverEvent);
    }
}

