/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.util;

import com.tencent.polaris.api.utils.StringUtils;
import java.util.Map;
import shade.polaris.com.fasterxml.jackson.databind.ObjectMapper;

public class ConfigUtils {
    public static Map<?, ?> objectToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        return mapper.convertValue(obj, Map.class);
    }

    public static void validateInterval(Long interval, String name) {
        if (null == interval || interval == 0L) {
            throw new IllegalArgumentException(name + " must not be empty or 0");
        }
    }

    public static void validateTimes(Integer times, String name) {
        if (null == times || times < 0) {
            throw new IllegalArgumentException(name + " must not be empty or 0");
        }
    }

    public static void validateIntervalWithMin(Long interval, long minInterval, String name) {
        if (null == interval || interval == 0L || interval < minInterval) {
            throw new IllegalArgumentException(name + " must not be empty or 0, and must be greater than " + minInterval);
        }
    }

    public static void validateString(String value, String name) {
        if (StringUtils.isBlank(value)) {
            throw new IllegalArgumentException(name + " must not be empty");
        }
    }

    public static void validateNull(Object value, String name) {
        if (null == value) {
            throw new IllegalArgumentException(name + " must not be empty");
        }
    }

    public static void validateAllNull(Map<String, Object> valueMap) {
        StringBuilder nameListStr = null;
        int count = 0;
        for (String key : valueMap.keySet()) {
            if (null != valueMap.get(key)) continue;
            if (null == nameListStr) {
                nameListStr = new StringBuilder(key);
            } else {
                nameListStr.append(", ").append(key);
            }
            ++count;
        }
        if (count == valueMap.keySet().size()) {
            throw new IllegalArgumentException(nameListStr + " must not be all null.");
        }
    }

    public static void validatePositive(Integer value, String name) {
        if (null == value || value <= 0) {
            throw new IllegalArgumentException(name + " must not be negative");
        }
    }

    public static void validateTrue(Boolean value, String name) {
        if (null == value || !value.booleanValue()) {
            throw new IllegalArgumentException(name + " must not be false");
        }
    }
}

