/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.consumer;

import com.tencent.polaris.api.config.consumer.ConsumerConfig;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.factory.config.consumer.CircuitBreakerConfigImpl;
import com.tencent.polaris.factory.config.consumer.DiscoveryConfigImpl;
import com.tencent.polaris.factory.config.consumer.LoadBalanceConfigImpl;
import com.tencent.polaris.factory.config.consumer.LocalCacheConfigImpl;
import com.tencent.polaris.factory.config.consumer.OutlierDetectionConfigImpl;
import com.tencent.polaris.factory.config.consumer.ServiceRouterConfigImpl;
import com.tencent.polaris.factory.config.consumer.SubscribeConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import shade.polaris.com.fasterxml.jackson.annotation.JsonIgnore;
import shade.polaris.com.fasterxml.jackson.annotation.JsonProperty;

public class ConsumerConfigImpl
implements ConsumerConfig {
    @JsonProperty
    private LocalCacheConfigImpl localCache;
    @JsonProperty
    private ServiceRouterConfigImpl serviceRouter;
    @JsonProperty
    private LoadBalanceConfigImpl loadbalancer;
    @JsonProperty
    private CircuitBreakerConfigImpl circuitBreaker;
    @JsonProperty
    private OutlierDetectionConfigImpl outlierDetection;
    @JsonProperty
    private SubscribeConfigImpl subscribe;
    @JsonProperty
    private List<DiscoveryConfigImpl> discoveries;
    @JsonIgnore
    private Map<String, DiscoveryConfigImpl> discoveryConfigMap = new ConcurrentHashMap<String, DiscoveryConfigImpl>();

    @Override
    public LocalCacheConfigImpl getLocalCache() {
        return this.localCache;
    }

    @Override
    public ServiceRouterConfigImpl getServiceRouter() {
        return this.serviceRouter;
    }

    @Override
    public LoadBalanceConfigImpl getLoadbalancer() {
        return this.loadbalancer;
    }

    @Override
    public CircuitBreakerConfigImpl getCircuitBreaker() {
        return this.circuitBreaker;
    }

    @Override
    public OutlierDetectionConfigImpl getOutlierDetection() {
        return this.outlierDetection;
    }

    @Override
    public SubscribeConfigImpl getSubscribe() {
        return this.subscribe;
    }

    public List<DiscoveryConfigImpl> getDiscoveries() {
        if (CollectionUtils.isEmpty(this.discoveries)) {
            this.discoveries = new ArrayList<DiscoveryConfigImpl>();
        }
        return this.discoveries;
    }

    public void setDiscoveries(List<DiscoveryConfigImpl> discoveries) {
        if (CollectionUtils.isNotEmpty(discoveries)) {
            for (DiscoveryConfigImpl discoveryConfig : discoveries) {
                if (this.discoveryConfigMap.containsKey(discoveryConfig.getServerConnectorId())) {
                    throw new IllegalArgumentException(String.format("Discovery config of [%s] is already exist.", discoveryConfig.getServerConnectorId()));
                }
                this.discoveryConfigMap.put(discoveryConfig.getServerConnectorId(), discoveryConfig);
            }
        }
        this.discoveries = discoveries;
    }

    public Map<String, DiscoveryConfigImpl> getDiscoveryConfigMap() {
        return this.discoveryConfigMap;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.localCache, "localCache");
        ConfigUtils.validateNull(this.serviceRouter, "serviceRouter");
        ConfigUtils.validateNull(this.loadbalancer, "loadbalancer");
        ConfigUtils.validateNull(this.circuitBreaker, "circuitBreaker");
        ConfigUtils.validateNull(this.outlierDetection, "outlierDetection");
        this.localCache.verify();
        this.serviceRouter.verify();
        this.loadbalancer.verify();
        this.circuitBreaker.verify();
        this.outlierDetection.verify();
        this.subscribe.verify();
        if (CollectionUtils.isNotEmpty(this.discoveries)) {
            for (DiscoveryConfigImpl discoveryConfig : this.discoveries) {
                discoveryConfig.verify();
            }
        }
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null == this.localCache) {
            this.localCache = new LocalCacheConfigImpl();
        }
        if (null == this.serviceRouter) {
            this.serviceRouter = new ServiceRouterConfigImpl();
        }
        if (null == this.loadbalancer) {
            this.loadbalancer = new LoadBalanceConfigImpl();
        }
        if (null == this.circuitBreaker) {
            this.circuitBreaker = new CircuitBreakerConfigImpl();
        }
        if (null == this.outlierDetection) {
            this.outlierDetection = new OutlierDetectionConfigImpl();
        }
        if (null == this.subscribe) {
            this.subscribe = new SubscribeConfigImpl();
        }
        if (null != defaultObject) {
            ConsumerConfig consumerConfig = (ConsumerConfig)defaultObject;
            this.localCache.setDefault(consumerConfig.getLocalCache());
            this.serviceRouter.setDefault(consumerConfig.getServiceRouter());
            this.loadbalancer.setDefault(consumerConfig.getLoadbalancer());
            this.circuitBreaker.setDefault(consumerConfig.getCircuitBreaker());
            this.outlierDetection.setDefault(consumerConfig.getOutlierDetection());
            this.subscribe.setDefault(consumerConfig.getSubscribe());
            if (CollectionUtils.isNotEmpty(this.discoveries)) {
                for (DiscoveryConfigImpl discoveryConfig : this.discoveries) {
                    discoveryConfig.setDefault(consumerConfig.getDiscoveries().get(0));
                }
            } else {
                this.discoveries = new ArrayList<DiscoveryConfigImpl>();
            }
        }
    }

    public String toString() {
        return "ConsumerConfigImpl{localCache=" + this.localCache + ", serviceRouter=" + this.serviceRouter + ", loadbalancer=" + this.loadbalancer + ", circuitBreaker=" + this.circuitBreaker + ", outlierDetection=" + this.outlierDetection + '}';
    }
}

