/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.util;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.rpc.BaseEntity;
import com.tencent.polaris.api.rpc.GetAllInstancesRequest;
import com.tencent.polaris.api.rpc.GetHealthyInstancesRequest;
import com.tencent.polaris.api.rpc.GetInstancesRequest;
import com.tencent.polaris.api.rpc.GetOneInstanceRequest;
import com.tencent.polaris.api.rpc.GetResourcesRequest;
import com.tencent.polaris.api.rpc.GetServiceRuleRequest;
import com.tencent.polaris.api.rpc.InstanceDeregisterRequest;
import com.tencent.polaris.api.rpc.InstanceHeartbeatRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.rpc.UnWatchServiceRequest;
import com.tencent.polaris.api.rpc.WatchServiceRequest;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.util.CommonValidator;
import java.util.Set;

public class Validator {
    private static final int MAX_PORT = 65536;

    public static void validateGetResourcesRequest(GetResourcesRequest request) throws PolarisException {
        Set<ServiceEventKey> svcEventKeys = request.getSvcEventKeys();
        if (CollectionUtils.isEmpty(svcEventKeys)) {
            return;
        }
        for (ServiceEventKey svcEventKey : svcEventKeys) {
            ServiceKey serviceKey = svcEventKey.getServiceKey();
            ServiceEventKey.EventType eventType = svcEventKey.getEventType();
            if (null == serviceKey || null == eventType) {
                throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "missing service key or event type");
            }
            CommonValidator.validateNamespaceService(serviceKey.getNamespace(), serviceKey.getService());
        }
    }

    public static void validateGetOneInstanceRequest(GetOneInstanceRequest request) throws PolarisException {
        Validator.checkCommon(request);
    }

    public static void validateGetInstancesRequest(GetInstancesRequest request) throws PolarisException {
        Validator.checkCommon(request);
    }

    public static void validateGetAllInstancesRequest(GetAllInstancesRequest request) throws PolarisException {
        Validator.checkCommon(request);
    }

    public static void validateGetHealthyInstancesRequest(GetHealthyInstancesRequest request) throws PolarisException {
        Validator.checkCommon(request);
    }

    public static void validateGetServiceRuleRequest(GetServiceRuleRequest request) throws PolarisException {
        Validator.checkCommon(request);
        if (request.getRuleType() == ServiceEventKey.EventType.INSTANCE) {
            throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "event type can not be instance");
        }
    }

    public static void validateWatchServiceRequest(WatchServiceRequest request) throws PolarisException {
        CommonValidator.validateNamespaceService(request.getNamespace(), request.getService());
    }

    public static void validateUnWatchServiceRequest(UnWatchServiceRequest request) throws PolarisException {
        CommonValidator.validateNamespaceService(request.getNamespace(), request.getService());
    }

    public static void validateServiceCallResult(ServiceCallResult serviceCallResult) throws PolarisException {
        CommonValidator.validateNamespaceService(serviceCallResult.getNamespace(), serviceCallResult.getService());
        Validator.validateHostPort(serviceCallResult.getHost(), serviceCallResult.getPort());
        if (null == serviceCallResult.getRetStatus()) {
            throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "retStatus can not be blank");
        }
        if (null != serviceCallResult.getDelay() && serviceCallResult.getDelay() < 0L) {
            throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "delay can not be less than 0");
        }
    }

    private static void validateHostPort(String host, Integer port) throws PolarisException {
        if (StringUtils.isBlank(host)) {
            throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "host can not be blank");
        }
        if (port == null) {
            throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "port can not be null");
        }
        if (port <= 0 || port >= 65536) {
            throw new PolarisException(ErrorCode.API_INVALID_ARGUMENT, "port value should be in range (0, 65536).");
        }
    }

    public static void validateInstanceRegisterRequest(InstanceRegisterRequest request) throws PolarisException {
        Validator.checkCommon(request);
        Validator.validateHostPort(request.getHost(), request.getPort());
    }

    public static void validateInstanceDeregisterRequest(InstanceDeregisterRequest request) throws PolarisException {
        if (StringUtils.isNotBlank(request.getInstanceID())) {
            return;
        }
        CommonValidator.validateNamespaceService(request.getNamespace(), request.getService());
        Validator.validateHostPort(request.getHost(), request.getPort());
    }

    public static void validateHeartbeatRequest(InstanceHeartbeatRequest request) throws PolarisException {
        if (StringUtils.isNotBlank(request.getInstanceID())) {
            return;
        }
        Validator.validateHostPort(request.getHost(), request.getPort());
        CommonValidator.validateNamespaceService(request.getNamespace(), request.getService());
    }

    private static void checkCommon(BaseEntity entity) throws PolarisException {
        CommonValidator.validateNamespaceService(entity.getNamespace(), entity.getService());
    }
}

