/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.configuration.client.factory;

import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.client.JustForTest;
import com.tencent.polaris.configuration.client.factory.ConfigFileFactory;
import com.tencent.polaris.configuration.client.factory.ConfigFileFactoryManager;
import com.tencent.polaris.configuration.client.factory.DefaultConfigFileFactory;
import java.util.Map;
import shade.polaris.com.google.common.collect.Maps;

public class DefaultConfigFileFactoryManager
implements ConfigFileFactoryManager {
    private final Map<ConfigFileMetadata, ConfigFileFactory> factories = Maps.newConcurrentMap();
    private static DefaultConfigFileFactoryManager instance;
    private final SDKContext sdkContext;
    private ConfigFileFactory defaultConfigFileFactory;

    private DefaultConfigFileFactoryManager(SDKContext sdkContext) {
        this.sdkContext = sdkContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultConfigFileFactoryManager getInstance(SDKContext sdkContext) {
        if (instance != null) return instance;
        Class<DefaultConfigFileFactoryManager> clazz = DefaultConfigFileFactoryManager.class;
        synchronized (DefaultConfigFileFactoryManager.class) {
            if (instance != null) return instance;
            instance = new DefaultConfigFileFactoryManager(sdkContext);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public ConfigFileFactory getFactory(ConfigFileMetadata configFileMetadata) {
        ConfigFileFactory factory = this.factories.get(configFileMetadata);
        if (factory != null) {
            return factory;
        }
        if (this.defaultConfigFileFactory == null) {
            this.defaultConfigFileFactory = DefaultConfigFileFactory.getInstance(this.sdkContext);
        }
        this.factories.put(configFileMetadata, this.defaultConfigFileFactory);
        return this.defaultConfigFileFactory;
    }

    @JustForTest
    void setDefaultConfigFileFactory(ConfigFileFactory factory) {
        this.defaultConfigFileFactory = factory;
    }
}

