/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.utils;

import java.util.Objects;

public class StringUtils {
    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String defaultString(String value) {
        if (null == value) {
            return "";
        }
        return value;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean equals(String str1, String str2) {
        return Objects.equals(str1, str2);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isAllEmpty(String ... str) {
        for (String s2 : str) {
            if (StringUtils.isEmpty(s2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (!StringUtils.isEmpty(text) && !StringUtils.isEmpty(searchString) && replacement != null && max != 0) {
            int start = 0;
            int end = text.indexOf(searchString, start);
            if (end == -1) {
                return text;
            }
            int replLength = searchString.length();
            int increase = replacement.length() - replLength;
            int n = increase = increase < 0 ? 0 : increase;
            StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
            while (end != -1) {
                buf.append(text.substring(start, end)).append(replacement);
                start = end + replLength;
                if (--max == 0) break;
                end = text.indexOf(searchString, start);
            }
            buf.append(text.substring(start));
            return buf.toString();
        }
        return text;
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        if (index + substring.length() > str.length()) {
            return false;
        }
        for (int i = 0; i < substring.length(); ++i) {
            if (str.charAt(index + i) == substring.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

