/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.compose;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.config.global.LocationConfig;
import com.tencent.polaris.api.config.global.LocationProviderConfig;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.Plugin;
import com.tencent.polaris.api.plugin.Supplier;
import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.circuitbreaker.CircuitBreaker;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.common.ValueContext;
import com.tencent.polaris.api.plugin.compose.DefaultRouterChainGroup;
import com.tencent.polaris.api.plugin.compose.RouterChainGroup;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.plugin.loadbalance.LoadBalancer;
import com.tencent.polaris.api.plugin.location.LocationProvider;
import com.tencent.polaris.api.plugin.registry.LocalRegistry;
import com.tencent.polaris.api.plugin.route.LocationLevel;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.plugin.server.ServerConnector;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.pb.ModelProto;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;

public class Extensions {
    private static final Logger LOG = LoggerFactory.getLogger(Extensions.class);
    private final List<CircuitBreaker> circuitBreakers = new ArrayList<CircuitBreaker>();
    private final List<HealthChecker> healthCheckers = new ArrayList<HealthChecker>();
    private LocalRegistry localRegistry;
    private ServerConnector serverConnector;
    private LoadBalancer loadBalancer;
    private Configuration configuration;
    private Supplier plugins;
    private RouterChainGroup sysRouterChainGroup;
    private RouterChainGroup configRouterChainGroup;
    private FlowCache flowCache;
    private ValueContext valueContext;

    public static List<ServiceRouter> loadServiceRouters(List<String> routerChain, Supplier plugins, boolean force) {
        ArrayList<ServiceRouter> routers = new ArrayList<ServiceRouter>();
        if (CollectionUtils.isNotEmpty(routerChain)) {
            for (String routerName : routerChain) {
                Plugin routerPlugin = force ? plugins.getPlugin(PluginTypes.SERVICE_ROUTER.getBaseType(), routerName) : plugins.getOptionalPlugin(PluginTypes.SERVICE_ROUTER.getBaseType(), routerName);
                if (null == routerPlugin) {
                    LOG.warn("router {} not found", (Object)routerName);
                    continue;
                }
                routers.add((ServiceRouter)routerPlugin);
            }
        }
        return Collections.unmodifiableList(routers);
    }

    public void init(Configuration config, Supplier plugins, ValueContext valueContext) throws PolarisException {
        this.configuration = config;
        this.plugins = plugins;
        this.valueContext = valueContext;
        String localCacheType = config.getConsumer().getLocalCache().getType();
        this.localRegistry = (LocalRegistry)plugins.getPlugin(PluginTypes.LOCAL_REGISTRY.getBaseType(), localCacheType);
        String flowCacheName = config.getGlobal().getSystem().getFlowCache().getName();
        this.flowCache = (FlowCache)plugins.getPlugin(PluginTypes.FLOW_CACHE.getBaseType(), flowCacheName);
        String loadBalanceType = config.getConsumer().getLoadbalancer().getType();
        this.loadBalancer = (LoadBalancer)plugins.getPlugin(PluginTypes.LOAD_BALANCER.getBaseType(), loadBalanceType);
        List<ServiceRouter> beforeRouters = Extensions.loadServiceRouters(config.getConsumer().getServiceRouter().getBeforeChain(), plugins, true);
        List<ServiceRouter> coreRouters = Extensions.loadServiceRouters(config.getConsumer().getServiceRouter().getChain(), plugins, false);
        List<ServiceRouter> afterRouters = Extensions.loadServiceRouters(config.getConsumer().getServiceRouter().getAfterChain(), plugins, true);
        this.configRouterChainGroup = new DefaultRouterChainGroup(beforeRouters, coreRouters, afterRouters);
        ArrayList<String> sysBefore = new ArrayList<String>();
        sysBefore.add("isolatedRouter");
        ArrayList<String> sysAfter = new ArrayList<String>();
        sysAfter.add("recoverRouter");
        List<ServiceRouter> sysBeforeRouters = Extensions.loadServiceRouters(sysBefore, plugins, true);
        List<ServiceRouter> sysAfterRouters = Extensions.loadServiceRouters(sysAfter, plugins, true);
        this.sysRouterChainGroup = new DefaultRouterChainGroup(sysBeforeRouters, Collections.emptyList(), sysAfterRouters);
        boolean enable = config.getConsumer().getCircuitBreaker().isEnable();
        List<String> cbChain = config.getConsumer().getCircuitBreaker().getChain();
        if (enable && CollectionUtils.isNotEmpty(cbChain)) {
            for (String cbName : cbChain) {
                Plugin pluginValue = plugins.getOptionalPlugin(PluginTypes.CIRCUIT_BREAKER.getBaseType(), cbName);
                if (null == pluginValue) {
                    LOG.warn("circuitBreaker plugin {} not found", (Object)cbName);
                    continue;
                }
                this.circuitBreakers.add((CircuitBreaker)pluginValue);
            }
        }
        this.loadOutlierDetector(config, plugins);
        this.serverConnector = (ServerConnector)plugins.getPlugin(PluginTypes.SERVER_CONNECTOR.getBaseType(), valueContext.getServerConnectorProtocol());
        this.initLocation(config, valueContext);
    }

    public ValueContext getValueContext() {
        return this.valueContext;
    }

    private void initLocation(Configuration config, ValueContext valueContext) {
        LocationConfig locationConfig = config.getGlobal().getLocation();
        ArrayList<LocationProvider> providers = new ArrayList<LocationProvider>();
        for (LocationProviderConfig locationProviderConfig : locationConfig.getProviders()) {
            Plugin pluginValue = this.plugins.getOptionalPlugin(PluginTypes.LOCAL_PROVIDER.getBaseType(), locationProviderConfig.getTye());
            if (null == pluginValue) {
                LOG.warn("locationProvider plugin {} not found", (Object)locationProviderConfig.getTye());
                continue;
            }
            providers.add((LocationProvider)pluginValue);
        }
        providers.sort(Comparator.comparingInt(o -> o.getProviderType().getPriority()));
        for (LocationProvider locationProvider : providers) {
            ModelProto.Location location = locationProvider.getLocation();
            if (location == null) {
                LOG.info("locationProvider plugin {} not found location", (Object)locationProvider.getName());
                continue;
            }
            valueContext.setValue(LocationLevel.region.name(), location.getRegion().getValue());
            valueContext.setValue(LocationLevel.zone.name(), location.getZone().getValue());
            valueContext.setValue(LocationLevel.campus.name(), location.getCampus().getValue());
            valueContext.notifyAllForLocationReady();
            break;
        }
    }

    private void loadOutlierDetector(Configuration config, Supplier plugins) throws PolarisException {
        boolean enable = config.getConsumer().getOutlierDetection().getWhen() != OutlierDetectionConfig.When.never;
        List<String> detectionChain = config.getConsumer().getOutlierDetection().getChain();
        if (enable && CollectionUtils.isNotEmpty(detectionChain)) {
            for (String detectorName : detectionChain) {
                Plugin pluginValue = plugins.getOptionalPlugin(PluginTypes.HEALTH_CHECKER.getBaseType(), detectorName);
                if (null == pluginValue) {
                    LOG.warn("outlierDetector plugin {} not found", (Object)detectorName);
                    continue;
                }
                this.healthCheckers.add((HealthChecker)pluginValue);
            }
        }
    }

    public Supplier getPlugins() {
        return this.plugins;
    }

    public LocalRegistry getLocalRegistry() {
        return this.localRegistry;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public List<CircuitBreaker> getCircuitBreakers() {
        return this.circuitBreakers;
    }

    public List<HealthChecker> getHealthCheckers() {
        return this.healthCheckers;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ServerConnector getServerConnector() {
        return this.serverConnector;
    }

    public RouterChainGroup getSysRouterChainGroup() {
        return this.sysRouterChainGroup;
    }

    public RouterChainGroup getConfigRouterChainGroup() {
        return this.configRouterChainGroup;
    }

    public FlowCache getFlowCache() {
        return this.flowCache;
    }
}

